/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import mmcorej.DeviceType;
import mmcorej.MMCoreJ;
import mmcorej.StrVector;
import org.micromanager.conf.MMConfigFileException;
import org.micromanager.conf.PagePanel;
import org.micromanager.utils.GUIUtils;

public class RolesPage
extends PagePanel {
    private JComboBox focusComboBox_;
    private JComboBox shutterComboBox_;
    private JComboBox cameraComboBox_;
    private JCheckBox autoshutterCheckBox_;

    public RolesPage(Preferences preferences) {
        this.title_ = "Select default devices and choose auto-shutter setting";
        this.helpText_ = "Default device roles must be defined so that GUI can send adequate commands to them.\nThis is especially important for systems with multiple cameras, shutters or stages. The GUI needs to know which ones are going to be treated as default.\n\nThese roles can be changed on-the-fly thorugh configuration presets (in one of the subsequent steps).";
        this.prefs_ = preferences;
        this.setLayout(null);
        JLabel jLabel = new JLabel();
        jLabel.setText("Default camera");
        jLabel.setBounds(21, 11, 120, 24);
        this.add(jLabel);
        this.cameraComboBox_ = new JComboBox();
        this.cameraComboBox_.setAutoscrolls(true);
        this.cameraComboBox_.setBounds(20, 35, 120, 22);
        this.cameraComboBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RolesPage.this.model_.setDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreCamera(), (String)RolesPage.this.cameraComboBox_.getSelectedItem());
                }
                catch (MMConfigFileException mMConfigFileException) {
                    RolesPage.this.handleError(mMConfigFileException.getMessage());
                }
            }
        });
        this.add(this.cameraComboBox_);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Default shutter");
        jLabel2.setBounds(22, 69, 120, 24);
        this.add(jLabel2);
        this.shutterComboBox_ = new JComboBox();
        this.shutterComboBox_.setBounds(21, 93, 120, 22);
        this.shutterComboBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RolesPage.this.model_.setDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreShutter(), (String)RolesPage.this.shutterComboBox_.getSelectedItem());
                }
                catch (MMConfigFileException mMConfigFileException) {
                    RolesPage.this.handleError(mMConfigFileException.getMessage());
                }
            }
        });
        this.add(this.shutterComboBox_);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Default focus stage");
        jLabel3.setBounds(23, 128, 120, 24);
        this.add(jLabel3);
        this.focusComboBox_ = new JComboBox();
        this.focusComboBox_.setBounds(22, 152, 120, 22);
        this.focusComboBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RolesPage.this.model_.setDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreFocus(), (String)RolesPage.this.focusComboBox_.getSelectedItem());
                }
                catch (MMConfigFileException mMConfigFileException) {
                    RolesPage.this.handleError(mMConfigFileException.getMessage());
                }
            }
        });
        this.add(this.focusComboBox_);
        this.autoshutterCheckBox_ = new JCheckBox();
        this.autoshutterCheckBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = new String();
                    string = RolesPage.this.autoshutterCheckBox_.isSelected() ? "1" : "0";
                    RolesPage.this.model_.setDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreAutoShutter(), string);
                }
                catch (MMConfigFileException mMConfigFileException) {
                    RolesPage.this.handleError(mMConfigFileException.getMessage());
                }
            }
        });
        this.autoshutterCheckBox_.setText("Auto-shutter");
        this.autoshutterCheckBox_.setBounds(21, 192, 101, 23);
        this.add(this.autoshutterCheckBox_);
    }

    public boolean enterPage(boolean bl) {
        int n;
        String[] stringArray;
        StrVector strVector = null;
        StrVector strVector2 = null;
        StrVector strVector3 = null;
        try {
            strVector = this.core_.getLoadedDevicesOfType(DeviceType.CameraDevice);
            strVector2 = this.core_.getLoadedDevicesOfType(DeviceType.ShutterDevice);
            strVector3 = this.core_.getLoadedDevicesOfType(DeviceType.StageDevice);
        }
        catch (Exception exception) {
            this.handleException(exception);
            return false;
        }
        if (strVector != null) {
            stringArray = new String[(int)strVector.size() + 1];
            stringArray[0] = "";
            n = 0;
            while ((long)n < strVector.size()) {
                stringArray[n + 1] = strVector.get(n);
                ++n;
            }
            GUIUtils.replaceComboContents((JComboBox)this.cameraComboBox_, (String[])stringArray);
        }
        if (strVector2 != null) {
            stringArray = new String[(int)strVector2.size() + 1];
            stringArray[0] = "";
            n = 0;
            while ((long)n < strVector2.size()) {
                stringArray[n + 1] = strVector2.get(n);
                ++n;
            }
            GUIUtils.replaceComboContents((JComboBox)this.shutterComboBox_, (String[])stringArray);
        }
        if (strVector3 != null) {
            stringArray = new String[(int)strVector3.size() + 1];
            stringArray[0] = "";
            n = 0;
            while ((long)n < strVector3.size()) {
                stringArray[n + 1] = strVector3.get(n);
                ++n;
            }
            GUIUtils.replaceComboContents((JComboBox)this.focusComboBox_, (String[])stringArray);
        }
        try {
            stringArray = this.model_.getDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreCamera());
            this.cameraComboBox_.setSelectedItem(stringArray);
            String string = this.model_.getDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreShutter());
            this.shutterComboBox_.setSelectedItem(string);
            String string2 = this.model_.getDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreFocus());
            GUIUtils.setComboSelection((JComboBox)this.focusComboBox_, (String)string2);
            String string3 = this.model_.getDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreAutoShutter());
            if (string3.compareTo("1") == 0) {
                this.autoshutterCheckBox_.setSelected(true);
            } else {
                this.autoshutterCheckBox_.setSelected(false);
            }
        }
        catch (MMConfigFileException mMConfigFileException) {
            this.handleError(mMConfigFileException.getMessage());
        }
        return true;
    }

    public boolean exitPage(boolean bl) {
        return true;
    }

    public void refresh() {
    }

    public void loadSettings() {
    }

    public void saveSettings() {
    }
}

