/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.micromanager.conf.Device;
import org.micromanager.conf.MicroscopeModel;
import org.micromanager.conf.PagePanel;
import org.micromanager.conf.Property;
import org.micromanager.conf.Setting;

class PropertyTableModel
extends AbstractTableModel {
    private final PagePanel parentPage_;
    private static final long serialVersionUID = 1L;
    public final String[] COLUMN_NAMES = new String[]{"Device", "Property", "Value"};
    MicroscopeModel model_;
    Device[] devices_;
    Property[] props_;
    String[] devNames_;

    public PropertyTableModel(PagePanel pagePanel, MicroscopeModel microscopeModel, boolean bl) {
        int n;
        this.parentPage_ = pagePanel;
        this.devices_ = microscopeModel.getDevices();
        this.model_ = microscopeModel;
        ArrayList<Property> arrayList = new ArrayList<Property>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < this.devices_.length; ++n) {
            for (int i = 0; i < this.devices_[n].getNumberOfProperties(); ++i) {
                Property property = this.devices_[n].getProperty(i);
                if (bl) {
                    if (property.readOnly_ || !property.preInit_) continue;
                    arrayList.add(property);
                    arrayList2.add(this.devices_[n].getName());
                    continue;
                }
                if (property.readOnly_) continue;
                arrayList.add(property);
                arrayList2.add(this.devices_[n].getName());
            }
        }
        this.props_ = new Property[arrayList.size()];
        this.devNames_ = new String[arrayList2.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            this.props_[n] = (Property)arrayList.get(n);
            this.devNames_[n] = (String)arrayList2.get(n);
        }
    }

    public int getRowCount() {
        return this.props_.length;
    }

    public int getColumnCount() {
        return this.COLUMN_NAMES.length;
    }

    public String getColumnName(int n) {
        return this.COLUMN_NAMES[n];
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.devNames_[n];
        }
        if (n2 == 1) {
            return this.props_[n].name_;
        }
        return this.props_[n].value_;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 2) {
            try {
                this.props_[n].value_ = (String)object;
                this.fireTableCellUpdated(n, n2);
            }
            catch (Exception exception) {
                this.parentPage_.handleError(exception.getMessage());
            }
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 2 && !this.props_[n].readOnly_;
    }

    public void refresh() {
        this.fireTableDataChanged();
    }

    public Property getPropertyItem(int n) {
        return this.props_[n];
    }

    public Setting getSetting(int n) {
        return new Setting(this.devNames_[n], this.props_[n].name_, this.props_[n].value_);
    }

    public Property getProperty(Setting setting) {
        for (int i = 0; i < this.devices_.length; ++i) {
            if (this.devices_[i].getName().compareTo(setting.deviceName_) != 0) continue;
            return this.devices_[i].findSetupProperty(setting.propertyName_);
        }
        return null;
    }
}

