/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.micromanager.conf.ConfigGroup;
import org.micromanager.conf.ConfigPreset;
import org.micromanager.conf.PagePanel;
import org.micromanager.conf.PropertyCellEditor;
import org.micromanager.conf.PropertyCellRenderer;
import org.micromanager.conf.PropertyTableModel;
import org.micromanager.conf.Setting;

public class PresetsPage
extends PagePanel {
    private JTable propTable_;
    private JTree groupTree_;

    public PresetsPage(Preferences preferences) {
        this.title_ = "Define or edit configuration presets";
        this.helpText_ = "Presets are groups of multiple commands that can be executed with a single action in the GUI. Presets are organized in groups (top level in the configuration tree). Each group can have one or more presets and each preset can contain one or more commands.\n\nTo add a configuration preset first select a configuration group, then select the command in the left-hand list and press -Add- button.";
        this.prefs_ = preferences;
        this.setLayout(null);
        JLabel jLabel = new JLabel();
        jLabel.setText("Configuration presets:");
        jLabel.setBounds(10, 3, 161, 21);
        this.add(jLabel);
        this.groupTree_ = new JTree();
        this.groupTree_.setRootVisible(false);
        this.groupTree_.setBorder(new LineBorder(Color.black, 1, false));
        this.groupTree_.setAutoscrolls(true);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBounds(10, 27, 250, 200);
        this.add(jScrollPane);
        jScrollPane.setViewportView(this.groupTree_);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setBounds(278, 26, 283, 200);
        this.add(jScrollPane2);
        this.propTable_ = new JTable();
        this.propTable_.setSelectionForeground(Color.BLACK);
        this.propTable_.setSelectionBackground(Color.GRAY);
        this.propTable_.setSelectionMode(0);
        this.propTable_.setAutoCreateColumnsFromModel(false);
        jScrollPane2.setViewportView(this.propTable_);
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PresetsPage.this.removeSetting();
            }
        });
        jButton.setText("Remove");
        jButton.setBounds(167, 231, 93, 23);
        this.add(jButton);
        JButton jButton2 = new JButton();
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PresetsPage.this.addNewGroup();
            }
        });
        jButton2.setText("New Group");
        jButton2.setBounds(10, 231, 93, 23);
        this.add(jButton2);
        JButton jButton3 = new JButton();
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PresetsPage.this.addSetting();
            }
        });
        jButton3.setText("<< Add");
        jButton3.setBounds(278, 231, 93, 23);
        this.add(jButton3);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Available properties:");
        jLabel2.setBounds(278, 6, 283, 14);
        this.add(jLabel2);
        JButton jButton4 = new JButton();
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PresetsPage.this.addNewPreset();
            }
        });
        jButton4.setText("New Preset");
        jButton4.setBounds(10, 257, 93, 23);
        this.add(jButton4);
        JButton jButton5 = new JButton();
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PresetsPage.this.editNode();
            }
        });
        jButton5.setText("Edit");
        jButton5.setBounds(167, 257, 93, 23);
        this.add(jButton5);
    }

    public boolean enterPage(boolean bl) {
        this.buildTree();
        this.buildTable();
        return true;
    }

    public boolean exitPage(boolean bl) {
        try {
            this.model_.applySetupConfigsToHardware(this.core_);
        }
        catch (Exception exception) {
            this.handleError(exception.getMessage());
            return false;
        }
        return true;
    }

    public void refresh() {
    }

    public void loadSettings() {
    }

    public void saveSettings() {
    }

    private void buildTree() {
        String[] stringArray = this.model_.getConfigGroupList();
        Object[] objectArray = new Object[stringArray.length];
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Root");
        for (int i = 0; i < stringArray.length; ++i) {
            ConfigGroup configGroup = this.model_.findConfigGroup(stringArray[i]);
            if (configGroup == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(configGroup);
            ConfigPreset[] configPresetArray = configGroup.getConfigPresets();
            for (int j = 0; j < configPresetArray.length; ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(configPresetArray[j]);
                for (int k = 0; k < configPresetArray[j].getNumberOfSettings(); ++k) {
                    Setting setting = configPresetArray[j].getSetting(k);
                    DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(setting);
                    defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                }
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            objectArray[i] = defaultMutableTreeNode2;
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.groupTree_.setModel(defaultTreeModel);
    }

    DefaultMutableTreeNode makeNode(ConfigPreset configPreset) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(configPreset);
        return defaultMutableTreeNode;
    }

    private void buildTable() {
        PropertyTableModel propertyTableModel = new PropertyTableModel(this, this.model_, false);
        this.propTable_.setModel(propertyTableModel);
        PropertyCellEditor propertyCellEditor = new PropertyCellEditor();
        PropertyCellRenderer propertyCellRenderer = new PropertyCellRenderer();
        if (this.propTable_.getColumnCount() == 0) {
            for (int i = 0; i < propertyTableModel.getColumnCount(); ++i) {
                TableColumn tableColumn = new TableColumn(i, 200, propertyCellRenderer, propertyCellEditor);
                this.propTable_.addColumn(tableColumn);
            }
        }
        propertyTableModel.fireTableStructureChanged();
        this.propTable_.repaint();
    }

    private void addSetting() {
        TreePath treePath = this.groupTree_.getSelectionPath();
        if (treePath == null) {
            this.handleError("A preset must be selected in the configuration tree to add setting to.");
            return;
        }
        int n = this.propTable_.getSelectedRow();
        if (n < 0) {
            this.handleError("You must select a setting in the property table.");
            return;
        }
        Object[] objectArray = treePath.getPath();
        if (objectArray.length == 2) {
            this.handleError("Group is currently selected, but you need to select a specific preset to add setting to.");
            return;
        }
        Setting setting = ((PropertyTableModel)this.propTable_.getModel()).getSetting(n);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.groupTree_.getModel();
        ConfigPreset configPreset = (ConfigPreset)((DefaultMutableTreeNode)objectArray[2]).getUserObject();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)objectArray[2];
        configPreset.addSetting(setting);
        defaultMutableTreeNode.removeAllChildren();
        for (int i = 0; i < configPreset.getNumberOfSettings(); ++i) {
            Setting setting2 = configPreset.getSetting(i);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(setting2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        defaultTreeModel.nodeStructureChanged(defaultMutableTreeNode);
    }

    private void removeSetting() {
        TreePath treePath = this.groupTree_.getSelectionPath();
        if (treePath == null) {
            this.handleError("Tree element must be selected for removal.");
            return;
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.groupTree_.getModel();
        Object[] objectArray = treePath.getPath();
        if (objectArray.length == 2) {
            ConfigGroup configGroup = (ConfigGroup)((DefaultMutableTreeNode)objectArray[1]).getUserObject();
            this.model_.removeGroup(configGroup.getName());
            ((DefaultMutableTreeNode)objectArray[0]).remove((DefaultMutableTreeNode)objectArray[1]);
            defaultTreeModel.nodeStructureChanged((DefaultMutableTreeNode)objectArray[0]);
        } else if (objectArray.length == 3) {
            ConfigGroup configGroup = (ConfigGroup)((DefaultMutableTreeNode)objectArray[1]).getUserObject();
            ConfigPreset configPreset = (ConfigPreset)((DefaultMutableTreeNode)objectArray[2]).getUserObject();
            configGroup.removePreset(configPreset.getName());
            ((DefaultMutableTreeNode)objectArray[1]).remove((DefaultMutableTreeNode)objectArray[2]);
            defaultTreeModel.nodeStructureChanged((DefaultMutableTreeNode)objectArray[1]);
        } else if (objectArray.length == 4) {
            ConfigPreset configPreset = (ConfigPreset)((DefaultMutableTreeNode)objectArray[2]).getUserObject();
            Setting setting = (Setting)((DefaultMutableTreeNode)objectArray[3]).getUserObject();
            configPreset.removeSetting(setting);
            ((DefaultMutableTreeNode)objectArray[2]).remove((DefaultMutableTreeNode)objectArray[3]);
            defaultTreeModel.nodeStructureChanged((DefaultMutableTreeNode)objectArray[2]);
        } else {
            System.out.println("Unexpected path depth " + objectArray.length);
            return;
        }
    }

    protected void addNewGroup() {
        String string = new String("");
        boolean bl = false;
        while (!bl) {
            string = JOptionPane.showInputDialog("Please type in the new group name:");
            if (string == null) {
                return;
            }
            if (string.length() == 0) {
                JOptionPane.showMessageDialog(this, "Empty names are not allowed!");
                continue;
            }
            ConfigGroup configGroup = this.model_.findConfigGroup(string);
            if (configGroup == null) {
                this.model_.addConfigGroup(string);
                bl = true;
                this.buildTree();
                continue;
            }
            JOptionPane.showMessageDialog(this, "Group with that name already exists!");
        }
    }

    protected void addNewPreset() {
        TreePath treePath = this.groupTree_.getSelectionPath();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.groupTree_.getModel();
        if (treePath == null || treePath.getPath().length < 2) {
            this.handleError("A group must be selected for this operation.");
            return;
        }
        Object[] objectArray = treePath.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)objectArray[1];
        ConfigGroup configGroup = (ConfigGroup)defaultMutableTreeNode.getUserObject();
        String string = new String("");
        boolean bl = false;
        while (!bl) {
            string = JOptionPane.showInputDialog("Please type in the new preset name:");
            if (string == null) {
                return;
            }
            if (string.length() == 0) {
                JOptionPane.showMessageDialog(this, "Empty names are not allowed!");
                continue;
            }
            ConfigPreset configPreset = configGroup.findConfigPreset(string);
            if (configPreset == null) {
                ConfigPreset configPreset2 = new ConfigPreset(string);
                configGroup.addConfigPreset(configPreset2);
                bl = true;
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(configPreset2));
                defaultTreeModel.nodeStructureChanged(defaultMutableTreeNode);
                continue;
            }
            JOptionPane.showMessageDialog(this, "Preset with that name already exists!");
        }
    }

    protected void editNode() {
        TreePath treePath = this.groupTree_.getSelectionPath();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.groupTree_.getModel();
        PropertyTableModel propertyTableModel = (PropertyTableModel)this.propTable_.getModel();
        Object[] objectArray = treePath.getPath();
        if (objectArray.length == 2) {
            ConfigGroup configGroup = (ConfigGroup)((DefaultMutableTreeNode)objectArray[1]).getUserObject();
            String string = new String(configGroup.getName());
            boolean bl = false;
            while (!bl) {
                string = JOptionPane.showInputDialog(this, "Please type in the group name:", configGroup.getName());
                if (string == null) {
                    return;
                }
                if (string.length() == 0) {
                    JOptionPane.showMessageDialog(this, "Empty names are not allowed!");
                    continue;
                }
                if (string.compareTo(configGroup.getName()) == 0) {
                    return;
                }
                ConfigGroup configGroup2 = this.model_.findConfigGroup(string);
                if (configGroup2 == null) {
                    this.model_.renameGroup(configGroup, string);
                    bl = true;
                    continue;
                }
                JOptionPane.showMessageDialog(this, "Group with that name already exists!");
            }
            defaultTreeModel.nodeStructureChanged((DefaultMutableTreeNode)objectArray[0]);
        } else if (objectArray.length == 3) {
            ConfigGroup configGroup = (ConfigGroup)((DefaultMutableTreeNode)objectArray[1]).getUserObject();
            ConfigPreset configPreset = (ConfigPreset)((DefaultMutableTreeNode)objectArray[2]).getUserObject();
            boolean bl = false;
            while (!bl) {
                String string = JOptionPane.showInputDialog(this, "Please type in the preset name:", configPreset.getName());
                if (string == null) {
                    return;
                }
                if (string.length() == 0) {
                    JOptionPane.showMessageDialog(this, "Empty names are not allowed!");
                    continue;
                }
                if (string.compareTo(configPreset.getName()) == 0) {
                    return;
                }
                ConfigPreset configPreset2 = configGroup.findConfigPreset(string);
                if (configPreset2 == null) {
                    configGroup.renamePreset(configPreset, string);
                    bl = true;
                    continue;
                }
                JOptionPane.showMessageDialog(this, "Preset with that name already exists!");
            }
            defaultTreeModel.nodeStructureChanged((DefaultMutableTreeNode)objectArray[1]);
        } else if (objectArray.length == 4) {
            ConfigPreset configPreset = (ConfigPreset)((DefaultMutableTreeNode)objectArray[2]).getUserObject();
            Setting setting = (Setting)((DefaultMutableTreeNode)objectArray[3]).getUserObject();
            String string = new String(setting.propertyValue_);
            boolean bl = false;
            while (!bl) {
                String string2 = JOptionPane.showInputDialog(this, "Device=" + setting.deviceName_ + ", Property=" + setting.propertyName_ + ", type in the new value:", string);
                if (string2 == null) {
                    return;
                }
                setting.propertyValue_ = string2;
                ((DefaultMutableTreeNode)objectArray[3]).setUserObject(setting);
                bl = true;
            }
            defaultTreeModel.nodeStructureChanged((DefaultMutableTreeNode)objectArray[2]);
        } else {
            System.out.println("Unexpected path depth " + objectArray.length);
            return;
        }
    }
}

