/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import mmcorej.CMMCore;
import mmcorej.MMCoreJ;
import mmcorej.StrVector;
import org.micromanager.conf.ConfigGroup;
import org.micromanager.conf.ConfigPreset;
import org.micromanager.conf.Device;
import org.micromanager.conf.Label;
import org.micromanager.conf.MMConfigFileException;
import org.micromanager.conf.Property;
import org.micromanager.conf.Setting;

public class MicroscopeModel {
    ArrayList devices_ = new ArrayList();
    Device[] availableDevices_;
    boolean modified_ = false;
    String fileName_ = new String("");
    Hashtable configGroups_;
    ArrayList synchroDevices_;
    private static final String LINE_TERM = "\r\n";
    public static final String DEVLIST_FILE_NAME = "MMDeviceList.txt";

    public MicroscopeModel() {
        this.availableDevices_ = new Device[0];
        this.configGroups_ = new Hashtable();
        this.synchroDevices_ = new ArrayList();
        Device device = new Device(MMCoreJ.getG_Keyword_CoreDevice(), "Default", "MMCore", "Core controller");
        this.devices_.add(device);
        this.addMissingProperties();
        this.addSystemConfigs();
    }

    public boolean isModified() {
        return this.modified_;
    }

    public String getFileName() {
        return this.fileName_;
    }

    public void setFileName(String string) {
        this.fileName_ = string;
    }

    public void loadDeviceDataFromHardware(CMMCore cMMCore) throws Exception {
        for (int i = 0; i < this.devices_.size(); ++i) {
            Device device = (Device)this.devices_.get(i);
            device.loadDataFromHardware(cMMCore);
        }
    }

    public void loadAvailableDeviceList(CMMCore cMMCore) {
        ArrayList<Device> arrayList = new ArrayList<Device>();
        File file = new File(DEVLIST_FILE_NAME);
        if (file.exists()) {
            this.loadDevicesFromListFile(arrayList);
        }
        if (arrayList.size() == 0) {
            StrVector strVector = cMMCore.getDeviceLibraries("");
            System.out.println("Libraries :");
            int n = 0;
            while ((long)n < strVector.size()) {
                System.out.println(strVector.get(n));
                Device[] deviceArray = new Device[]{};
                try {
                    deviceArray = Device.getLibraryContents(strVector.get(n), cMMCore);
                    for (int i = 0; i < deviceArray.length; ++i) {
                        System.out.println("   " + deviceArray[i].getAdapterName() + ", " + deviceArray[i].getDescription());
                        arrayList.add(deviceArray[i]);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Unable to load " + strVector.get(n) + " library.");
                    System.out.println(exception.getMessage());
                }
                ++n;
            }
        }
        this.availableDevices_ = new Device[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.availableDevices_[i] = (Device)arrayList.get(i);
        }
    }

    private void loadDevicesFromListFile(ArrayList arrayList) {
        File file = new File(DEVLIST_FILE_NAME);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split(",");
                if (stringArray.length != 3) continue;
                Device device = new Device("Undefined", stringArray[0], stringArray[1], stringArray[2]);
                arrayList.add(device);
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    public Device[] getAvailableDeviceList() {
        return this.availableDevices_;
    }

    public void addSetupProperty(String string, Property property) throws MMConfigFileException {
        Device device = this.findDevice(string);
        if (device == null) {
            throw new MMConfigFileException("Device " + string + " not defined.");
        }
        Property property2 = device.findSetupProperty(property.name_);
        if (property2 == null) {
            device.addSetupProperty(property);
        } else {
            property2.value_ = property.value_;
        }
    }

    public void addSetupLabel(String string, Label label) throws MMConfigFileException {
        Device device = this.findDevice(string);
        if (device != null) {
            device.addSetupLabel(label);
            this.modified_ = true;
            return;
        }
        throw new MMConfigFileException("Device " + string + " not defined.");
    }

    public void applySetupLabelsToHardware(CMMCore cMMCore) throws Exception {
        for (int i = 0; i < this.devices_.size(); ++i) {
            Device device = (Device)this.devices_.get(i);
            for (int j = 0; j < device.getNumberOfSetupLabels(); ++j) {
                Label label = device.getSetupLabel(j);
                cMMCore.defineStateLabel(device.getName(), label.state_, label.label_);
            }
        }
    }

    public void applySetupConfigsToHardware(CMMCore cMMCore) throws Exception {
        StrVector strVector = cMMCore.getAvailableConfigGroups();
        int n = 0;
        while ((long)n < strVector.size()) {
            cMMCore.deleteConfigGroup(strVector.get(n));
            ++n;
        }
        Object[] objectArray = this.configGroups_.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ConfigGroup configGroup = (ConfigGroup)objectArray[i];
            cMMCore.defineConfigGroup(configGroup.getName());
            ConfigPreset[] configPresetArray = configGroup.getConfigPresets();
            for (int j = 0; j < configPresetArray.length; ++j) {
                for (int k = 0; k < configPresetArray[j].getNumberOfSettings(); ++k) {
                    Setting setting = configPresetArray[j].getSetting(k);
                    cMMCore.defineConfig(configGroup.getName(), configPresetArray[j].getName(), setting.deviceName_, setting.propertyName_, setting.propertyValue_);
                }
            }
        }
    }

    public void applyDelaysToHardware(CMMCore cMMCore) throws Exception {
        for (int i = 0; i < this.devices_.size(); ++i) {
            Device device = (Device)this.devices_.get(i);
            cMMCore.setDeviceDelayMs(device.getName(), device.getDelay());
        }
    }

    public boolean addConfigGroup(String string) {
        ConfigGroup configGroup = new ConfigGroup(string);
        Object v = this.configGroups_.get(string);
        if (v == null) {
            this.configGroups_.put(configGroup.getName(), configGroup);
            this.modified_ = true;
            return true;
        }
        return false;
    }

    public void loadFromFile(String string) throws MMConfigFileException {
        this.reset();
        File file = new File(string);
        if (!file.exists()) {
            throw new MMConfigFileException("Configuration file does not exist.");
        }
        boolean bl = false;
        try {
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                Object object;
                String[] stringArray = string2.split(",");
                if (stringArray.length == 0 || stringArray[0].startsWith("#")) continue;
                if (stringArray[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_Device()))) {
                    if (stringArray.length != 4) {
                        throw new MMConfigFileException("Invalid number of parameters (4 required):\n" + string2);
                    }
                    object = new Device(stringArray[1], stringArray[2], stringArray[3]);
                    this.devices_.add(object);
                    continue;
                }
                if (stringArray[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_Property()))) {
                    if (stringArray.length != 4) {
                        throw new MMConfigFileException("Invalid number of parameters (4 required):\n" + string2);
                    }
                    if (stringArray[1].contentEquals(new StringBuffer().append(MMCoreJ.getG_Keyword_CoreDevice()))) {
                        if (stringArray[2].contentEquals(new StringBuffer().append(MMCoreJ.getG_Keyword_CoreInitialize()))) {
                            if (stringArray[3].contentEquals(new StringBuffer().append("0"))) {
                                bl = false;
                                continue;
                            }
                            bl = true;
                            continue;
                        }
                        object = new Property();
                        ((Property)object).name_ = stringArray[2];
                        ((Property)object).value_ = stringArray[3];
                        this.addSetupProperty(stringArray[1], (Property)object);
                        continue;
                    }
                    object = new Property();
                    ((Property)object).preInit_ = !bl;
                    ((Property)object).name_ = stringArray[2];
                    ((Property)object).value_ = stringArray[3];
                    this.addSetupProperty(stringArray[1], (Property)object);
                    continue;
                }
                if (stringArray[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_Label()))) {
                    if (stringArray.length != 4) {
                        throw new MMConfigFileException("Invalid number of parameters (4 required):\n" + string2);
                    }
                    object = new Label(stringArray[3], Integer.parseInt(stringArray[2]));
                    this.addSetupLabel(stringArray[1], (Label)object);
                    continue;
                }
                if (stringArray[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_ImageSynchro()))) {
                    if (stringArray.length != 2) {
                        throw new MMConfigFileException("Invalid number of parameters (2 required):\n" + string2);
                    }
                    this.synchroDevices_.add(stringArray[1]);
                    continue;
                }
                if (!stringArray[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_ConfigGroup()))) continue;
                if (stringArray.length != 6) {
                    throw new MMConfigFileException("Invalid number of parameters (6 required):\n" + string2);
                }
                this.addConfigGroup(stringArray[1]);
                object = this.findConfigGroup(stringArray[1]);
                ((ConfigGroup)object).addConfigSetting(stringArray[2], stringArray[3], stringArray[4], stringArray[5]);
            }
        }
        catch (IOException iOException) {
            this.reset();
            throw new MMConfigFileException(iOException);
        }
        finally {
            this.modified_ = false;
            this.fileName_ = string;
            this.addMissingProperties();
            this.addSystemConfigs();
            this.dumpDeviceProperties(MMCoreJ.getG_Keyword_CoreDevice());
        }
    }

    private void addMissingProperties() {
        Property property;
        Device device = this.findDevice(MMCoreJ.getG_Keyword_CoreDevice());
        if (device == null) {
            device = new Device(MMCoreJ.getG_Keyword_CoreDevice(), "MMCore", "CoreDevice");
        }
        if ((property = device.findSetupProperty(MMCoreJ.getG_Keyword_CoreCamera())) == null) {
            device.addSetupProperty(new Property(MMCoreJ.getG_Keyword_CoreCamera(), ""));
        }
        if ((property = device.findSetupProperty(MMCoreJ.getG_Keyword_CoreShutter())) == null) {
            device.addSetupProperty(new Property(MMCoreJ.getG_Keyword_CoreShutter(), ""));
        }
        if ((property = device.findSetupProperty(MMCoreJ.getG_Keyword_CoreFocus())) == null) {
            device.addSetupProperty(new Property(MMCoreJ.getG_Keyword_CoreFocus(), ""));
        }
        if ((property = device.findSetupProperty(MMCoreJ.getG_Keyword_CoreAutoShutter())) == null) {
            device.addSetupProperty(new Property(MMCoreJ.getG_Keyword_CoreAutoShutter(), "1"));
        }
    }

    private void addSystemConfigs() {
        ConfigPreset configPreset;
        ConfigGroup configGroup = this.findConfigGroup(MMCoreJ.getG_CFGGroup_System());
        if (configGroup == null) {
            this.addConfigGroup(MMCoreJ.getG_CFGGroup_System());
        }
        if ((configPreset = (configGroup = this.findConfigGroup(MMCoreJ.getG_CFGGroup_System())).findConfigPreset(MMCoreJ.getG_CFGGroup_System_Startup())) == null) {
            configPreset = new ConfigPreset(MMCoreJ.getG_CFGGroup_System_Startup());
            configGroup.addConfigPreset(configPreset);
        }
    }

    public void saveToFile(String string) throws MMConfigFileException {
        try {
            ConfigPreset[] configPresetArray;
            Object object;
            int n;
            Object object2;
            int n2;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write("# Generated by Configurator on " + GregorianCalendar.getInstance().getTime() + LINE_TERM + LINE_TERM);
            bufferedWriter.write("# Reset\r\n");
            bufferedWriter.write("Property,Core,Initialize,0\r\n");
            bufferedWriter.write(LINE_TERM);
            bufferedWriter.write("# Devices\r\n");
            for (n2 = 0; n2 < this.devices_.size(); ++n2) {
                object2 = (Device)this.devices_.get(n2);
                if (((Device)object2).isCore()) continue;
                bufferedWriter.write(MMCoreJ.getG_CFGCommand_Device() + "," + ((Device)object2).getName() + "," + ((Device)object2).getLibrary() + "," + ((Device)object2).getAdapterName() + LINE_TERM);
            }
            bufferedWriter.write(LINE_TERM);
            bufferedWriter.write("# Pre-init settings\r\n");
            for (n2 = 0; n2 < this.devices_.size(); ++n2) {
                object2 = (Device)this.devices_.get(n2);
                for (n = 0; n < ((Device)object2).getNumberOfSetupProperties(); ++n) {
                    object = ((Device)object2).getSetupProperty(n);
                    if (!((Property)object).preInit_) continue;
                    bufferedWriter.write(MMCoreJ.getG_CFGCommand_Property() + "," + ((Device)object2).getName() + "," + ((Property)object).name_ + "," + ((Property)object).value_ + LINE_TERM);
                }
            }
            bufferedWriter.write(LINE_TERM);
            bufferedWriter.write("# Initialize\r\n");
            bufferedWriter.write("Property,Core,Initialize,1\r\n");
            bufferedWriter.write(LINE_TERM);
            bufferedWriter.write("# Delays\r\n");
            for (n2 = 0; n2 < this.devices_.size(); ++n2) {
                object2 = (Device)this.devices_.get(n2);
                if (!(((Device)object2).getDelay() > 0.0)) continue;
                bufferedWriter.write(MMCoreJ.getG_CFGCommand_Delay() + "," + ((Device)object2).getName() + "," + ((Device)object2).getDelay() + LINE_TERM);
            }
            bufferedWriter.write(LINE_TERM);
            bufferedWriter.write("# Roles\r\n");
            Device device = this.findDevice(MMCoreJ.getG_Keyword_CoreDevice());
            object2 = device.findProperty(MMCoreJ.getG_Keyword_CoreCamera());
            if (((Property)object2).value_.length() > 0) {
                bufferedWriter.write(MMCoreJ.getG_CFGCommand_Property() + "," + MMCoreJ.getG_Keyword_CoreDevice() + "," + MMCoreJ.getG_Keyword_CoreCamera() + "," + ((Property)object2).value_ + LINE_TERM);
            }
            object2 = device.findProperty(MMCoreJ.getG_Keyword_CoreShutter());
            if (((Property)object2).value_.length() > 0) {
                bufferedWriter.write(MMCoreJ.getG_CFGCommand_Property() + "," + MMCoreJ.getG_Keyword_CoreDevice() + "," + MMCoreJ.getG_Keyword_CoreShutter() + "," + ((Property)object2).value_ + LINE_TERM);
            }
            object2 = device.findProperty(MMCoreJ.getG_Keyword_CoreFocus());
            if (((Property)object2).value_.length() > 0) {
                bufferedWriter.write(MMCoreJ.getG_CFGCommand_Property() + "," + MMCoreJ.getG_Keyword_CoreDevice() + "," + MMCoreJ.getG_Keyword_CoreFocus() + "," + ((Property)object2).value_ + LINE_TERM);
            }
            object2 = device.findProperty(MMCoreJ.getG_Keyword_CoreAutoShutter());
            if (((Property)object2).value_.length() > 0) {
                bufferedWriter.write(MMCoreJ.getG_CFGCommand_Property() + "," + MMCoreJ.getG_Keyword_CoreDevice() + "," + MMCoreJ.getG_Keyword_CoreAutoShutter() + "," + ((Property)object2).value_ + LINE_TERM);
            }
            bufferedWriter.write(LINE_TERM);
            bufferedWriter.write("# Camera-synchronized devices\r\n");
            for (n = 0; n < this.synchroDevices_.size(); ++n) {
                bufferedWriter.write(MMCoreJ.getG_CFGCommand_ImageSynchro() + "," + this.synchroDevices_.get(n) + LINE_TERM);
            }
            bufferedWriter.write(LINE_TERM);
            bufferedWriter.write("# Labels\r\n");
            for (n = 0; n < this.devices_.size(); ++n) {
                object = (Device)this.devices_.get(n);
                if (((Device)object).getNumberOfSetupLabels() > 0) {
                    bufferedWriter.write("# " + ((Device)object).getName() + LINE_TERM);
                }
                for (int i = 0; i < ((Device)object).getNumberOfSetupLabels(); ++i) {
                    configPresetArray = ((Device)object).getSetupLabel(i);
                    bufferedWriter.write(MMCoreJ.getG_CFGCommand_Label() + "," + ((Device)object).getName() + "," + configPresetArray.state_ + "," + configPresetArray.label_ + LINE_TERM);
                }
            }
            bufferedWriter.write(LINE_TERM);
            bufferedWriter.write("# Configuration presets\r\n");
            Object[] objectArray = this.configGroups_.values().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ConfigGroup configGroup = (ConfigGroup)objectArray[i];
                bufferedWriter.write("# Group: " + configGroup.getName() + LINE_TERM);
                configPresetArray = configGroup.getConfigPresets();
                for (int j = 0; j < configPresetArray.length; ++j) {
                    bufferedWriter.write("# Preset: " + configPresetArray[j].getName() + LINE_TERM);
                    for (int k = 0; k < configPresetArray[j].getNumberOfSettings(); ++k) {
                        Setting setting = configPresetArray[j].getSetting(k);
                        bufferedWriter.write(MMCoreJ.getG_CFGCommand_ConfigGroup() + "," + configGroup.getName() + "," + configPresetArray[j].getName() + "," + setting.deviceName_ + "," + setting.propertyName_ + "," + setting.propertyValue_ + LINE_TERM);
                    }
                    bufferedWriter.write(LINE_TERM);
                }
                bufferedWriter.write(LINE_TERM);
            }
            bufferedWriter.write(LINE_TERM);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new MMConfigFileException(iOException);
        }
        this.fileName_ = string;
        this.modified_ = false;
    }

    public void dumpSetupConf() {
        Object object;
        int n;
        Device device;
        int n2;
        System.out.println("\nStep 1: load devices");
        for (n2 = 0; n2 < this.devices_.size(); ++n2) {
            device = (Device)this.devices_.get(n2);
            System.out.println(device.getName() + " from library " + device.getLibrary() + ", using adapter " + device.getAdapterName());
        }
        System.out.println("\nStep 2: set pre-initialization properties");
        for (n2 = 0; n2 < this.devices_.size(); ++n2) {
            device = (Device)this.devices_.get(n2);
            for (n = 0; n < device.getNumberOfSetupProperties(); ++n) {
                object = device.getSetupProperty(n);
                if (!((Property)object).preInit_) continue;
                System.out.println(device.getName() + ", property " + ((Property)object).name_ + "=" + ((Property)object).value_);
            }
        }
        System.out.println("\nStep 3: initialize");
        System.out.println("\nStep 4: define device labels");
        for (n2 = 0; n2 < this.devices_.size(); ++n2) {
            device = (Device)this.devices_.get(n2);
            System.out.println(device.getName() + " labels:");
            for (n = 0; n < device.getNumberOfSetupLabels(); ++n) {
                object = device.getSetupLabel(n);
                System.out.println("    State " + ((Label)object).state_ + "=" + ((Label)object).label_);
            }
        }
        System.out.println("\nStep 5: set initial properties");
        for (n2 = 0; n2 < this.devices_.size(); ++n2) {
            device = (Device)this.devices_.get(n2);
            for (n = 0; n < device.getNumberOfSetupProperties(); ++n) {
                object = device.getSetupProperty(n);
                if (((Property)object).preInit_) continue;
                System.out.println(device.getName() + ", property " + ((Property)object).name_ + "=" + ((Property)object).value_);
            }
        }
    }

    public void dumpDeviceProperties(String string) {
        Device device = this.findDevice(string);
        if (device == null) {
            return;
        }
        for (int i = 0; i < device.getNumberOfSetupProperties(); ++i) {
            Property property = device.getSetupProperty(i);
            System.out.println(device.getName() + ", property " + property.name_ + "=" + property.value_);
            for (int j = 0; j < property.allowedValues_.length; ++j) {
                System.out.println("   " + property.allowedValues_[j]);
            }
        }
    }

    public void reset() {
        this.devices_.clear();
        this.configGroups_.clear();
        this.synchroDevices_.clear();
        Device device = new Device(MMCoreJ.getG_Keyword_CoreDevice(), "Default", "MMCore", "Core controller");
        this.devices_.add(device);
        this.addMissingProperties();
        this.addSystemConfigs();
        this.modified_ = true;
    }

    public Device[] getDevices() {
        Device[] deviceArray = new Device[this.devices_.size()];
        for (int i = 0; i < deviceArray.length; ++i) {
            deviceArray[i] = (Device)this.devices_.get(i);
        }
        return deviceArray;
    }

    public void removeDevice(String string) {
        Device device = this.findDevice(string);
        if (device != null) {
            this.devices_.remove(device);
            this.modified_ = true;
        }
    }

    Device findDevice(String string) {
        for (int i = 0; i < this.devices_.size(); ++i) {
            Device device = (Device)this.devices_.get(i);
            if (!device.getName().contentEquals(new StringBuffer().append(string))) continue;
            return device;
        }
        return null;
    }

    ConfigGroup findConfigGroup(String string) {
        return (ConfigGroup)this.configGroups_.get(string);
    }

    String[] getConfigGroupList() {
        String[] stringArray = new String[this.configGroups_.size()];
        Object[] objectArray = this.configGroups_.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = ((ConfigGroup)objectArray[i]).getName();
        }
        return stringArray;
    }

    String[] getSynchroList() {
        String[] stringArray = new String[this.synchroDevices_.size()];
        for (int i = 0; i < this.synchroDevices_.size(); ++i) {
            stringArray[i] = new String((String)this.synchroDevices_.get(i));
        }
        return stringArray;
    }

    void addSynchroDevice(String string) {
        this.synchroDevices_.add(string);
        this.modified_ = true;
    }

    public void clearSynchroDevices() {
        this.synchroDevices_.clear();
        this.modified_ = true;
    }

    public void addDevice(Device device) throws MMConfigFileException {
        if (device.getName().length() == 0) {
            throw new MMConfigFileException("Empty device names are not allowed, please choose a different name.");
        }
        if (this.findDevice(device.getName()) != null) {
            throw new MMConfigFileException(device.getName() + " already defined, please choose a different name.");
        }
        this.devices_.add(device);
        this.modified_ = true;
    }

    public void changeDeviceName(String string, String string2) throws MMConfigFileException {
        Device device = this.findDevice(string);
        if (device == null) {
            throw new MMConfigFileException("Device " + string + " is not defined");
        }
        device.setName(string2);
        this.modified_ = true;
    }

    public String getDeviceSetupProperty(String string, String string2) throws MMConfigFileException {
        Device device = this.findDevice(string);
        if (device == null) {
            return null;
        }
        return device.getSetupPropertyValue(string2);
    }

    public void setDeviceSetupProperty(String string, String string2, String string3) throws MMConfigFileException {
        Device device = this.findDevice(string);
        if (device == null) {
            throw new MMConfigFileException("Device " + string + " is not defined");
        }
        device.setSetupPropertyValue(string2, string3);
        this.modified_ = true;
    }

    public void removeGroup(String string) {
        this.configGroups_.remove(string);
        this.modified_ = true;
    }

    public void renameGroup(ConfigGroup configGroup, String string) {
        this.configGroups_.remove(configGroup.getName());
        configGroup.setName(string);
        this.configGroups_.put(string, configGroup);
        this.modified_ = true;
    }
}

