/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf;

import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import mmcorej.MMCoreJ;
import org.micromanager.conf.Device;
import org.micromanager.conf.Label;
import org.micromanager.conf.MicroscopeModel;
import org.micromanager.conf.PagePanel;
import org.micromanager.conf.Property;

public class LabelsPage
extends PagePanel {
    private String[] labels_ = new String[0];
    private JTable devTable_;
    private JTable labelTable_;

    public LabelsPage(Preferences preferences) {
        this.title_ = "Define position labels for state devices";
        this.helpText_ = "State devices with discrete positions, such as filter changers or objective turrets, etc. can have mnemonic labels assigned for each position.\n\nSelect the device in the left-hand list and edit corresponding position labels in the right-hand list.";
        this.prefs_ = preferences;
        this.setLayout(null);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBounds(186, 10, 304, 254);
        this.add(jScrollPane);
        this.labelTable_ = new JTable();
        this.labelTable_.setModel(new LabelTableModel());
        jScrollPane.setViewportView(this.labelTable_);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setBounds(10, 10, 162, 255);
        this.add(jScrollPane2);
        this.devTable_ = new JTable();
        DevTableModel devTableModel = new DevTableModel();
        this.devTable_.setModel(devTableModel);
        this.devTable_.getSelectionModel().addListSelectionListener(new SelectionListener(this.devTable_));
        this.devTable_.setSelectionMode(0);
        jScrollPane2.setViewportView(this.devTable_);
    }

    public boolean enterPage(boolean bl) {
        DevTableModel devTableModel = (DevTableModel)this.devTable_.getModel();
        devTableModel.setData(this.model_);
        return true;
    }

    public boolean exitPage(boolean bl) {
        try {
            this.model_.applySetupLabelsToHardware(this.core_);
            this.model_.loadDeviceDataFromHardware(this.core_);
        }
        catch (Exception exception) {
            this.handleError(exception.getMessage());
            return false;
        }
        return true;
    }

    public void refresh() {
    }

    public void loadSettings() {
    }

    public void saveSettings() {
    }

    static /* synthetic */ String[] access$102(LabelsPage labelsPage, String[] stringArray) {
        labelsPage.labels_ = stringArray;
        return stringArray;
    }

    class DevTableModel
    extends AbstractTableModel {
        ArrayList devices_ = new ArrayList();
        public final String[] COLUMN_NAMES = new String[]{"State devices"};

        DevTableModel() {
        }

        public void setData(MicroscopeModel microscopeModel) {
            Device[] deviceArray = microscopeModel.getDevices();
            this.devices_.clear();
            for (int i = 0; i < deviceArray.length; ++i) {
                if (!deviceArray[i].isStateDevice()) continue;
                this.devices_.add(deviceArray[i]);
            }
        }

        public int getRowCount() {
            return this.devices_.size();
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public Object getValueAt(int n, int n2) {
            return ((Device)this.devices_.get(n)).getName();
        }
    }

    class LabelTableModel
    extends AbstractTableModel {
        public final String[] COLUMN_NAMES = new String[]{"Position", "Label"};
        private Device curDevice_;

        LabelTableModel() {
        }

        public void setData(MicroscopeModel microscopeModel, String string) {
            int n;
            this.curDevice_ = microscopeModel.findDevice(string);
            LabelsPage.access$102(LabelsPage.this, new String[0]);
            if (this.curDevice_ == null) {
                return;
            }
            Property property = this.curDevice_.findProperty(MMCoreJ.getG_Keyword_Label());
            if (property == null) {
                return;
            }
            LabelsPage.access$102(LabelsPage.this, new String[this.curDevice_.getNumberOfStates()]);
            for (n = 0; n < LabelsPage.this.labels_.length; ++n) {
                ((LabelsPage)LabelsPage.this).labels_[n] = new String("State-" + n);
            }
            for (n = 0; n < this.curDevice_.getNumberOfSetupLabels(); ++n) {
                Label label = this.curDevice_.getSetupLabel(n);
                ((LabelsPage)LabelsPage.this).labels_[label.state_] = label.label_;
            }
        }

        public int getRowCount() {
            return LabelsPage.this.labels_.length;
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return Integer.toString(n);
            }
            return LabelsPage.this.labels_[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                try {
                    ((LabelsPage)LabelsPage.this).labels_[n] = (String)object;
                    this.curDevice_.setSetupLabel(n, (String)object);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (Exception exception) {
                    LabelsPage.this.handleError(exception.getMessage());
                }
            }
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable jTable) {
            this.table = jTable;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            LabelTableModel labelTableModel = (LabelTableModel)LabelsPage.this.labelTable_.getModel();
            if (listSelectionModel.isSelectionEmpty()) {
                labelTableModel.setData(LabelsPage.this.model_, null);
            } else {
                String string = (String)this.table.getValueAt(listSelectionModel.getMinSelectionIndex(), 0);
                labelTableModel.setData(LabelsPage.this.model_, string);
            }
            labelTableModel.fireTableStructureChanged();
            LabelsPage.this.labelTable_.getColumnModel().getColumn(0).setWidth(40);
        }
    }
}

