/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.micromanager.conf.MMConfigFileException;
import org.micromanager.conf.PagePanel;
import org.micromanager.utils.CfgFileFilter;

public class IntroPage
extends PagePanel {
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JTextField filePathField_;
    private boolean initialized_ = false;
    private JRadioButton modifyRadioButton_;
    private JRadioButton createNewRadioButton_;
    private JButton browseButton_;

    public IntroPage(Preferences preferences) {
        this.title_ = "Select the configuration file";
        this.helpText_ = "Welcome to the Micro-Manager Configurator.\nThe Configurator will guide you through the process of configuring the software to work with your hardware setup.\nIn this step you choose if you are creating a new hardware configuration or editing an existing one.";
        this.setLayout(null);
        this.prefs_ = preferences;
        this.createNewRadioButton_ = new JRadioButton();
        this.createNewRadioButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroPage.this.model_.reset();
                IntroPage.this.initialized_ = false;
                IntroPage.this.filePathField_.setEnabled(false);
                IntroPage.this.browseButton_.setEnabled(false);
            }
        });
        this.buttonGroup.add(this.createNewRadioButton_);
        this.createNewRadioButton_.setText("Create new configuration");
        this.createNewRadioButton_.setBounds(10, 31, 424, 23);
        this.add(this.createNewRadioButton_);
        this.modifyRadioButton_ = new JRadioButton();
        this.buttonGroup.add(this.modifyRadioButton_);
        this.modifyRadioButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroPage.this.filePathField_.setEnabled(true);
                IntroPage.this.browseButton_.setEnabled(true);
            }
        });
        this.modifyRadioButton_.setText("Modify or explore existing configuration");
        this.modifyRadioButton_.setBounds(10, 55, 424, 23);
        this.add(this.modifyRadioButton_);
        this.filePathField_ = new JTextField();
        this.filePathField_.setBounds(10, 84, 424, 19);
        this.add(this.filePathField_);
        this.browseButton_ = new JButton();
        this.browseButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroPage.this.loadConfiguration();
            }
        });
        this.browseButton_.setText("Browse...");
        this.browseButton_.setBounds(440, 82, 48, 23);
        this.add(this.browseButton_);
        this.createNewRadioButton_.setSelected(true);
        this.filePathField_.setEnabled(false);
        this.browseButton_.setEnabled(false);
    }

    public void loadSettings() {
        if (this.model_ != null) {
            this.filePathField_.setText(this.model_.getFileName());
        }
        if (this.filePathField_.getText().length() > 0) {
            this.modifyRadioButton_.setSelected(true);
            this.filePathField_.setEnabled(true);
            this.browseButton_.setEnabled(true);
        }
    }

    public void saveSettings() {
    }

    public boolean enterPage(boolean bl) {
        if (bl) {
            this.filePathField_.setText(this.model_.getFileName());
        }
        return true;
    }

    public boolean exitPage(boolean bl) {
        if (this.modifyRadioButton_.isSelected() && (!this.initialized_ || this.filePathField_.getText().compareTo(this.model_.getFileName()) != 0)) {
            try {
                this.model_.loadFromFile(this.filePathField_.getText());
            }
            catch (MMConfigFileException mMConfigFileException) {
                this.handleError(mMConfigFileException.getMessage());
                this.model_.reset();
                return false;
            }
            this.initialized_ = true;
        }
        return true;
    }

    public void refresh() {
    }

    private void loadConfiguration() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter((FileFilter)new CfgFileFilter());
        jFileChooser.setSelectedFile(new File(this.filePathField_.getText()));
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.filePathField_.setText(file.getAbsolutePath());
        }
    }
}

