/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import mmcorej.MMCoreJ;
import org.micromanager.conf.AddDeviceDlg;
import org.micromanager.conf.Device;
import org.micromanager.conf.PagePanel;
import org.micromanager.conf.Property;
import org.micromanager.conf.PropertyCellEditor;
import org.micromanager.conf.PropertyCellRenderer;
import org.micromanager.conf.PropertyTableModel;
import org.micromanager.conf.Setting;

public class EditPropertiesPage
extends PagePanel {
    private static final long serialVersionUID = 1L;
    private JTable propTable_;
    private JScrollPane scrollPane_;

    public EditPropertiesPage(Preferences preferences) {
        this.title_ = "Edit pre-initialization settings";
        this.helpText_ = "The list of device properties which must be defined prior to initialization is shown above. ";
        this.setLayout(null);
        this.prefs_ = preferences;
        this.scrollPane_ = new JScrollPane();
        this.scrollPane_.setBounds(10, 9, 381, 262);
        this.add(this.scrollPane_);
        this.propTable_ = new JTable();
        this.propTable_.setSelectionMode(0);
        this.propTable_.setAutoCreateColumnsFromModel(false);
        this.scrollPane_.setViewportView(this.propTable_);
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditPropertiesPage.this.addDevice();
            }
        });
        jButton.setText("Add...");
        jButton.setBounds(397, 9, 93, 23);
        this.add(jButton);
        JButton jButton2 = new JButton();
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditPropertiesPage.this.removeDevice();
            }
        });
        jButton2.setText("Remove");
        jButton2.setBounds(397, 38, 93, 23);
        this.add(jButton2);
    }

    protected void removeDevice() {
        int n = this.propTable_.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = (String)this.propTable_.getValueAt(n, 0);
        if (string.contentEquals(new StringBuffer().append(MMCoreJ.getG_Keyword_CoreDevice()))) {
            this.handleError(MMCoreJ.getG_Keyword_CoreDevice() + " device can't be removed!");
            return;
        }
        this.model_.removeDevice(string);
        this.rebuildTable();
    }

    protected void addDevice() {
        AddDeviceDlg addDeviceDlg = new AddDeviceDlg(this.model_);
        addDeviceDlg.setVisible(true);
        this.rebuildTable();
    }

    private void rebuildTable() {
        PropertyTableModel propertyTableModel = new PropertyTableModel(this, this.model_, true);
        this.propTable_.setModel(propertyTableModel);
        PropertyCellEditor propertyCellEditor = new PropertyCellEditor();
        PropertyCellRenderer propertyCellRenderer = new PropertyCellRenderer();
        if (this.propTable_.getColumnCount() == 0) {
            for (int i = 0; i < propertyTableModel.getColumnCount(); ++i) {
                TableColumn tableColumn = new TableColumn(i, 200, propertyCellRenderer, propertyCellEditor);
                this.propTable_.addColumn(tableColumn);
            }
        }
        propertyTableModel.fireTableStructureChanged();
        this.propTable_.repaint();
    }

    public boolean enterPage(boolean bl) {
        this.rebuildTable();
        return true;
    }

    public boolean exitPage(boolean bl) {
        block6: {
            try {
                if (bl) {
                    PropertyTableModel propertyTableModel = (PropertyTableModel)this.propTable_.getModel();
                    for (int i = 0; i < propertyTableModel.getRowCount(); ++i) {
                        Setting setting = propertyTableModel.getSetting(i);
                        this.core_.setProperty(setting.deviceName_, setting.propertyName_, setting.propertyValue_);
                        Device device = this.model_.findDevice(setting.deviceName_);
                        Property property = device.findSetupProperty(setting.propertyName_);
                        if (property == null) {
                            this.model_.addSetupProperty(setting.deviceName_, new Property(setting.propertyName_, setting.propertyValue_));
                        }
                        this.model_.setDeviceSetupProperty(setting.deviceName_, setting.propertyName_, setting.propertyValue_);
                    }
                    this.core_.initializeAllDevices();
                    this.model_.loadDeviceDataFromHardware(this.core_);
                } else {
                    this.core_.unloadAllDevices();
                }
            }
            catch (Exception exception) {
                this.handleException(exception);
                if (!bl) break block6;
                return false;
            }
        }
        return true;
    }

    public void refresh() {
        this.rebuildTable();
    }

    public void loadSettings() {
    }

    public void saveSettings() {
    }
}

