/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import mmcorej.MMCoreJ;
import mmcorej.StrVector;
import org.micromanager.conf.AddDeviceDlg;
import org.micromanager.conf.Device;
import org.micromanager.conf.MicroscopeModel;
import org.micromanager.conf.PagePanel;

public class DevicesPage
extends PagePanel {
    private JTable deviceTable_;
    private JScrollPane scrollPane_;

    public DevicesPage(Preferences preferences) {
        this.title_ = "Add or remove devices";
        this.helpText_ = "The list of selected devices is displayed above. You can add or remove devices to/from this list.\nThe first column shows the device's assigned name for this particular configuration. In subsequent steps devices will be referred to by their assigned names.\n\nYou can edit device names by double-clicking in the first column. Device name must be unique and should not contain any special characters.";
        this.setLayout(null);
        this.prefs_ = preferences;
        this.scrollPane_ = new JScrollPane();
        this.scrollPane_.setBounds(10, 10, 381, 262);
        this.add(this.scrollPane_);
        this.deviceTable_ = new JTable();
        this.deviceTable_.setSelectionMode(0);
        this.scrollPane_.setViewportView(this.deviceTable_);
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DevicesPage.this.addDevice();
            }
        });
        jButton.setText("Add...");
        jButton.setBounds(397, 10, 93, 23);
        this.add(jButton);
        JButton jButton2 = new JButton();
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DevicesPage.this.removeDevice();
            }
        });
        jButton2.setText("Remove");
        jButton2.setBounds(397, 39, 93, 23);
        this.add(jButton2);
    }

    protected void removeDevice() {
        int n = this.deviceTable_.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = (String)this.deviceTable_.getValueAt(n, 0);
        if (string.contentEquals(new StringBuffer().append(MMCoreJ.getG_Keyword_CoreDevice()))) {
            this.handleError(MMCoreJ.getG_Keyword_CoreDevice() + " device can't be removed!");
            return;
        }
        this.model_.removeDevice(string);
        this.rebuildTable();
    }

    protected void addDevice() {
        AddDeviceDlg addDeviceDlg = new AddDeviceDlg(this.model_);
        addDeviceDlg.setVisible(true);
        this.rebuildTable();
    }

    private void rebuildTable() {
        DeviceTable_TableModel deviceTable_TableModel;
        TableModel tableModel = this.deviceTable_.getModel();
        if (tableModel instanceof DeviceTable_TableModel) {
            deviceTable_TableModel = (DeviceTable_TableModel)this.deviceTable_.getModel();
            deviceTable_TableModel.refresh();
        } else {
            deviceTable_TableModel = new DeviceTable_TableModel(this.model_);
            this.deviceTable_.setModel(deviceTable_TableModel);
        }
        deviceTable_TableModel.fireTableStructureChanged();
        deviceTable_TableModel.fireTableDataChanged();
    }

    public void refresh() {
        this.rebuildTable();
    }

    public boolean enterPage(boolean bl) {
        this.rebuildTable();
        if (bl) {
            try {
                this.core_.unloadAllDevices();
            }
            catch (Exception exception) {
                this.handleError(exception.getMessage());
            }
        }
        return true;
    }

    public boolean exitPage(boolean bl) {
        if (bl) {
            try {
                StrVector strVector = this.core_.getLoadedDevices();
                if (strVector.size() > 1L) {
                    this.core_.unloadAllDevices();
                }
                Device[] deviceArray = this.model_.getDevices();
                for (int i = 0; i < deviceArray.length; ++i) {
                    if (deviceArray[i].isCore()) continue;
                    this.core_.loadDevice(deviceArray[i].getName(), deviceArray[i].getLibrary(), deviceArray[i].getAdapterName());
                }
                this.model_.loadDeviceDataFromHardware(this.core_);
            }
            catch (Exception exception) {
                this.handleException(exception);
                return false;
            }
        }
        return true;
    }

    public void loadSettings() {
    }

    public void saveSettings() {
    }

    class DeviceTable_TableModel
    extends AbstractTableModel {
        public final String[] COLUMN_NAMES = new String[]{"Name", "Adapter"};
        MicroscopeModel model_;
        Device[] devices_;

        public DeviceTable_TableModel(MicroscopeModel microscopeModel) {
            this.devices_ = microscopeModel.getDevices();
            this.model_ = microscopeModel;
        }

        public void setMicroscopeModel(MicroscopeModel microscopeModel) {
            this.devices_ = microscopeModel.getDevices();
            this.model_ = microscopeModel;
        }

        public int getRowCount() {
            return this.devices_.length;
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.devices_[n].getName();
            }
            return this.devices_[n].getAdapterName();
        }

        public void setValueAt(Object object, int n, int n2) {
            String string = (String)object;
            String string2 = this.devices_[n].getName();
            if (n2 == 0) {
                try {
                    this.model_.changeDeviceName(string2, string);
                    this.fireTableCellUpdated(n, n2);
                }
                catch (Exception exception) {
                    DevicesPage.this.handleError(exception.getMessage());
                }
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void refresh() {
            this.devices_ = this.model_.getDevices();
            this.fireTableDataChanged();
        }
    }
}

