/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf;

import java.util.ArrayList;
import java.util.Hashtable;
import mmcorej.CMMCore;
import mmcorej.DeviceType;
import mmcorej.MMCoreJ;
import mmcorej.StrVector;
import org.micromanager.conf.Label;
import org.micromanager.conf.MMConfigFileException;
import org.micromanager.conf.Property;

public class Device {
    private String name_;
    private String adapterName_;
    private String library_;
    private Property[] properties_;
    private ArrayList setupProperties_;
    private String description_;
    private DeviceType type_;
    private Hashtable setupLabels_;
    private double delayMs_;
    private int numPos_ = 0;

    public Device(String string, String string2, String string3, String string4) {
        this.name_ = string;
        this.library_ = string2;
        this.adapterName_ = string3;
        this.description_ = string4;
        this.type_ = DeviceType.AnyType;
        this.setupLabels_ = new Hashtable();
        this.properties_ = new Property[0];
        this.setupProperties_ = new ArrayList();
    }

    public Device(String string, String string2, String string3) {
        this(string, string2, string3, "");
    }

    public void loadDataFromHardware(CMMCore cMMCore) throws Exception {
        StrVector strVector = cMMCore.getDevicePropertyNames(this.name_);
        this.properties_ = new Property[(int)strVector.size()];
        this.delayMs_ = cMMCore.getDeviceDelayMs(this.name_);
        this.type_ = cMMCore.getDeviceType(this.name_);
        int n = 0;
        while ((long)n < strVector.size()) {
            this.properties_[n] = new Property();
            this.properties_[n].name_ = strVector.get(n);
            this.properties_[n].value_ = cMMCore.getProperty(this.name_, strVector.get(n));
            this.properties_[n].readOnly_ = cMMCore.isPropertyReadOnly(this.name_, strVector.get(n));
            this.properties_[n].preInit_ = cMMCore.isPropertyPreInit(this.name_, strVector.get(n));
            StrVector strVector2 = cMMCore.getAllowedPropertyValues(this.name_, strVector.get(n));
            this.properties_[n].allowedValues_ = new String[(int)strVector2.size()];
            int n2 = 0;
            while ((long)n2 < strVector2.size()) {
                this.properties_[n].allowedValues_[n2] = strVector2.get(n2);
                ++n2;
            }
            ++n;
        }
        this.numPos_ = this.type_ == DeviceType.StateDevice ? cMMCore.getNumberOfStates(this.name_) : 0;
    }

    public static Device[] getLibraryContents(String string, CMMCore cMMCore) throws Exception {
        StrVector strVector = cMMCore.getAvailableDevices(string);
        StrVector strVector2 = cMMCore.getAvailableDeviceDescriptions(string);
        Device[] deviceArray = new Device[(int)strVector.size()];
        int n = 0;
        while ((long)n < strVector.size()) {
            deviceArray[n] = new Device("Undefined", string, strVector.get(n), strVector2.get(n));
            ++n;
        }
        return deviceArray;
    }

    public String getName() {
        return this.name_;
    }

    public String getAdapterName() {
        return this.adapterName_;
    }

    public String getDescription() {
        return this.description_;
    }

    public void addSetupProperty(Property property) {
        this.setupProperties_.add(property);
    }

    public void addSetupLabel(Label label) {
        this.setupLabels_.put(new Integer(label.state_), label);
    }

    public String getLibrary() {
        return this.library_;
    }

    public int getNumberOfProperties() {
        return this.properties_.length;
    }

    public Property getProperty(int n) {
        return this.properties_[n];
    }

    public String getPropertyValue(String string) throws MMConfigFileException {
        Property property = this.findProperty(string);
        if (property == null) {
            throw new MMConfigFileException("Property " + string + " is not defined");
        }
        return property.value_;
    }

    public void setPropertyValue(String string, String string2) throws MMConfigFileException {
        Property property = this.findProperty(string);
        if (property == null) {
            throw new MMConfigFileException("Property " + string + " is not defined");
        }
        property.value_ = string2;
    }

    public int getNumberOfSetupProperties() {
        return this.setupProperties_.size();
    }

    public Property getSetupProperty(int n) {
        return (Property)this.setupProperties_.get(n);
    }

    public String getSetupPropertyValue(String string) throws MMConfigFileException {
        Property property = this.findSetupProperty(string);
        if (property == null) {
            throw new MMConfigFileException("Property " + string + " is not defined");
        }
        return property.value_;
    }

    public void setSetupPropertyValue(String string, String string2) throws MMConfigFileException {
        Property property = this.findSetupProperty(string);
        if (property == null) {
            throw new MMConfigFileException("Property " + string + " is not defined");
        }
        property.value_ = string2;
    }

    public boolean isStateDevice() {
        return this.type_ == DeviceType.StateDevice;
    }

    public boolean isCamera() {
        return this.type_ == DeviceType.CameraDevice;
    }

    public int getNumberOfSetupLabels() {
        return this.setupLabels_.size();
    }

    public Label getSetupLabel(int n) {
        return (Label)this.setupLabels_.values().toArray()[n];
    }

    public void setSetupLabel(int n, String string) {
        Label label = (Label)this.setupLabels_.get(new Integer(n));
        if (label == null) {
            return;
        }
        label.label_ = string;
    }

    public boolean isCore() {
        return this.name_.contentEquals(new StringBuffer().append(MMCoreJ.getG_Keyword_CoreDevice()));
    }

    public void setName(String string) {
        this.name_ = string;
    }

    public Property findProperty(String string) {
        for (int i = 0; i < this.properties_.length; ++i) {
            Property property = this.properties_[i];
            if (!property.name_.contentEquals(new StringBuffer().append(string))) continue;
            return property;
        }
        return null;
    }

    public Property findSetupProperty(String string) {
        for (int i = 0; i < this.setupProperties_.size(); ++i) {
            Property property = (Property)this.setupProperties_.get(i);
            if (!property.name_.contentEquals(new StringBuffer().append(string))) continue;
            return property;
        }
        return null;
    }

    public double getDelay() {
        return this.delayMs_;
    }

    public void setDelay(double d) {
        this.delayMs_ = d;
    }

    public int getNumberOfStates() {
        return this.numPos_;
    }
}

