/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf;

import java.util.prefs.Preferences;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.micromanager.conf.Device;
import org.micromanager.conf.DevicesPage;
import org.micromanager.conf.MicroscopeModel;
import org.micromanager.conf.PagePanel;

public class DelayPage
extends PagePanel {
    private JTable deviceTable_;

    public DelayPage(Preferences preferences) {
        this.title_ = "Set delays for devices without synchronization capabilities";
        this.helpText_ = "Some devices can't signal when they are done with the command, so that we have to guess by manually setting the delay. This means that the device will signal to be busy for the specified delay time after extecuting each command. Devices that may require setting the delay manually are mostly shutters or filter wheels. \n\nIf device has normal synchronization capabilities, or you are not sure about it, leave this parameter at 0.";
        this.prefs_ = preferences;
        this.setLayout(null);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBounds(22, 21, 357, 199);
        this.add(jScrollPane);
        this.deviceTable_ = new JTable();
        jScrollPane.setViewportView(this.deviceTable_);
    }

    public boolean enterPage(boolean bl) {
        this.rebuildTable();
        return true;
    }

    public boolean exitPage(boolean bl) {
        block2: {
            try {
                this.model_.applyDelaysToHardware(this.core_);
            }
            catch (Exception exception) {
                this.handleError(exception.getMessage());
                if (!bl) break block2;
                return false;
            }
        }
        return true;
    }

    private void rebuildTable() {
        DelayTableModel delayTableModel;
        TableModel tableModel = this.deviceTable_.getModel();
        if (tableModel instanceof DevicesPage.DeviceTable_TableModel) {
            delayTableModel = (DelayTableModel)this.deviceTable_.getModel();
            delayTableModel.refresh();
        } else {
            delayTableModel = new DelayTableModel(this.model_);
            this.deviceTable_.setModel(delayTableModel);
        }
        delayTableModel.fireTableStructureChanged();
        delayTableModel.fireTableDataChanged();
    }

    public void refresh() {
        this.rebuildTable();
    }

    public void loadSettings() {
    }

    public void saveSettings() {
    }

    class DelayTableModel
    extends AbstractTableModel {
        public final String[] COLUMN_NAMES = new String[]{"Name", "Adapter", "Delay [ms]"};
        MicroscopeModel model_;
        Device[] devices_;

        public DelayTableModel(MicroscopeModel microscopeModel) {
            this.devices_ = microscopeModel.getDevices();
            this.model_ = microscopeModel;
        }

        public void setMicroscopeModel(MicroscopeModel microscopeModel) {
            this.devices_ = microscopeModel.getDevices();
            this.model_ = microscopeModel;
        }

        public int getRowCount() {
            return this.devices_.length;
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.devices_[n].getName();
            }
            if (n2 == 1) {
                return this.devices_[n].getAdapterName();
            }
            return new Double(this.devices_[n].getDelay());
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 2) {
                try {
                    this.devices_[n].setDelay(Double.parseDouble((String)object));
                    this.fireTableCellUpdated(n, n2);
                }
                catch (Exception exception) {
                    DelayPage.this.handleError(exception.getMessage());
                }
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 2;
        }

        public void refresh() {
            this.devices_ = this.model_.getDevices();
            this.fireTableDataChanged();
        }
    }
}

