/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.border.LineBorder;
import mmcorej.CMMCore;
import org.micromanager.conf.DelayPage;
import org.micromanager.conf.DevicesPage;
import org.micromanager.conf.EditPropertiesPage;
import org.micromanager.conf.FinishPage;
import org.micromanager.conf.IntroPage;
import org.micromanager.conf.LabelsPage;
import org.micromanager.conf.MMConfigFileException;
import org.micromanager.conf.MicroscopeModel;
import org.micromanager.conf.PagePanel;
import org.micromanager.conf.PresetsPage;
import org.micromanager.conf.RolesPage;
import org.micromanager.conf.SynchroPage;

public class ConfiguratorDlg
extends JDialog {
    private JLabel pagesLabel_;
    private JButton backButton_;
    private JButton nextButton_;
    private PagePanel[] pages_;
    private int curPage_ = 0;
    private MicroscopeModel microModel_;
    private CMMCore core_;
    private Preferences prefs_;
    private static final String APP_NAME = "Configurator";
    private JLabel titleLabel_;
    private JTextPane helpTextPane_;
    private String defaultPath_;

    public ConfiguratorDlg(CMMCore cMMCore, String string) {
        this.core_ = cMMCore;
        this.defaultPath_ = string;
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.initialize();
    }

    private void initialize() {
        this.prefs_ = Preferences.userNodeForPackage(this.getClass());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConfiguratorDlg.this.onCloseWindow();
            }
        });
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.setTitle("Micro-Manager Configurator");
        this.setBounds(100, 100, 602, 519);
        this.nextButton_ = new JButton();
        this.nextButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ConfiguratorDlg.this.curPage_ == ConfiguratorDlg.this.pages_.length - 1) {
                    ConfiguratorDlg.this.onCloseWindow();
                } else {
                    ConfiguratorDlg.this.setPage(ConfiguratorDlg.this.curPage_ + 1);
                }
            }
        });
        this.nextButton_.setText("Next >");
        this.nextButton_.setBounds(494, 462, 93, 23);
        this.getContentPane().add(this.nextButton_);
        this.backButton_ = new JButton();
        this.backButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfiguratorDlg.this.setPage(ConfiguratorDlg.this.curPage_ - 1);
            }
        });
        this.backButton_.setText("< Back");
        this.backButton_.setBounds(395, 462, 93, 23);
        this.getContentPane().add(this.backButton_);
        this.pagesLabel_ = new JLabel();
        this.pagesLabel_.setBorder(new LineBorder(Color.black, 1, false));
        this.pagesLabel_.setBounds(9, 28, 578, 286);
        this.getContentPane().add(this.pagesLabel_);
        this.pages_ = new PagePanel[9];
        this.pages_[0] = new IntroPage(this.prefs_);
        this.pages_[1] = new DevicesPage(this.prefs_);
        this.pages_[2] = new EditPropertiesPage(this.prefs_);
        this.pages_[3] = new RolesPage(this.prefs_);
        this.pages_[4] = new DelayPage(this.prefs_);
        this.pages_[5] = new SynchroPage(this.prefs_);
        this.pages_[6] = new LabelsPage(this.prefs_);
        this.pages_[7] = new PresetsPage(this.prefs_);
        this.pages_[8] = new FinishPage(this.prefs_);
        this.microModel_ = new MicroscopeModel();
        this.microModel_.loadAvailableDeviceList(this.core_);
        this.microModel_.setFileName(this.defaultPath_);
        Rectangle rectangle = this.pagesLabel_.getBounds();
        this.titleLabel_ = new JLabel();
        this.titleLabel_.setText("Title");
        this.titleLabel_.setBounds(9, 4, 578, 21);
        this.getContentPane().add(this.titleLabel_);
        this.helpTextPane_ = new JTextPane();
        this.helpTextPane_.setEditable(false);
        this.helpTextPane_.setBorder(new LineBorder(Color.black, 1, false));
        this.helpTextPane_.setBounds(9, 320, 578, 136);
        this.getContentPane().add(this.helpTextPane_);
        for (int i = 0; i < this.pages_.length; ++i) {
            this.pages_[i].setModel(this.microModel_, this.core_);
            this.pages_[i].loadSettings();
            this.pages_[i].setBounds(rectangle);
            this.pages_[i].setTitle("Step " + (i + 1) + " of " + this.pages_.length + ": " + this.pages_[i].getTitle());
        }
        this.setPage(0);
    }

    private void setPage(int n) {
        if (!this.pages_[this.curPage_].exitPage(this.curPage_ < n)) {
            return;
        }
        int n2 = 0;
        n2 = n < 0 ? 0 : (n >= this.pages_.length ? this.pages_.length - 1 : n);
        if (!this.pages_[n2].enterPage(this.curPage_ > n2)) {
            return;
        }
        this.getContentPane().remove(this.pages_[this.curPage_]);
        this.curPage_ = n2;
        this.getContentPane().add(this.pages_[this.curPage_]);
        this.getContentPane().repaint();
        this.pages_[this.curPage_].refresh();
        if (this.curPage_ == 0) {
            this.backButton_.setEnabled(false);
        } else {
            this.backButton_.setEnabled(true);
        }
        if (this.curPage_ == this.pages_.length - 1) {
            this.nextButton_.setText("Exit");
        } else {
            this.nextButton_.setText("Next >");
        }
        this.titleLabel_.setText(this.pages_[this.curPage_].getTitle());
        this.helpTextPane_.setText(this.pages_[this.curPage_].getHelpText());
    }

    private void onCloseWindow() {
        int n;
        for (n = 0; n < this.pages_.length; ++n) {
            this.pages_[n].saveSettings();
        }
        if (this.microModel_.isModified()) {
            n = JOptionPane.showConfirmDialog(this, "Save changes to the configuration file?\nIf you press YES you will get a chance to change the file name.", "APP_NAME", 1, 1);
            switch (n) {
                case 0: {
                    this.saveConfiguration();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        this.dispose();
    }

    private void saveConfiguration() {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        boolean bl = true;
        do {
            jFileChooser.setSelectedFile(new File(this.microModel_.getFileName()));
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                file = jFileChooser.getSelectedFile();
                if (!file.exists()) continue;
                int n2 = JOptionPane.showConfirmDialog(this, "Overwrite " + file.getName(), "File Save", 0);
                if (n2 == 0) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            return;
        } while (!bl);
        try {
            this.microModel_.saveToFile(file.getAbsolutePath());
        }
        catch (MMConfigFileException mMConfigFileException) {
            JOptionPane.showMessageDialog(this, mMConfigFileException.getMessage());
        }
    }

    public String getFileName() {
        return this.microModel_.getFileName();
    }
}

