/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.micromanager.conf.Device;
import org.micromanager.conf.MMConfigFileException;
import org.micromanager.conf.MicroscopeModel;

public class AddDeviceDlg
extends JDialog {
    private JTable devTable_;
    private MicroscopeModel model_;

    public AddDeviceDlg(MicroscopeModel microscopeModel) {
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.setTitle("Add Device");
        this.setBounds(100, 100, 500, 375);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBounds(10, 10, 360, 321);
        this.getContentPane().add(jScrollPane);
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AddDeviceDlg.this.addDevice()) {
                    AddDeviceDlg.this.dispose();
                }
            }
        });
        jButton.setText("OK");
        jButton.setBounds(389, 10, 93, 23);
        this.getContentPane().add(jButton);
        JButton jButton2 = new JButton();
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddDeviceDlg.this.dispose();
            }
        });
        jButton2.setText("Cancel");
        jButton2.setBounds(389, 39, 93, 23);
        this.getContentPane().add(jButton2);
        this.model_ = microscopeModel;
        Dev_TableModel dev_TableModel = new Dev_TableModel(microscopeModel);
        this.devTable_ = new JTable();
        this.devTable_.setModel(dev_TableModel);
        this.devTable_.setSelectionMode(0);
        jScrollPane.setViewportView(this.devTable_);
    }

    protected boolean addDevice() {
        int n = this.devTable_.getSelectedRow();
        if (n < 0) {
            JOptionPane.showMessageDialog(this, "No device is currently selected.");
            return false;
        }
        Dev_TableModel dev_TableModel = (Dev_TableModel)this.devTable_.getModel();
        Device device = dev_TableModel.getDevice(n);
        if (device == null) {
            return false;
        }
        String string = new String("");
        boolean bl = false;
        while (!bl) {
            string = JOptionPane.showInputDialog("Please type in the new device name");
            if (string == null) {
                return false;
            }
            Device device2 = new Device(string, device.getLibrary(), device.getAdapterName(), device.getDescription());
            try {
                this.model_.addDevice(device2);
                bl = true;
            }
            catch (MMConfigFileException mMConfigFileException) {
                JOptionPane.showMessageDialog(this, mMConfigFileException.getMessage());
            }
        }
        return true;
    }

    class Dev_TableModel
    extends AbstractTableModel {
        Device[] devs_;
        public final String[] COLUMN_NAMES = new String[]{"Library", "Adapter", "Description"};

        public Dev_TableModel(MicroscopeModel microscopeModel) {
            this.devs_ = microscopeModel.getAvailableDeviceList();
        }

        public int getRowCount() {
            return this.devs_.length;
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 1) {
                return this.devs_[n].getAdapterName();
            }
            if (n2 == 0) {
                return this.devs_[n].getLibrary();
            }
            return this.devs_[n].getDescription();
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Device getDevice(int n) {
            if (n >= 0 && n < this.devs_.length) {
                return this.devs_[n];
            }
            return null;
        }
    }
}

