/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.jboss.annotation.ejb.Management;
import org.jboss.annotation.ejb.Producer;
import org.jboss.annotation.ejb.Producers;
import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.interceptor.EJB3InterceptorsInterceptor;
import org.jboss.ejb3.interceptor.InterceptorInfo;
import org.jboss.ejb3.mdb.ConsumerContainer;
import org.jboss.ejb3.mdb.MDB;
import org.jboss.ejb3.service.ServiceContainer;
import org.jboss.logging.Logger;
import org.jboss.util.MethodHashing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJB3InterceptorsFactory
implements AspectFactory {
    static Logger log = Logger.getLogger(EJB3InterceptorsFactory.class);
    static final long MESSAGE_LISTENER_ON_MESSAGE;

    public String getName() {
        return this.getClass().getName();
    }

    public Object createPerVM() {
        throw new RuntimeException("NOT ALLOWED");
    }

    public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor) {
        throw new RuntimeException("NOT ALLOWED");
    }

    public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        throw new RuntimeException("NOT ALLOWED");
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        if (jp instanceof MethodJoinpoint) {
            EJBContainer container = (EJBContainer)advisor;
            Class beanClass = container.getBeanClass();
            try {
                Method method = ((MethodJoinpoint)jp).getMethod();
                if (this.isBusinessMethod(container, method)) {
                    InterceptorInfo[] infos = container.getInterceptorRepository().getBusinessInterceptors(container, method);
                    Method[] beanAroundInvoke = container.getInterceptorRepository().getBeanClassAroundInvokes(container);
                    log.debug((Object)("Bound interceptors for joinpoint: " + method + " - " + infos));
                    return new EJB3InterceptorsInterceptor(infos, beanAroundInvoke);
                }
            }
            catch (RuntimeException e) {
                throw new RuntimeException("An exception occurred initialising interceptors for " + beanClass + "." + ((MethodJoinpoint)jp).getMethod().getName(), e);
            }
        }
        return new EJB3InterceptorsInterceptor(new InterceptorInfo[0], null);
    }

    public Object createPerClass(Advisor advisor) {
        throw new RuntimeException("NOT ALLOWED");
    }

    private boolean isBusinessMethod(EJBContainer container, Method method) {
        long hash = MethodHashing.calculateHash((Method)method);
        ArrayList<Class> businessInterfaces = this.getBusinessInterfaces(container);
        for (Class businessInterface : businessInterfaces) {
            for (Method interfaceMethod : businessInterface.getMethods()) {
                if (MethodHashing.calculateHash((Method)interfaceMethod) != hash) continue;
                return true;
            }
        }
        return false;
    }

    private ArrayList<Class> getBusinessInterfaces(EJBContainer container) {
        ArrayList<Class> interfaces;
        block9: {
            Class<?>[] implIfaces;
            Class iface;
            block10: {
                block8: {
                    Producer producer;
                    interfaces = new ArrayList<Class>();
                    if (!(container instanceof ConsumerContainer)) break block8;
                    Producers producers = (Producers)container.resolveAnnotation(Producers.class);
                    if (producers != null) {
                        for (Producer producer2 : producers.value()) {
                            interfaces.add(producer2.producer());
                        }
                    }
                    if ((producer = (Producer)container.resolveAnnotation(Producer.class)) != null) {
                        interfaces.add(producer.producer());
                    }
                    for (Class<?> implIf : container.getBeanClass().getInterfaces()) {
                        if (implIf.getAnnotation(Producer.class) == null) continue;
                        interfaces.add(implIf);
                    }
                    break block9;
                }
                if (!(container instanceof MDB)) break block10;
                interfaces.add(((MDB)container).getMessagingType());
                break block9;
            }
            Class[] remotes = ProxyFactoryHelper.getRemoteInterfaces(container);
            Class[] locals = ProxyFactoryHelper.getLocalInterfaces(container);
            if (remotes != null) {
                interfaces.addAll(Arrays.asList(remotes));
            }
            if (locals != null) {
                interfaces.addAll(Arrays.asList(locals));
            }
            if (!(container instanceof ServiceContainer)) break block9;
            Management man = (Management)container.resolveAnnotation(Management.class);
            if (man != null && (iface = man.value()) != null) {
                interfaces.add(iface);
            }
            for (Class<?> iface2 : implIfaces = container.getBeanClass().getInterfaces()) {
                if (iface2.getAnnotation(Management.class) == null) continue;
                interfaces.add(iface2);
            }
        }
        return interfaces;
    }

    static {
        try {
            Class<MessageListener> clazz = MessageListener.class;
            Method m = clazz.getDeclaredMethod("onMessage", Message.class);
            MESSAGE_LISTENER_ON_MESSAGE = MethodHashing.calculateHash((Method)m);
        }
        catch (Exception e) {
            throw new RuntimeException("Error initialising hash for MessageListener.onMessage()", e);
        }
    }
}

