/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.asynchronous.concurrent;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
import org.jboss.aspects.asynchronous.AsynchronousConstants;
import org.jboss.aspects.asynchronous.AsynchronousParameters;
import org.jboss.aspects.asynchronous.AsynchronousTask;
import org.jboss.aspects.asynchronous.AsynchronousUserTask;
import org.jboss.aspects.asynchronous.ThreadManager;
import org.jboss.aspects.asynchronous.ThreadManagerRequest;
import org.jboss.aspects.asynchronous.ThreadManagerResponse;
import org.jboss.aspects.asynchronous.common.AsynchronousEmptyTask;
import org.jboss.aspects.asynchronous.common.ThreadManagerResponseImpl;
import org.jboss.aspects.asynchronous.concurrent.AsynchronousTaskImpl;

public class ThreadManagerImpl
extends ThreadFactoryUser
implements AsynchronousConstants,
ThreadManager {
    protected PooledExecutor _pooledExecutor = null;
    protected boolean waitWhenPoolSizeIsFull = true;
    protected boolean isPooling = true;

    public ThreadManagerImpl() {
        this._pooledExecutor = new PooledExecutor();
        this.setWaitWhenPoolSizeIsFull(false);
    }

    public ThreadManagerImpl(int maximumPoolSize) {
        this._pooledExecutor = new PooledExecutor(maximumPoolSize);
        this.setWaitWhenPoolSizeIsFull(false);
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this._pooledExecutor.setMaximumPoolSize(maximumPoolSize);
    }

    public void setWaitWhenPoolSizeIsFull(boolean value) {
        if (value) {
            this._pooledExecutor.waitWhenBlocked();
        } else {
            this._pooledExecutor.abortWhenBlocked();
        }
        this.waitWhenPoolSizeIsFull = value;
    }

    public boolean getWaitWhenPoolSizeIsFull() {
        return this.waitWhenPoolSizeIsFull;
    }

    public int getMaximumPoolSize() {
        return this._pooledExecutor.getMaximumPoolSize();
    }

    public void setMinimumPoolSize(int minimumPoolSize) {
        this._pooledExecutor.setMinimumPoolSize(minimumPoolSize);
    }

    public int getMinimumPoolSize() {
        return this._pooledExecutor.getMinimumPoolSize();
    }

    public void setKeepAliveTime(long time) {
        this._pooledExecutor.setKeepAliveTime(time);
    }

    public long getKeepAliveTime() {
        return this._pooledExecutor.getKeepAliveTime();
    }

    public long getPoolSize() {
        return this._pooledExecutor.getPoolSize();
    }

    public ThreadManagerResponse waitForResponse(AsynchronousTask input) {
        AsynchronousTask[] tTask = new AsynchronousTask[]{input};
        return this.waitForResponses(tTask)[0];
    }

    public ThreadManagerResponse[] waitForResponses(AsynchronousTask[] inputImpl) {
        if (inputImpl == null) {
            System.err.println("PPMImpl:waitForResponses NULL PARAMETER");
            return null;
        }
        ThreadManagerResponse[] response = new ThreadManagerResponseImpl[inputImpl.length];
        for (int i = 0; i < inputImpl.length; ++i) {
            AsynchronousTask fr = inputImpl[i];
            response[i] = fr.getResponse();
        }
        return response;
    }

    public AsynchronousTask process(ThreadManagerRequest ppmRequest) {
        return this.process(ppmRequest.getId(), ppmRequest.getTaskClassImpl(), ppmRequest.getInputParameters(), ppmRequest.getTimeout());
    }

    private AsynchronousTask process(String id, AsynchronousUserTask taskImpl, AsynchronousParameters inputParametersImpl, long timeout) {
        try {
            if (this.getPoolSize() + 1L > (long)this.getMaximumPoolSize()) {
                System.err.println("process: The maximum pool size defined at " + this.getMaximumPoolSize() + " is reached before processing task[" + id + "] !");
            }
            AsynchronousTaskImpl ft = new AsynchronousTaskImpl(id, taskImpl, inputParametersImpl, timeout);
            Runnable cmd = ft.add();
            if (this.isPooling()) {
                this._pooledExecutor.execute(cmd);
            } else {
                Thread thread = this.getThreadFactory().newThread(cmd);
                thread.start();
            }
            Thread.yield();
            Thread.sleep(0L);
            Thread.yield();
            return ft;
        }
        catch (Exception e) {
            return new AsynchronousEmptyTask(id, 70, e, e.getMessage(), System.currentTimeMillis());
        }
    }

    public boolean isPooling() {
        return this.isPooling;
    }

    public void setPooling(boolean isPooling) {
        this.isPooling = isPooling;
    }
}

