/*
 * Decompiled with CFR 0.152.
 */
package mdbtools.libmdb;

import java.io.IOException;
import mdbtools.libmdb.MdbFile;
import mdbtools.libmdb.MdbFormatConstants;
import mdbtools.libmdb.MdbHandle;
import mdbtools.libmdb.macros;
import mdbtools.libmdb.mem;
import mdbtools.publicapi.RandomAccess;

public class file {
    private static MdbHandle _mdb_open(RandomAccess file2) throws IOException {
        int[] key = new int[]{134, 251, 236, 55, 93, 68, 156, 250, 198, 94, 40, 230, 19, 182};
        MdbHandle mdb = mem.mdb_alloc_handle();
        mdb.fmt = MdbFormatConstants.MdbJet3Constants;
        MdbFile f = mdb.f = mem.mdb_alloc_file();
        f.fd = file2;
        ++f.refs;
        if (file.mdb_read_pg(mdb, 0L) == 0L) {
            throw new IOException("Couldn't read first page.");
        }
        f.jet_version = file.mdb_get_int32(mdb, 20);
        mdb.fmt = macros.IS_JET4(mdb) ? MdbFormatConstants.MdbJet4Constants : MdbFormatConstants.MdbJet3Constants;
        f.db_key = file.mdb_get_int32(mdb, 62);
        f.db_key ^= 0xE15E01B9;
        for (int pos = 0; pos < 14; ++pos) {
            int j = file.mdb_get_int32(mdb, 66 + pos);
            f.db_passwd[pos] = (j ^= key[pos]) != 0 ? (char)j : (char)'\u0000';
        }
        return mdb;
    }

    public static MdbHandle mdb_open(RandomAccess file2) throws IOException {
        return file._mdb_open(file2);
    }

    public static long mdb_read_pg(MdbHandle mdb, long pg) throws IOException {
        long len = file._mdb_read_pg(mdb, mdb.pg_buf, pg);
        mdb.cur_pos = 0L;
        return len;
    }

    private static long _mdb_read_pg(MdbHandle mdb, byte[] pg_buf, long pg) throws IOException {
        long offset = pg * (long)mdb.fmt.pg_size;
        if (mdb.f.fd.length() < offset) {
            pg = (mdb.f.fd.length() - (long)mdb.fmt.pg_size) / (long)mdb.fmt.pg_size;
            offset = pg * (long)mdb.fmt.pg_size;
            if (mdb.f.fd.length() < offset) {
                throw new RuntimeException("offset " + offset + " is beyond EOF");
            }
        }
        if (mdb.stats != null && mdb.stats.collect) {
            ++mdb.stats.pg_reads;
        }
        mdb.f.fd.seek(offset);
        long len = mdb.f.fd.read(pg_buf, 0, mdb.fmt.pg_size);
        if (len == -1L) {
            throw new RuntimeException("read error");
        }
        if (len < (long)mdb.fmt.pg_size) {
            throw new RuntimeException("EOF reached");
        }
        mdb.cur_pg = (short)pg;
        return len;
    }

    public static int _mdb_get_int32(byte[] buf, int offset) {
        int pos = offset;
        int b1 = buf[pos++];
        int b2 = buf[pos++];
        int b3 = buf[pos++];
        int b4 = buf[pos];
        if (b1 < 0) {
            b1 += 256;
        }
        if (b2 < 0) {
            b2 += 256;
        }
        if (b3 < 0) {
            b3 += 256;
        }
        if (b4 < 0) {
            b4 += 256;
        }
        return b1 + (b2 <<= 8) + (b3 <<= 16) + (b4 <<= 24);
    }

    public static int mdb_get_int32(MdbHandle mdb, int offset) {
        if (offset < 0 || offset + 4 > mdb.fmt.pg_size) {
            return -1;
        }
        int l = file._mdb_get_int32(mdb.pg_buf, offset);
        mdb.cur_pos += 4L;
        return l;
    }

    private static int _mdb_get_int16(byte[] buf, int offset) {
        return file.unsign(buf[offset + 1]) * 256 + file.unsign(buf[offset]);
    }

    public static int mdb_get_int16(MdbHandle mdb, int offset) {
        if (offset < 0 || offset + 2 > mdb.fmt.pg_size) {
            return -1;
        }
        int i = file._mdb_get_int16(mdb.pg_buf, offset);
        mdb.cur_pos += 2L;
        return i;
    }

    public static long mdb_read_alt_pg(MdbHandle mdb, long pg) throws IOException {
        long len = file._mdb_read_pg(mdb, mdb.alt_pg_buf, pg);
        return len;
    }

    public static int mdb_get_int24(MdbHandle mdb, int offset) {
        if (offset < 0 || offset + 3 > mdb.fmt.pg_size) {
            return -1;
        }
        byte[] c = mdb.pg_buf;
        int l = file.unsign(c[offset + 2]);
        l <<= 8;
        l += file.unsign(c[offset + 1]);
        l <<= 8;
        mdb.cur_pos += 3L;
        return l += file.unsign(c[offset + 0]);
    }

    public static void mdb_swap_pgbuf(MdbHandle mdb) {
        byte[] tmpbuf = new byte[4096];
        System.arraycopy(mdb.pg_buf, 0, tmpbuf, 0, 4096);
        System.arraycopy(mdb.alt_pg_buf, 0, mdb.pg_buf, 0, 4096);
        System.arraycopy(tmpbuf, 0, mdb.alt_pg_buf, 0, 4096);
    }

    public static int unsign(byte b) {
        int i = b;
        if (i < 0) {
            i += 256;
        }
        return i;
    }

    public static double mdb_get_double(MdbHandle mdb, int offset) {
        if (offset < 0 || offset + 4 > mdb.fmt.pg_size) {
            return -1.0;
        }
        int currentByte = offset;
        long accum = 0L;
        for (int shiftBy = 0; shiftBy < 64; shiftBy += 8) {
            accum |= (long)(mdb.pg_buf[currentByte++] & 0xFF) << shiftBy;
        }
        double d = Double.longBitsToDouble(accum);
        mdb.cur_pos += 8L;
        return d;
    }

    public static int mdb_get_byte(MdbHandle mdb, int offset) {
        byte c = mdb.pg_buf[offset];
        ++mdb.cur_pos;
        return file.unsign(c);
    }

    public static float mdb_get_single(MdbHandle mdb, int offset) {
        if (offset < 0 || offset + 4 > mdb.fmt.pg_size) {
            return -1.0f;
        }
        int currentByte = offset;
        int accum = 0;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            accum |= (mdb.pg_buf[currentByte++] & 0xFF) << shiftBy;
        }
        float f = Float.intBitsToFloat(accum);
        mdb.cur_pos += 4L;
        return f;
    }
}

