/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class prefs {
    public static final boolean DEBUG = Boolean.valueOf(System.getenv("DEBUG"));
    public static final String ROOT = "omero.prefs";
    public static final String DEFAULT = "default";
    private static final RuntimeException USAGE = new RuntimeException("usage");
    private static final RuntimeException CONFLICT = new RuntimeException("conflict");
    private static Preferences prefs = Preferences.userRoot().node("omero.prefs");
    private static boolean testing = false;
    private static int testcount = 0;
    private static int failures = 0;

    public static void main(String[] args) {
        try {
            prefs.exit(prefs.print(prefs.dispatch(prefs.notNull(args))));
        }
        catch (Throwable e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            if (e == USAGE) {
                prefs.exit(prefs.printErr(prefs.usage(args)));
            }
            if (e == CONFLICT) {
                prefs.exit(prefs.printErr(prefs.args("Conflict found in properties. Use drop or load_nowarn")));
            }
            if (e instanceof BackingStoreException) {
                prefs.exit(prefs.printErr(prefs.args("Error accessing preferences:", e.getMessage())));
            }
            if (e instanceof IOException) {
                prefs.exit(prefs.printErr(prefs.args("IO Error:", e.getMessage())));
            }
            prefs.exit(prefs.printErr(prefs.args("Unknown error:", e.getMessage())));
        }
    }

    public static String[] usage(String[] args) {
        return new String[]{"                                                                  ", " usage: prefs COMMAND [ARGS]                         ", "                                                                  ", "  all                   :  list all profiles under omero.prefs", "  def [NEWDEFAULT]      :  list (or set) current default profile", "  drop                  :  deletes current profile", "  get [KEY [KEY [...]]] :  get keys from the current profile. All by default", "  export [FILE ]        :  export to a file or standard out", "  keys                  :  list all keys for the current profile", "  load [FILE...]        :  read into current profile from a file or standard in (error on conflict)", "  load_nowarn [FILE...] :  read current profile from a file or standard in", "  set KEY=VALUE         :  set value on current profile", "  sys COMMANDS          :  applies commands as above to system preferences", "                                                                  ", "Note: profiles are created on demand. Later properties override earlier ones."};
    }

    public static String[] help(String[] args) {
        return prefs.usage(args);
    }

    public static String[] print(String[] args) {
        for (String string : args) {
            if (string == null) continue;
            System.out.println(string);
        }
        return new String[0];
    }

    public static String[] printErr(String[] args) {
        for (String string : args) {
            if (string == null) continue;
            System.err.println(string);
        }
        return args;
    }

    public static String[] printDebug(String[] args) {
        if (DEBUG) {
            prefs.printErr(args);
        }
        return args;
    }

    public static String[] exit(String[] args) {
        System.exit(args.length);
        return null;
    }

    public static String[] dispatch(String[] args) throws Throwable {
        Method m;
        if (args == null || args.length == 0) {
            USAGE.fillInStackTrace();
            throw USAGE;
        }
        String method = args[0];
        args = prefs.pop(args);
        try {
            m = prefs.class.getMethod(method, String[].class);
        }
        catch (Exception e) {
            USAGE.fillInStackTrace();
            throw USAGE;
        }
        try {
            return (String[])m.invoke(null, new Object[]{args});
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
    }

    public static String[] sys(String[] args) throws Throwable {
        prefs = Preferences.systemRoot().node(ROOT);
        return prefs.dispatch(args);
    }

    public static String[] all(String[] args) throws BackingStoreException {
        return prefs.childrenNames();
    }

    public static String[] def(String[] args) {
        if ((args = prefs.notNull(args)).length == 0) {
            String OMERO = System.getenv("OMERO");
            if (OMERO == null && (OMERO = prefs.get(DEFAULT, null)) == null) {
                prefs.put(DEFAULT, DEFAULT);
                OMERO = DEFAULT;
            }
            return new String[]{OMERO};
        }
        if (args.length == 1) {
            prefs.put(DEFAULT, args[0] == null ? "" : args[0]);
            return new String[]{"Default set to: " + prefs.def(prefs.args(new String[0]))[0]};
        }
        USAGE.fillInStackTrace();
        throw USAGE;
    }

    public static String[] drop(String[] args) throws BackingStoreException {
        prefs._node().removeNode();
        return prefs.args(new String[0]);
    }

    public static String[] keys(String[] args) throws BackingStoreException {
        return prefs._node().keys();
    }

    public static String[] get(String[] args) throws BackingStoreException {
        args = prefs.notNull(args);
        String[] keys = prefs._node().keys();
        if (args.length == 0) {
            if (keys.length == 0) {
                return args;
            }
            if (keys.length == 1) {
                return prefs.get(prefs.args(keys[0], "UNKNOWNKEYJUSTTOFORCELENGTH2"));
            }
            return prefs.get(keys);
        }
        if (args.length == 1) {
            String key = args[0] == null ? "" : args[0];
            String value = prefs._node().get(key, "");
            return prefs.args(value);
        }
        HashSet<String> availableKeys = new HashSet<String>(Arrays.asList(prefs._node().keys()));
        String[] rv = new String[args.length];
        for (int i = 0; i < rv.length; ++i) {
            String key;
            String string = key = args[i] == null ? "" : args[i];
            if (!availableKeys.contains(key)) continue;
            String value = prefs._node().get(key, "");
            rv[i] = key + "=" + value;
        }
        return rv;
    }

    public static String[] set(String[] args) throws BackingStoreException {
        if (args == null || args.length != 2) {
            USAGE.fillInStackTrace();
            throw USAGE;
        }
        String key = args[0] == null ? "" : args[0];
        String val = args[1] == null ? "" : args[1];
        prefs._node().put(key, val);
        return prefs.args(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] export(String[] args) throws BackingStoreException, IOException {
        if (args.length == 0) {
            prefs._export(System.out);
            return prefs.args(new String[0]);
        }
        if (args.length == 1) {
            File f = new File(args[0]);
            if (f.exists()) {
                throw new IOException("File " + f.getAbsolutePath() + " exists!");
            }
            FilterOutputStream bos = null;
            try {
                bos = new BufferedOutputStream(new FileOutputStream(args[0]));
                prefs._export(bos);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return prefs.args(new String[0]);
        }
        USAGE.fillInStackTrace();
        throw USAGE;
    }

    public static String[] load(String[] args) throws IOException {
        Properties p = (args = prefs.notNull(args)).length == 0 ? prefs._stdin() : prefs._merge(args);
        Preferences node = prefs._node();
        for (Object obj : p.keySet()) {
            String key = obj.toString();
            String currentValue = node.get(key, "");
            if (currentValue == null || currentValue.length() <= 0) continue;
            prefs.printErr(prefs.args(key + " already present!"));
            throw CONFLICT;
        }
        prefs._load(p);
        return prefs.args(new String[0]);
    }

    public static String[] load_nowarn(String[] args) throws IOException {
        Properties p = (args = prefs.notNull(args)).length == 0 ? prefs._stdin() : prefs._merge(args);
        prefs._load(p);
        return prefs.args(new String[0]);
    }

    public static String[] args(String ... args) {
        return args;
    }

    public static String[] join(String ... args) {
        StringBuilder sb = new StringBuilder();
        for (String string : args) {
            sb.append(string);
            sb.append(" ");
        }
        return new String[]{sb.toString()};
    }

    public static String[] notNull(String[] args) {
        if (args == null) {
            return new String[0];
        }
        return args;
    }

    public static String[] pop(String[] args) {
        int sz = args.length - 1;
        if (sz < 0) {
            return args;
        }
        String[] newArgs = new String[sz];
        System.arraycopy(args, 1, newArgs, 0, sz);
        return newArgs;
    }

    private static String[] _ok(String ... args) throws Throwable {
        String[] rv;
        String test;
        block2: {
            ++testcount;
            test = prefs.join(args)[0];
            rv = prefs.args(new String[0]);
            try {
                rv = prefs.dispatch(args);
            }
            catch (Exception e) {
                prefs.printErr(prefs.join("fail...", test));
                ++failures;
                if (!DEBUG) break block2;
                e.printStackTrace();
            }
        }
        prefs.printErr(prefs.join("ok...", test));
        prefs.printDebug(rv);
        return rv;
    }

    private static String[] _fail(String ... args) throws Throwable {
        ++testcount;
        String test = prefs.join(args)[0];
        String[] rv = prefs.args(new String[0]);
        try {
            rv = prefs.dispatch(args);
            prefs.printErr(prefs.join("fail...", test, "No exception thrown."));
            ++failures;
        }
        catch (Exception e) {
            prefs.printErr(prefs.join("ok...", test));
        }
        prefs.printDebug(rv);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] test(String[] args) throws Throwable {
        if (testing) {
            throw new RuntimeException("testing already running");
        }
        testing = true;
        failures = 0;
        String origconf = prefs.def(prefs.args(new String[0]))[0];
        String testconf = "testconf";
        prefs.def(prefs.args(testconf));
        try {
            prefs._fail("test");
            prefs._fail("_node");
            prefs._fail("NOMETHOD");
            prefs._fail("_ok", "printDebug");
            prefs._fail("_fail", "NOMETHOD");
            prefs._ok("print", "stuff");
            prefs._ok("printErr", "stuff");
            prefs._ok("printDebug", "stuff");
            prefs._ok("print", null);
            prefs._ok("printErr", null);
            prefs._ok("printDebug", null);
            prefs._ok("print");
            prefs._ok("printErr");
            prefs._ok("printDebug");
            prefs._fail(new String[0]);
            prefs._fail("dispatch");
            prefs._ok("join", "a", "b", "c");
            prefs._ok("join", "a");
            prefs._ok("join");
            prefs._ok("join", null);
            prefs._ok("pop", "a", "b", "c");
            prefs._ok("pop", "a");
            prefs._ok("pop");
            prefs._ok("pop", null);
            prefs._ok("notNull", "a", "b", "c");
            prefs._ok("notNull", "a");
            prefs._ok("notNull");
            prefs._ok("notNull", null);
            prefs._ok("args", "a", "b", "c");
            prefs._ok("args", "a");
            prefs._ok("args");
            prefs._ok("args", null);
            prefs._ok("usage");
            prefs._ok("usage", "stuff");
            prefs._ok("usage", null);
            prefs._ok("help");
            prefs._ok("help", "stuff");
            prefs._ok("help", null);
            prefs._ok("all");
            prefs._ok("keys");
            prefs._ok("keys", null);
            prefs._ok("keys", "stuff");
            prefs._ok("def", "new_test_configuration");
            prefs._ok("def", testconf);
            prefs._ok("def", null);
            prefs._fail("def", "too", "many", "args");
            prefs._fail("set");
            prefs._fail("set", null);
            prefs._ok("set", "SHOULDBEFOO", "FOO");
            prefs._ok("get");
            prefs._ok("get", null);
            prefs._ok("get", "NONEXTANTVALUE");
            prefs._ok("get", "SHOULDBEFOO");
            prefs._ok("def", "droptest");
            prefs._ok("set", "a", "b");
            prefs._ok("drop");
            prefs._ok("def", testconf);
            prefs.print(prefs.args("============================================"));
            prefs.print(prefs.args(failures + " from " + testcount + " failed."));
        }
        catch (Throwable throwable) {
            prefs.def(prefs.args(origconf));
            throw throwable;
        }
        prefs.def(prefs.args(origconf));
        return prefs.args(new String[0]);
    }

    private static Preferences _node() {
        Preferences p = prefs.node(prefs.def(prefs.args(new String[0]))[0]);
        return p;
    }

    private static void _export(OutputStream os) throws BackingStoreException, IOException {
        String[] values = prefs.get(prefs.args(new String[0]));
        OutputStreamWriter osw = new OutputStreamWriter(os);
        for (String string : values) {
            osw.write(string);
            osw.write("\n");
        }
        osw.flush();
    }

    private static void _load(Properties properties) {
        Preferences p = prefs._node();
        for (Object obj : properties.keySet()) {
            Object value = properties.get(obj);
            if (value == null) {
                value = "";
            }
            p.put(obj.toString(), value.toString());
        }
    }

    private static Properties _stdin() throws IOException {
        int available = 0;
        available = System.in.available();
        Properties p = new Properties();
        if (available > 0) {
            p.load(System.in);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties _merge(String ... args) throws IOException {
        Properties p = new Properties();
        for (String string : args) {
            File f = new File(string);
            FileInputStream fis = new FileInputStream(f);
            try {
                p.load(fis);
            }
            finally {
                fis.close();
            }
        }
        return p;
    }
}

