/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re.data;

import java.io.Serializable;

public class PlaneDef
implements Serializable {
    private static final long serialVersionUID = -3200013163481587159L;
    public static final int XY = 0;
    public static final int ZY = 1;
    public static final int XZ = 2;
    private int slice;
    private int x;
    private int y;
    private int z;
    private int t;

    public PlaneDef(int slice, int t) {
        switch (slice) {
            case 0: 
            case 1: 
            case 2: {
                this.slice = slice;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong slice identifier: " + slice + ".");
            }
        }
        if (t < 0) {
            throw new IllegalArgumentException("Negative timepoint: " + t + ".");
        }
        this.t = t;
    }

    public void setX(int x) {
        if (1 != this.slice) {
            throw new IllegalArgumentException("X index can only be set for ZY planes.");
        }
        if (x < 0) {
            throw new IllegalArgumentException("Negative index: " + x + ".");
        }
        this.x = x;
    }

    public void setY(int y) {
        if (2 != this.slice) {
            throw new IllegalArgumentException("Y index can only be set for XZ planes.");
        }
        if (y < 0) {
            throw new IllegalArgumentException("Negative index: " + y + ".");
        }
        this.y = y;
    }

    public void setZ(int z) {
        if (0 != this.slice) {
            throw new IllegalArgumentException("Z index can only be set for XY planes.");
        }
        if (z < 0) {
            throw new IllegalArgumentException("Negative index: " + z + ".");
        }
        this.z = z;
    }

    public int getSlice() {
        return this.slice;
    }

    public int getT() {
        return this.t;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (o != null && o instanceof PlaneDef) {
            PlaneDef other = (PlaneDef)o;
            if (other.slice == this.slice && other.t == this.t) {
                switch (this.slice) {
                    case 0: {
                        isEqual = other.z == this.z;
                        break;
                    }
                    case 1: {
                        isEqual = other.x == this.x;
                        break;
                    }
                    case 2: {
                        isEqual = other.y == this.y;
                    }
                }
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int u = -1;
        int two15 = 32768;
        switch (this.slice) {
            case 0: {
                u = this.z;
                break;
            }
            case 1: {
                u = this.x;
                break;
            }
            case 2: {
                u = this.y;
            }
        }
        return u % two15 * two15 + this.t % two15;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        switch (this.slice) {
            case 0: {
                buf.append("Type: XY, ");
                buf.append("z=" + this.z);
                break;
            }
            case 1: {
                buf.append("Type: ZY, ");
                buf.append("x=" + this.x);
                break;
            }
            case 2: {
                buf.append("Type: XZ, ");
                buf.append("y=" + this.y);
            }
        }
        buf.append(", t=" + this.t);
        return buf.toString();
    }
}

