/*
 * Decompiled with CFR 0.152.
 */
package ome.util.tasks.admin;

import java.util.Properties;
import ome.annotations.RevisionDate;
import ome.annotations.RevisionNumber;
import ome.api.IAdmin;
import ome.conditions.SecurityViolation;
import ome.model.meta.Experimenter;
import ome.system.ServiceFactory;
import ome.util.tasks.TaskFailure;
import ome.util.tasks.admin.AdminTask;

@RevisionDate(value="$Date: 2007-01-24 17:23:09 +0100 (Wed, 24 Jan 2007) $")
@RevisionNumber(value="$Revision: 1208 $")
public class DeleteUserTask
extends AdminTask {
    public DeleteUserTask(ServiceFactory sf, Properties p) {
        super(sf, p);
    }

    public void doTask() {
        super.doTask();
        IAdmin admin = this.getServiceFactory().getAdminService();
        String name = this.enumValue(Keys.user);
        Experimenter e = admin.lookupExperimenter(name);
        e.unload();
        admin.deleteExperimenter(e);
        this.getLogger().info((Object)String.format("Deleted user %s with id %d", name, e.getId()));
    }

    public void handleException(RuntimeException re) {
        String msg;
        if (SecurityViolation.class.isAssignableFrom(re.getClass()) && (msg = re.getMessage()).contains("Deleting") && msg.contains("not allowed")) {
            throw new TaskFailure("SecurityViolation:" + msg + "\n You may try running this task as \"root\"");
        }
        super.handleException(re);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Keys {
        user;

    }
}

