/*
 * Decompiled with CFR 0.152.
 */
package ome.util.tasks.admin;

import java.util.Properties;
import ome.annotations.RevisionDate;
import ome.annotations.RevisionNumber;
import ome.conditions.ApiUsageException;
import ome.conditions.SecurityViolation;
import ome.system.ServiceFactory;
import ome.util.tasks.SimpleTask;
import ome.util.tasks.TaskFailure;

@RevisionDate(value="$Date: 2007-01-24 17:23:09 +0100 (Wed, 24 Jan 2007) $")
@RevisionNumber(value="$Revision: 1208 $")
public abstract class AdminTask
extends SimpleTask {
    public AdminTask(ServiceFactory serviceFactory, Properties properties) {
        super(serviceFactory, properties);
    }

    public void init() {
        super.init();
    }

    public void handleException(RuntimeException re) {
        if (re.getClass().getName().contains("EJBAccessException")) {
            if (re.getMessage().contains("Authentication failure")) {
                throw new TaskFailure("Admin login to server failed.");
            }
            if (re.getMessage().contains("Authorization failure")) {
                String user = this.getProperties().getProperty("omero.user");
                throw new TaskFailure(user + " is not authorized for this task.");
            }
        } else {
            if (SecurityViolation.class.isAssignableFrom(re.getClass())) {
                throw new TaskFailure("SecurityViolation:" + re.getMessage());
            }
            if (ApiUsageException.class.isAssignableFrom(re.getClass())) {
                throw new TaskFailure("ApiUsage:" + re.getMessage());
            }
        }
        super.handleException(re);
    }
}

