/*
 * Decompiled with CFR 0.152.
 */
package ome.util.tasks;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import ome.annotations.RevisionDate;
import ome.annotations.RevisionNumber;
import ome.util.tasks.Configuration;
import ome.util.tasks.Task;
import ome.util.tasks.TaskFailure;

@RevisionDate(value="$Date: 2007-02-15 17:13:20 +0000 (Thu, 15 Feb 2007) $")
@RevisionNumber(value="$Revision: 1282 $")
public class Run {
    protected Configuration opts;
    protected Task task;

    public static void main(String[] args) {
        Run run = new Run(args);
        run.run();
    }

    public Run(String[] args) {
        this(new Configuration(Run.getProperties(args)));
    }

    public Run(Configuration config) {
        this.opts = config;
        this.task = this.opts.createTask();
    }

    public Run(Task taskInstance) {
        this.task = taskInstance;
    }

    public void run() {
        this.setup();
        try {
            this.task.run();
        }
        catch (TaskFailure te) {
            throw te;
        }
        catch (RuntimeException re) {
            System.err.println(this.task + " failed with a RuntimeException:");
            throw re;
        }
        finally {
            this.cleanup();
        }
    }

    protected void setup() {
    }

    protected void cleanup() {
    }

    protected static Properties getProperties(String[] args) {
        Properties props = Run.readStdin();
        props.putAll((Map<?, ?>)Run.parseArgs(args));
        return props;
    }

    protected static Properties readStdin() {
        Properties p = new Properties();
        int available = 0;
        try {
            available = System.in.available();
        }
        catch (IOException e1) {
            System.err.println("Could not check available bytes on standard in.");
            e1.printStackTrace();
        }
        if (available > 0) {
            try {
                p.load(System.in);
            }
            catch (IOException e) {
                System.err.println("Invalid properties file on standard in:");
                e.printStackTrace();
            }
        } else {
            System.err.println("No input on standard in.");
        }
        return p;
    }

    protected static Properties parseArgs(String[] args) {
        Properties p = new Properties();
        if (args == null || args.length == 0) {
            return p;
        }
        List<String> argList = Arrays.asList(args);
        for (int i = 0; i < args.length; ++i) {
            String[] parts = args[i].split("=");
            if (parts.length == 1) {
                p.put(parts[0], "");
                continue;
            }
            if (parts.length == 2) {
                p.put(parts[0], parts[1]);
                continue;
            }
            throw new IllegalArgumentException("Arguments can only have one \"=\".");
        }
        return p;
    }
}

