/*
 * Decompiled with CFR 0.152.
 */
package ome.util.builders;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class PojoOptions {
    public static final String FIELDS = "fields";
    public static final String COUNTS = "counts";
    public static final String LEAF = "leaves";
    public static final String EXPERIMENTER = "experimenter";
    public static final String GROUP = "group";
    public static final String START_TIME = "startTime";
    public static final String END_TIME = "endTime";
    private final Map options = new HashMap();

    public PojoOptions() {
        this.noLeaves().countsForUser().countFields(new String[]{"DatasetAnnotation_dataset", "ImageAnnotation_image", "CategoryImageLink_child"});
    }

    public PojoOptions(Map map) {
        if (null != map) {
            this.copy(map);
        } else {
            this.copy(new PojoOptions().map());
        }
    }

    protected void copy(Map map) {
        String[] s = new String[]{FIELDS, COUNTS, LEAF, EXPERIMENTER, GROUP, START_TIME, END_TIME};
        for (int i = 0; i < s.length; ++i) {
            if (!map.containsKey(s[i])) continue;
            this.options.put(s[i], map.get(s[i]));
        }
    }

    public PojoOptions leaves() {
        this.options.put(LEAF, Boolean.TRUE);
        return this;
    }

    public PojoOptions noLeaves() {
        this.options.remove(LEAF);
        return this;
    }

    public boolean isLeaves() {
        return this.options.containsKey(LEAF);
    }

    public PojoOptions countFields(String[] fields) {
        this.options.put(FIELDS, fields);
        return this;
    }

    public String[] countFields() {
        return (String[])this.options.get(FIELDS);
    }

    public boolean hasCountFields() {
        return this.options.containsKey(FIELDS) && this.options.get(FIELDS) != null;
    }

    public PojoOptions noCounts() {
        this.remove(COUNTS);
        return this;
    }

    public PojoOptions countsFor(Long i) {
        this.options.put(COUNTS, i);
        return this;
    }

    public PojoOptions countsForUser() {
        this.options.put(COUNTS, Boolean.TRUE);
        return this;
    }

    public PojoOptions allCounts() {
        this.options.put(COUNTS, null);
        return this;
    }

    public boolean isCounts() {
        return this.options.containsKey(COUNTS);
    }

    public boolean isCountsForUser() {
        return this.isCounts() && this.options.get(COUNTS) instanceof Boolean;
    }

    public boolean isAllCounts() {
        return this.isCounts() && this.options.get(COUNTS) == null;
    }

    public Integer getCounts() {
        return (Integer)this.options.get(COUNTS);
    }

    public PojoOptions exp(Long i) {
        this.options.put(EXPERIMENTER, i);
        return this;
    }

    public PojoOptions allExps() {
        this.remove(EXPERIMENTER);
        return this;
    }

    public boolean isExperimenter() {
        return this.options.containsKey(EXPERIMENTER);
    }

    public Long getExperimenter() {
        return (Long)this.options.get(EXPERIMENTER);
    }

    public PojoOptions startTime(Timestamp startTime) {
        this.options.put(START_TIME, startTime);
        return this;
    }

    public PojoOptions endTime(Timestamp endTime) {
        this.options.put(END_TIME, endTime);
        return this;
    }

    public PojoOptions allTimes() {
        this.remove(START_TIME);
        this.remove(END_TIME);
        return this;
    }

    public boolean isStartTime() {
        return this.options.containsKey(START_TIME);
    }

    public boolean isEndTime() {
        return this.options.containsKey(END_TIME);
    }

    public Timestamp getStartTime() {
        return (Timestamp)this.options.get(START_TIME);
    }

    public Timestamp getEndTime() {
        return (Timestamp)this.options.get(END_TIME);
    }

    public PojoOptions grp(Long i) {
        this.options.put(GROUP, i);
        return this;
    }

    public PojoOptions allGrps() {
        this.remove(GROUP);
        return this;
    }

    public boolean isGroup() {
        return this.options.containsKey(GROUP);
    }

    public Long getGroup() {
        return (Long)this.options.get(GROUP);
    }

    protected void remove(String key) {
        if (this.options.containsKey(key)) {
            this.options.remove(key);
        }
    }

    public Map map() {
        return this.options;
    }
}

