/*
 * Decompiled with CFR 0.152.
 */
package ome.util;

import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.api.ModelBased;
import ome.model.meta.Event;
import ome.util.ContextFilter;
import ome.util.Filterable;
import ome.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ModelMapper
extends ContextFilter {
    protected static Log log = LogFactory.getLog(ModelMapper.class);
    protected Map model2target = new IdentityHashMap();

    protected abstract Map c2c();

    public ModelBased map(Filterable source) {
        Filterable o = this.filter("MAPPING...", source);
        return (ModelBased)this.model2target.get(o);
    }

    public Collection map(Collection source) {
        Collection o = this.filter("MAPPING...", source);
        return (Collection)this.model2target.get(o);
    }

    public Map map(Map source) {
        Map o = this.filter("MAPPING...", source);
        return (Map)this.model2target.get(o);
    }

    public Filterable filter(String fieldId, Filterable source) {
        Filterable o = super.filter(fieldId, source);
        ModelBased target = (ModelBased)this.findTarget(o);
        this.fillTarget(source, target);
        return o;
    }

    public Collection filter(String fieldId, Collection source) {
        Collection o = super.filter(fieldId, source);
        Collection target = this.findCollection(o);
        this.fillCollection(source, target);
        return o;
    }

    public Map filter(String fieldId, Map source) {
        Map o = super.filter(fieldId, source);
        Map target = this.findMap(o);
        this.fillMap(source, target);
        return o;
    }

    protected Class findClass(Class source) {
        return (Class)this.c2c().get(Utils.trueClass(source));
    }

    public Object findTarget(Object current) {
        Class targetType;
        if (null == current || current instanceof Number || current instanceof String || current instanceof Boolean || current instanceof Timestamp) {
            return current;
        }
        Object target = this.model2target.get(current);
        if (null == target && null != (targetType = this.findClass(current.getClass()))) {
            try {
                target = targetType.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Internal error: could not instantiate object of type " + targetType + " while trying to map " + current, e);
            }
            this.model2target.put(current, target);
        }
        return target;
    }

    public Collection findCollection(Collection source) {
        if (source == null) {
            return null;
        }
        AbstractCollection target = (HashSet)this.model2target.get(source);
        if (null == target) {
            if (Set.class.isAssignableFrom(source.getClass())) {
                target = new HashSet();
            } else if (List.class.isAssignableFrom(source.getClass())) {
                target = new ArrayList();
            } else {
                throw new RuntimeException("Unknown collection type: " + source.getClass());
            }
            this.model2target.put(source, target);
        }
        return target;
    }

    public Map findMap(Map source) {
        if (source == null) {
            return null;
        }
        Map target = (Map)this.model2target.get(source);
        if (null == target) {
            try {
                target = (Map)source.getClass().newInstance();
                this.model2target.put(source, target);
            }
            catch (InstantiationException ie) {
                throw new RuntimeException(ie);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
        }
        return target;
    }

    private void fillTarget(Filterable source, ModelBased target) {
        if (source != null && target != null) {
            target.copyObject(source, this);
        }
    }

    private void fillCollection(Collection source, Collection target) {
        if (source != null && target != null) {
            for (Object o : source) {
                target.add(this.findTarget(o));
            }
        }
    }

    private void fillMap(Map source, Map target) {
        if (source != null && target != null) {
            for (Object o : source.keySet()) {
                target.put(this.findTarget(o), this.findTarget(source.get(o)));
            }
        }
    }

    public Timestamp event2timestamp(Event event) {
        if (event == null) {
            return null;
        }
        if (!event.isLoaded()) {
            return null;
        }
        if (event.getTime() == null) {
            return null;
        }
        return event.getTime();
    }

    public int nullSafeInt(Integer i) {
        if (i == null) {
            return 0;
        }
        return i;
    }

    public long nullSafeLong(Long l) {
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public double nullSafeDouble(Double d) {
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public float nullSafeFloat(Float f) {
        if (f == null) {
            return 0.0f;
        }
        return f.floatValue();
    }
}

