/*
 * Decompiled with CFR 0.152.
 */
package ome.testing;

import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import ome.api.RawFileStore;
import ome.conditions.ApiUsageException;
import ome.model.core.OriginalFile;
import ome.model.enums.Format;
import ome.model.internal.Permissions;
import ome.model.meta.Experimenter;
import ome.system.ServiceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUploader
implements Runnable {
    private static final Log log = LogFactory.getLog(FileUploader.class);
    private final ServiceFactory sf;
    private final File file;
    private final String text;
    private long rSize = 0L;
    private byte[] rBuf = null;
    private String rSha1 = null;
    private boolean locked = false;
    private OriginalFile ofile = new OriginalFile();

    public FileUploader(ServiceFactory sf, File file) throws Exception {
        if (sf == null || file == null) {
            throw new ApiUsageException("Non null arguments.");
        }
        this.sf = sf;
        this.file = file;
        this.text = null;
    }

    public FileUploader(ServiceFactory sf, String text, String name, String path) throws Exception {
        if (sf == null || text == null || name == null || path == null) {
            throw new ApiUsageException("Non null arguments.");
        }
        this.sf = sf;
        this.file = null;
        this.text = text;
        this.ofile.setName(name);
        this.ofile.setPath(path);
    }

    public synchronized void init() {
        this.locked = true;
        try {
            if (this.text != null) {
                this.handleString();
            } else {
                this.handleFile();
            }
        }
        catch (Exception e) {
            String msg = "Error handling " + (this.text == null ? "file" : "text") + " for file upload.";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        this.ofile.setSize(this.rSize);
        this.ofile.setSha1(this.bufferToSha1(this.rBuf));
    }

    public synchronized void run() {
        this.init();
        this.ofile = this.sf.getUpdateService().saveAndReturnObject(this.ofile);
        RawFileStore rfs = this.sf.createRawFileStore();
        rfs.setFileId(this.ofile.getId());
        rfs.write(this.rBuf, 0L, (int)this.rSize);
        rfs.close();
    }

    private void handleString() throws Exception {
        byte[] buf = this.text.getBytes();
        this.rSize = buf.length;
        this.rBuf = buf;
        this.rSha1 = this.bufferToSha1(buf);
        assert (this.ofile.getName() != null);
        assert (this.ofile.getPath() != null);
        if (this.ofile.getFormat() == null) {
            this.ofile.setFormat(new Format("text/plain"));
        }
    }

    private void handleFile() throws Exception {
        this.rSize = this.file.length();
        this.rBuf = new byte[(int)this.rSize];
        FileInputStream fis = new FileInputStream(this.file);
        assert ((int)this.rSize == fis.read(this.rBuf)) : "read whole file";
        this.rSha1 = this.bufferToSha1(this.rBuf);
        if (this.ofile.getName() == null) {
            this.ofile.setName(this.file.getName());
        }
        if (this.ofile.getPath() == null) {
            this.ofile.setPath(this.file.getAbsolutePath());
        }
        if (this.ofile.getFormat() == null) {
            this.ofile.setFormat(new Format("text/plain"));
        }
    }

    private void checkLocked() {
        if (this.locked) {
            throw new ApiUsageException("File already uploaded.");
        }
    }

    private void checkAdmin() {
        boolean admin = this.sf.getAdminService().getEventContext().isCurrentUserAdmin();
        if (!admin) {
            throw new ApiUsageException("Owner and group can only be set by admins.");
        }
    }

    private String bufferToSha1(byte[] buffer) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Required SHA-1 message digest algorithm unavailable.");
        }
        md.reset();
        md.update(buffer);
        byte[] digest = md.digest();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            buf.append(FileUploader.byteToHex(digest[i]));
        }
        return buf.toString();
    }

    private static String byteToHex(byte data) {
        StringBuffer buf = new StringBuffer();
        buf.append(FileUploader.toHexChar(data >>> 4 & 0xF));
        buf.append(FileUploader.toHexChar(data & 0xF));
        return buf.toString();
    }

    private static char toHexChar(int i) {
        if (0 <= i && i <= 9) {
            return (char)(48 + i);
        }
        return (char)(97 + i - 10);
    }

    public synchronized Long getId() {
        return this.ofile.getId();
    }

    public synchronized String getName() {
        return this.ofile.getName();
    }

    public synchronized void setName(String name) {
        this.checkLocked();
        this.ofile.setName(name);
    }

    public synchronized String getPath() {
        return this.ofile.getPath();
    }

    public synchronized void setPath(String path) {
        this.checkLocked();
        this.ofile.setPath(path);
    }

    public synchronized String getFormat() {
        return this.ofile.getFormat() == null ? null : this.ofile.getFormat().getValue();
    }

    public synchronized void setFormat(String format) {
        this.checkLocked();
        this.ofile.setFormat(new Format(format));
    }

    public synchronized Timestamp getAtime() {
        return this.ofile.getAtime();
    }

    public synchronized void setAtime(Timestamp atime) {
        this.checkLocked();
        this.ofile.setAtime(atime);
    }

    public synchronized Timestamp getMtime() {
        return this.ofile.getMtime();
    }

    public synchronized void setMtime(Timestamp mtime) {
        this.checkLocked();
        this.ofile.setMtime(mtime);
    }

    public synchronized Timestamp getCtime() {
        return this.ofile.getCtime();
    }

    public synchronized void setCtime(Timestamp ctime) {
        this.checkLocked();
        this.ofile.setCtime(ctime);
    }

    public synchronized Permissions getPerms() {
        return this.ofile.getDetails().getPermissions();
    }

    public synchronized void setPerms(Permissions perms) {
        this.checkLocked();
        this.ofile.getDetails().setPermissions(perms);
    }

    public synchronized String getOwner() {
        return this.ofile.getDetails().getOwner() == null ? null : this.ofile.getDetails().getOwner().getOmeName();
    }

    public synchronized void setOwner(String owner) {
        this.checkLocked();
        this.checkAdmin();
        Experimenter e = this.sf.getAdminService().lookupExperimenter(owner);
        this.ofile.getDetails().setOwner(e);
    }

    public synchronized String getGroup() {
        return this.ofile.getDetails().getGroup() == null ? null : this.ofile.getDetails().getGroup().getName();
    }

    public synchronized void setGroup(String group) {
        this.checkLocked();
        this.checkAdmin();
        Experimenter e = this.sf.getAdminService().lookupExperimenter(group);
        this.ofile.getDetails().setOwner(e);
    }
}

