/*
 * Decompiled with CFR 0.152.
 */
package ome.system;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import ome.annotations.RevisionDate;
import ome.annotations.RevisionNumber;
import ome.system.EventContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RevisionDate(value="$Date: 2006-12-15 10:39:34 +0000 (Fri, 15 Dec 2006) $")
@RevisionNumber(value="$Revision: 1167 $")
public class SimpleEventContext
implements EventContext,
Serializable {
    private static final long serialVersionUID = -3918201598642847439L;
    private Long cgId;
    private Long cuId;
    private Long ceId;
    private String cgName;
    private String cuName;
    private String ceType;
    private boolean isAdmin;
    private boolean isReadOnly;
    private List<Long> memberOfGroups;
    private List<Long> leaderOfGroups;

    public SimpleEventContext(EventContext ec) {
        if (ec == null) {
            throw new IllegalArgumentException("Argument cannot be null.");
        }
        this.cgId = ec.getCurrentGroupId();
        this.cuId = ec.getCurrentUserId();
        this.ceId = ec.getCurrentEventId();
        this.cgName = ec.getCurrentGroupName();
        this.cuName = ec.getCurrentUserName();
        this.ceType = ec.getCurrentEventType();
        this.isAdmin = ec.isCurrentUserAdmin();
        this.isReadOnly = ec.isReadOnly();
        this.memberOfGroups = new ArrayList<Long>(ec.getMemberOfGroupsList());
        this.leaderOfGroups = new ArrayList<Long>(ec.getLeaderOfGroupsList());
    }

    @Override
    public Long getCurrentGroupId() {
        return this.cgId;
    }

    @Override
    public String getCurrentGroupName() {
        return this.cgName;
    }

    @Override
    public Long getCurrentUserId() {
        return this.cuId;
    }

    @Override
    public String getCurrentUserName() {
        return this.cuName;
    }

    @Override
    public boolean isCurrentUserAdmin() {
        return this.isAdmin;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public List<Long> getMemberOfGroupsList() {
        return this.memberOfGroups;
    }

    @Override
    public List<Long> getLeaderOfGroupsList() {
        return this.leaderOfGroups;
    }

    @Override
    public Long getCurrentEventId() {
        return this.ceId;
    }

    @Override
    public String getCurrentEventType() {
        return this.ceType;
    }
}

