/*
 * Decompiled with CFR 0.152.
 */
package ome.system;

import java.util.Map;
import java.util.Properties;
import ome.api.IAdmin;
import ome.api.IAnalysis;
import ome.api.IConfig;
import ome.api.ILdap;
import ome.api.IPixels;
import ome.api.IPojos;
import ome.api.IQuery;
import ome.api.IRenderingSettings;
import ome.api.IRepositoryInfo;
import ome.api.ITypes;
import ome.api.IUpdate;
import ome.api.JobHandle;
import ome.api.RawFileStore;
import ome.api.RawPixelsStore;
import ome.api.ServiceInterface;
import ome.api.ThumbnailStore;
import ome.model.internal.Permissions;
import ome.system.Login;
import ome.system.OmeroContext;
import ome.system.Principal;
import ome.system.Server;
import omeis.providers.re.RenderingEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceFactory {
    protected OmeroContext ctx;

    @Deprecated
    public OmeroContext getContext() {
        return this.ctx;
    }

    public ServiceFactory() {
        if (this.getDefaultContext() != null) {
            this.ctx = OmeroContext.getInstance(this.getDefaultContext());
        }
    }

    public ServiceFactory(Login login) {
        this.ctx = OmeroContext.getClientContext(login.asProperties());
    }

    public ServiceFactory(Server server) {
        this.ctx = OmeroContext.getClientContext(server.asProperties());
    }

    public ServiceFactory(Server server, Login login) {
        Properties s = server.asProperties();
        Properties l = login.asProperties();
        s.putAll((Map<?, ?>)l);
        this.ctx = OmeroContext.getClientContext(s);
    }

    public ServiceFactory(Properties properties) {
        this.ctx = OmeroContext.getClientContext(properties);
    }

    public ServiceFactory(OmeroContext context) {
        this.ctx = context;
    }

    public ServiceFactory(String contextName) {
        this.ctx = OmeroContext.getInstance(contextName);
    }

    public void setUmask(Permissions mask) {
        if (!this.ctx.containsBean("principal")) {
            throw new UnsupportedOperationException("The context for this ServiceFactory does not contain a Principal on which the umask can be set.");
        }
        Principal p = (Principal)this.ctx.getBean("principal");
        p.setUmask(mask);
    }

    public IAdmin getAdminService() {
        return this.getServiceByClass(IAdmin.class);
    }

    public IAnalysis getAnalysisService() {
        return this.getServiceByClass(IAnalysis.class);
    }

    public IConfig getConfigService() {
        return this.getServiceByClass(IConfig.class);
    }

    public ILdap getLdapService() {
        return this.getServiceByClass(ILdap.class);
    }

    public IPixels getPixelsService() {
        return this.getServiceByClass(IPixels.class);
    }

    public IPojos getPojosService() {
        return this.getServiceByClass(IPojos.class);
    }

    public IQuery getQueryService() {
        return this.getServiceByClass(IQuery.class);
    }

    public ITypes getTypesService() {
        return this.getServiceByClass(ITypes.class);
    }

    public IUpdate getUpdateService() {
        return this.getServiceByClass(IUpdate.class);
    }

    public IRenderingSettings getRenderingSettingsService() {
        return this.getServiceByClass(IRenderingSettings.class);
    }

    public IRepositoryInfo getRepositoryInfoService() {
        return this.getServiceByClass(IRepositoryInfo.class);
    }

    public JobHandle createJobHandle() {
        return this.getServiceByClass(JobHandle.class);
    }

    public RawPixelsStore createRawPixelsStore() {
        return this.getServiceByClass(RawPixelsStore.class);
    }

    public RawFileStore createRawFileStore() {
        return this.getServiceByClass(RawFileStore.class);
    }

    public RenderingEngine createRenderingEngine() {
        return this.getServiceByClass(RenderingEngine.class);
    }

    public ThumbnailStore createThumbnailService() {
        return this.getServiceByClass(ThumbnailStore.class);
    }

    public <T extends ServiceInterface> T getServiceByClass(Class<T> klass) {
        return (T)((ServiceInterface)klass.cast(this.ctx.getBean(this.getPrefix() + klass.getName())));
    }

    protected String getPrefix() {
        return "managed:";
    }

    protected String getDefaultContext() {
        return "ome.client";
    }
}

