/*
 * Decompiled with CFR 0.152.
 */
package ome.parameters;

import java.io.Serializable;
import ome.conditions.ValidationException;

public class Page
implements Serializable {
    private final int m_offset;
    private final int m_limit;
    private static final long serialVersionUID = 1135303821179948L;

    public Page(int offset, int limit) {
        this.validate(offset, limit);
        this.m_offset = offset;
        this.m_limit = limit;
    }

    public int offset() {
        return this.m_offset;
    }

    public int limit() {
        return this.m_limit;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Page)) {
            return false;
        }
        Page p = (Page)obj;
        if (this == p) {
            return true;
        }
        if (p.m_offset != this.m_offset) {
            return false;
        }
        return p.m_limit == this.m_limit;
    }

    public int hashCode() {
        int result = 11;
        result = 17 * result + this.m_offset;
        result = 19 * result + this.m_limit;
        return result;
    }

    private void validate(int offset, int limit) {
        if (offset < 0) {
            throw new ValidationException("Offset cannot be less than zero.");
        }
        if (limit < 0) {
            throw new ValidationException("Limit cannot be less than zero.");
        }
    }
}

