/*
 * Decompiled with CFR 0.152.
 */
package ome.model.jobs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.model.jobs.JobStatus;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;

public abstract class Job
implements IMutable,
IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private String username;
    private String groupname;
    private String type;
    private String message;
    private JobStatus status;
    private Timestamp submitted;
    private Timestamp scheduledFor;
    private Timestamp started;
    private Timestamp finished;
    public static final String OWNER_FILTER = "job_owner_filter";
    public static final String GROUP_FILTER = "job_group_filter";
    public static final String EVENT_FILTER = "job_event_filter";
    public static final String PERMS_FILTER = "job_perms_filter";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "Job_id";
    public static final String DETAILS = "Job_details";
    public static final String VERSION = "Job_version";
    public static final String USERNAME = "Job_username";
    public static final String GROUPNAME = "Job_groupname";
    public static final String TYPE = "Job_type";
    public static final String MESSAGE = "Job_message";
    public static final String STATUS = "Job_status";
    public static final String SUBMITTED = "Job_submitted";
    public static final String SCHEDULEDFOR = "Job_scheduledFor";
    public static final String STARTED = "Job_started";
    public static final String FINISHED = "Job_finished";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public Job() {
    }

    public Job(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public Job(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUsername() {
        try {
            this.preGetter(USERNAME);
            String string = this.username;
            return string;
        }
        finally {
            this.postGetter(USERNAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsername(String username) {
        try {
            this.preSetter(USERNAME, username);
            this.username = username;
        }
        finally {
            this.postSetter(USERNAME, username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroupname() {
        try {
            this.preGetter(GROUPNAME);
            String string = this.groupname;
            return string;
        }
        finally {
            this.postGetter(GROUPNAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupname(String groupname) {
        try {
            this.preSetter(GROUPNAME, groupname);
            this.groupname = groupname;
        }
        finally {
            this.postSetter(GROUPNAME, groupname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getType() {
        try {
            this.preGetter(TYPE);
            String string = this.type;
            return string;
        }
        finally {
            this.postGetter(TYPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(String type) {
        try {
            this.preSetter(TYPE, type);
            this.type = type;
        }
        finally {
            this.postSetter(TYPE, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage() {
        try {
            this.preGetter(MESSAGE);
            String string = this.message;
            return string;
        }
        finally {
            this.postGetter(MESSAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessage(String message) {
        try {
            this.preSetter(MESSAGE, message);
            this.message = message;
        }
        finally {
            this.postSetter(MESSAGE, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobStatus getStatus() {
        try {
            this.preGetter(STATUS);
            JobStatus jobStatus = this.status;
            return jobStatus;
        }
        finally {
            this.postGetter(STATUS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(JobStatus status) {
        try {
            this.preSetter(STATUS, status);
            this.status = status;
        }
        finally {
            this.postSetter(STATUS, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getSubmitted() {
        try {
            this.preGetter(SUBMITTED);
            Timestamp timestamp = this.submitted;
            return timestamp;
        }
        finally {
            this.postGetter(SUBMITTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubmitted(Timestamp submitted) {
        try {
            this.preSetter(SUBMITTED, submitted);
            this.submitted = submitted;
        }
        finally {
            this.postSetter(SUBMITTED, submitted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getScheduledFor() {
        try {
            this.preGetter(SCHEDULEDFOR);
            Timestamp timestamp = this.scheduledFor;
            return timestamp;
        }
        finally {
            this.postGetter(SCHEDULEDFOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScheduledFor(Timestamp scheduledFor) {
        try {
            this.preSetter(SCHEDULEDFOR, scheduledFor);
            this.scheduledFor = scheduledFor;
        }
        finally {
            this.postSetter(SCHEDULEDFOR, scheduledFor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getStarted() {
        try {
            this.preGetter(STARTED);
            Timestamp timestamp = this.started;
            return timestamp;
        }
        finally {
            this.postGetter(STARTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStarted(Timestamp started) {
        try {
            this.preSetter(STARTED, started);
            this.started = started;
        }
        finally {
            this.postSetter(STARTED, started);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getFinished() {
        try {
            this.preGetter(FINISHED);
            Timestamp timestamp = this.finished;
            return timestamp;
        }
        finally {
            this.postGetter(FINISHED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFinished(Timestamp finished) {
        try {
            this.preSetter(FINISHED, finished);
            this.finished = finished;
        }
        finally {
            this.postSetter(FINISHED, finished);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public boolean acceptFilter(Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.username = (String)__filter.filter(USERNAME, this.username);
        this.groupname = (String)__filter.filter(GROUPNAME, this.groupname);
        this.type = (String)__filter.filter(TYPE, this.type);
        this.message = (String)__filter.filter(MESSAGE, this.message);
        this.status = (JobStatus)__filter.filter(STATUS, this.status);
        this.submitted = (Timestamp)__filter.filter(SUBMITTED, this.submitted);
        this.scheduledFor = (Timestamp)__filter.filter(SCHEDULEDFOR, this.scheduledFor);
        this.started = (Timestamp)__filter.filter(STARTED, this.started);
        this.finished = (Timestamp)__filter.filter(FINISHED, this.finished);
        return true;
    }

    public String toString() {
        return "Job" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(USERNAME)) {
            return this.getUsername();
        }
        if (field.equals(GROUPNAME)) {
            return this.getGroupname();
        }
        if (field.equals(TYPE)) {
            return this.getType();
        }
        if (field.equals(MESSAGE)) {
            return this.getMessage();
        }
        if (field.equals(STATUS)) {
            return this.getStatus();
        }
        if (field.equals(SUBMITTED)) {
            return this.getSubmitted();
        }
        if (field.equals(SCHEDULEDFOR)) {
            return this.getScheduledFor();
        }
        if (field.equals(STARTED)) {
            return this.getStarted();
        }
        if (field.equals(FINISHED)) {
            return this.getFinished();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(USERNAME)) {
            this.setUsername((String)value);
        } else if (field.equals(GROUPNAME)) {
            this.setGroupname((String)value);
        } else if (field.equals(TYPE)) {
            this.setType((String)value);
        } else if (field.equals(MESSAGE)) {
            this.setMessage((String)value);
        } else if (field.equals(STATUS)) {
            this.setStatus((JobStatus)value);
        } else if (field.equals(SUBMITTED)) {
            this.setSubmitted((Timestamp)value);
        } else if (field.equals(SCHEDULEDFOR)) {
            this.setScheduledFor((Timestamp)value);
        } else if (field.equals(STARTED)) {
            this.setStarted((Timestamp)value);
        } else if (field.equals(FINISHED)) {
            this.setFinished((Timestamp)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.version = null;
        this.username = null;
        this.groupname = null;
        this.type = null;
        this.message = null;
        this.status = null;
        this.submitted = null;
        this.scheduledFor = null;
        this.started = null;
        this.finished = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(USERNAME);
        raw.add(GROUPNAME);
        raw.add(TYPE);
        raw.add(MESSAGE);
        raw.add(STATUS);
        raw.add(SUBMITTED);
        raw.add(SCHEDULEDFOR);
        raw.add(STARTED);
        raw.add(FINISHED);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

