/*
 * Decompiled with CFR 0.152.
 */
package ome.model.jobs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.core.OriginalFile;
import ome.model.jobs.Job;
import ome.model.jobs.JobOriginalFileLink;
import ome.util.CBlock;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class ImportJob
extends Job
implements IMutable,
IObject,
Serializable {
    private String imageName;
    private String imageDescription;
    private Set originalFileLinks = new HashSet(0);
    public static final String OWNER_FILTER = "importjob_owner_filter";
    public static final String GROUP_FILTER = "importjob_group_filter";
    public static final String EVENT_FILTER = "importjob_event_filter";
    public static final String PERMS_FILTER = "importjob_perms_filter";
    public static final String OWNER_FILTER_ORIGINALFILELINKS = "importjob_owner_filter_ORIGINALFILELINKS";
    public static final String GROUP_FILTER_ORIGINALFILELINKS = "importjob_group_filter_ORIGINALFILELINKS";
    public static final String EVENT_FILTER_ORIGINALFILELINKS = "importjob_event_filter_ORIGINALFILELINKS";
    public static final String PERMS_FILTER_ORIGINALFILELINKS = "importjob_perms_filter_ORIGINALFILELINKS";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String IMAGENAME = "ImportJob_imageName";
    public static final String IMAGEDESCRIPTION = "ImportJob_imageDescription";
    public static final String ORIGINALFILELINKS = "ImportJob_originalFileLinks";
    public static final Set FIELDS;

    public ImportJob() {
    }

    public ImportJob(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public ImportJob(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImageName() {
        try {
            this.preGetter(IMAGENAME);
            String string = this.imageName;
            return string;
        }
        finally {
            this.postGetter(IMAGENAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImageName(String imageName) {
        try {
            this.preSetter(IMAGENAME, imageName);
            this.imageName = imageName;
        }
        finally {
            this.postSetter(IMAGENAME, imageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImageDescription() {
        try {
            this.preGetter(IMAGEDESCRIPTION);
            String string = this.imageDescription;
            return string;
        }
        finally {
            this.postGetter(IMAGEDESCRIPTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImageDescription(String imageDescription) {
        try {
            this.preSetter(IMAGEDESCRIPTION, imageDescription);
            this.imageDescription = imageDescription;
        }
        finally {
            this.postSetter(IMAGEDESCRIPTION, imageDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getOriginalFileLinks() {
        try {
            this.preGetter(ORIGINALFILELINKS);
            Set set = this.originalFileLinks;
            return set;
        }
        finally {
            this.postGetter(ORIGINALFILELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOriginalFileLinks(Set originalFileLinks) {
        try {
            this.preSetter(ORIGINALFILELINKS, originalFileLinks);
            this.originalFileLinks = originalFileLinks;
        }
        finally {
            this.postSetter(ORIGINALFILELINKS, originalFileLinks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfOriginalFileLinks() {
        try {
            this.preGetter(ORIGINALFILELINKS);
            int n = this.originalFileLinks == null ? -1 : this.originalFileLinks.size();
            return n;
        }
        finally {
            this.postGetter(ORIGINALFILELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateOriginalFileLinks() {
        try {
            this.preGetter(ORIGINALFILELINKS);
            if (this.getOriginalFileLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getOriginalFileLinks().iterator();
            return iterator;
        }
        finally {
            this.postGetter(ORIGINALFILELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectOriginalFileLinks(CBlock block) {
        try {
            this.preGetter(ORIGINALFILELINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateOriginalFileLinks();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(ORIGINALFILELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkOriginalFile(OriginalFile addition) {
        try {
            this.preSetter(ORIGINALFILELINKS, addition);
            JobOriginalFileLink link = new JobOriginalFileLink();
            link.link(this, addition);
            this.addJobOriginalFileLink(link, true);
        }
        finally {
            this.postSetter(ORIGINALFILELINKS, addition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobOriginalFileLink(JobOriginalFileLink link, boolean bothSides) {
        try {
            this.preSetter(ORIGINALFILELINKS, link);
            if (this.getOriginalFileLinks() == null) {
                this.throwNullCollectionException("OriginalFileLinks");
            }
            this.getOriginalFileLinks().add(link);
        }
        finally {
            this.postSetter(ORIGINALFILELINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator linkedOriginalFileIterator() {
        try {
            this.preGetter(ORIGINALFILELINKS);
            if (this.getOriginalFileLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            final Iterator it = this.getOriginalFileLinks().iterator();
            Iterator iterator = new Iterator(){

                public boolean hasNext() {
                    return it == null ? false : it.hasNext();
                }

                public Object next() {
                    if (it == null) {
                        throw new NoSuchElementException("originalFileLinks is null; no elements.");
                    }
                    JobOriginalFileLink link = (JobOriginalFileLink)it.next();
                    return link.child();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot call remove on this iterator.");
                }
            };
            return iterator;
        }
        finally {
            this.postGetter(ORIGINALFILELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set findJobOriginalFileLink(OriginalFile target) {
        try {
            this.preGetter(ORIGINALFILELINKS);
            Iterator it = this.iterateOriginalFileLinks();
            HashSet<JobOriginalFileLink> result = new HashSet<JobOriginalFileLink>();
            while (it.hasNext()) {
                JobOriginalFileLink link = (JobOriginalFileLink)it.next();
                if (link.child() != target) continue;
                result.add(link);
            }
            HashSet<JobOriginalFileLink> hashSet = result;
            return hashSet;
        }
        finally {
            this.postGetter(ORIGINALFILELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List linkedOriginalFileList() {
        try {
            this.preGetter(ORIGINALFILELINKS);
            Iterator it = this.linkedOriginalFileIterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            this.postGetter(ORIGINALFILELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List eachLinkedOriginalFile(CBlock block) {
        try {
            this.preGetter(ORIGINALFILELINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.linkedOriginalFileIterator();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(ORIGINALFILELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkOriginalFile(OriginalFile removal) {
        try {
            this.preSetter(ORIGINALFILELINKS, removal);
            Set toRemove = this.findJobOriginalFileLink(removal);
            Iterator it = toRemove.iterator();
            while (it.hasNext()) {
                this.removeJobOriginalFileLink((JobOriginalFileLink)it.next(), true);
            }
        }
        finally {
            this.postSetter(ORIGINALFILELINKS, removal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobOriginalFileLink(JobOriginalFileLink link, boolean bothSides) {
        try {
            this.preSetter(ORIGINALFILELINKS, link);
            if (this.getOriginalFileLinks() == null) {
                this.throwNullCollectionException("OriginalFileLinks");
            }
            this.getOriginalFileLinks().remove(link);
        }
        finally {
            this.postSetter(ORIGINALFILELINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOriginalFileLinks() {
        try {
            this.preSetter(ORIGINALFILELINKS, null);
            ArrayList list = new ArrayList(this.getOriginalFileLinks());
            for (Object object : list) {
                JobOriginalFileLink link = (JobOriginalFileLink)object;
                this.removeJobOriginalFileLink(link, true);
            }
        }
        finally {
            this.postSetter(ORIGINALFILELINKS, null);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new ImportJob();
    }

    public boolean acceptFilter(Filter __filter) {
        this.imageName = (String)__filter.filter(IMAGENAME, this.imageName);
        this.imageDescription = (String)__filter.filter(IMAGEDESCRIPTION, this.imageDescription);
        this.originalFileLinks = (Set)__filter.filter(ORIGINALFILELINKS, this.originalFileLinks);
        return super.acceptFilter(__filter);
    }

    public String toString() {
        return "ImportJob" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(IMAGENAME)) {
            return this.getImageName();
        }
        if (field.equals(IMAGEDESCRIPTION)) {
            return this.getImageDescription();
        }
        if (field.equals(ORIGINALFILELINKS)) {
            return this.getOriginalFileLinks();
        }
        return super.retrieve(field);
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(IMAGENAME)) {
            this.setImageName((String)value);
        } else if (field.equals(IMAGEDESCRIPTION)) {
            this.setImageDescription((String)value);
        } else if (field.equals(ORIGINALFILELINKS)) {
            this.setOriginalFileLinks((Set)value);
        } else {
            super.putAt(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.imageName = null;
        this.imageDescription = null;
        this.originalFileLinks = null;
        super.unload();
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(IMAGENAME);
        raw.addAll(Job.FIELDS);
        raw.add(IMAGEDESCRIPTION);
        raw.addAll(Job.FIELDS);
        raw.add(ORIGINALFILELINKS);
        raw.addAll(Job.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

