/*
 * Decompiled with CFR 0.152.
 */
package ome.model.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ome.model.IDetails;
import ome.model.IObject;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.Filter;
import ome.util.Filterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Details
implements IDetails,
Filterable,
Serializable {
    private static final long serialVersionUID = 1176546684904748976L;
    public static final String CONTEXT = "Details_context";
    public static final String PERMISSIONS = "Details_permissions";
    public static final String CREATIONEVENT = "Details_creationEvent";
    public static final String UPDATEEVENT = "Details_updateEvent";
    public static final String OWNER = "Details_owner";
    public static final String GROUP = "Details_group";
    public static final String EXTERNALINFO = "Details_externalInfo";
    IObject _context;
    Permissions _perms;
    Event _creation;
    Event _update;
    Experimenter _owner;
    ExperimenterGroup _group;
    ExternalInfo _externalInfo;
    Set<String> _filteredCollections;
    Map _counts;
    protected Map _dynamicFields;

    public Details() {
    }

    public Details(Details copy) {
        this.setContext(copy.getContext());
        this.setPermissions(new Permissions().revokeAll(copy.getPermissions()));
        this.setCreationEvent(copy.getCreationEvent());
        this.setUpdateEvent(copy.getUpdateEvent());
        this.setOwner(copy.getOwner());
        this.setGroup(copy.getGroup());
        this.setExternalInfo(copy.getExternalInfo());
        this._filteredCollections = copy.filteredSet();
        this._counts = copy.getCounts() == null ? null : new HashMap(copy.getCounts());
    }

    public Details shallowCopy() {
        Details newDetails = new Details();
        newDetails.setOwner(this.getOwner() == null ? null : new Experimenter(this.getOwner().getId(), false));
        newDetails.setGroup(this.getGroup() == null ? null : new ExperimenterGroup(this.getGroup().getId(), false));
        newDetails.setCreationEvent(this.getCreationEvent() == null ? null : new Event(this.getCreationEvent().getId(), false));
        newDetails.setUpdateEvent(this.getUpdateEvent() == null ? null : new Event(this.getUpdateEvent().getId(), false));
        newDetails.setPermissions(this.getPermissions() == null ? null : new Permissions().revokeAll(this.getPermissions()));
        newDetails.setExternalInfo(this.getExternalInfo() == null ? null : new ExternalInfo(this.getExternalInfo().getId(), false));
        newDetails._filteredCollections = this.filteredSet();
        newDetails.setCounts(this.getCounts() == null ? null : new HashMap(this.getCounts()));
        return newDetails;
    }

    public Details newInstance() {
        return new Details();
    }

    public void addFiltered(String collectionName) {
        if (this._filteredCollections == null) {
            this._filteredCollections = new HashSet<String>();
        }
        this._filteredCollections.add(collectionName);
    }

    public void addFiltered(Collection<String> collection) {
        if (this._filteredCollections == null) {
            this._filteredCollections = new HashSet<String>();
        }
        this._filteredCollections.addAll(collection);
    }

    public boolean isFiltered(String collectionName) {
        if (this._filteredCollections == null) {
            return false;
        }
        return this._filteredCollections.contains(collectionName);
    }

    public void clearFiltered() {
        this._filteredCollections = null;
    }

    public int filteredSize() {
        if (this._filteredCollections == null) {
            return 0;
        }
        return this._filteredCollections.size();
    }

    public Set<String> filteredSet() {
        if (this._filteredCollections == null) {
            return new HashSet<String>();
        }
        return new HashSet<String>(this._filteredCollections);
    }

    public IObject getContext() {
        return this._context;
    }

    public void setContext(IObject myContext) {
        this._context = myContext;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("Details:{");
        sb.append("user=");
        sb.append(this._owner == null ? null : this._owner.getId());
        sb.append(";group=");
        sb.append(this._group == null ? null : this._group.getId());
        sb.append(";perm=");
        sb.append(this._perms == null ? null : this._perms.toString());
        sb.append(";create=");
        sb.append(this._creation == null ? null : this._creation.getId());
        sb.append(";update=");
        sb.append(this._update == null ? null : this._update.getId());
        if (this._externalInfo != null) {
            sb.append(";external=" + this._externalInfo.getId());
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public Permissions getPermissions() {
        return this._perms;
    }

    @Override
    public Experimenter getOwner() {
        return this._owner;
    }

    @Override
    public Event getCreationEvent() {
        return this._creation;
    }

    public Event getUpdateEvent() {
        return this._update;
    }

    @Override
    public void setPermissions(Permissions perms) {
        this._perms = perms;
    }

    @Override
    public void setOwner(Experimenter exp) {
        this._owner = exp;
    }

    @Override
    public void setCreationEvent(Event e) {
        this._creation = e;
    }

    public void setUpdateEvent(Event e) {
        this._update = e;
    }

    public ExperimenterGroup getGroup() {
        return this._group;
    }

    public void setGroup(ExperimenterGroup _group) {
        this._group = _group;
    }

    public ExternalInfo getExternalInfo() {
        return this._externalInfo;
    }

    public void setExternalInfo(ExternalInfo info) {
        this._externalInfo = info;
    }

    public Map getCounts() {
        return this._counts;
    }

    public void setCounts(Map counts) {
        this._counts = counts;
    }

    @Override
    public boolean acceptFilter(Filter filter) {
        this.setOwner((Experimenter)filter.filter(OWNER, this.getOwner()));
        this.setGroup((ExperimenterGroup)filter.filter(GROUP, this.getGroup()));
        this.setPermissions((Permissions)filter.filter(PERMISSIONS, this.getPermissions()));
        this.setCreationEvent((Event)filter.filter(CREATIONEVENT, this.getCreationEvent()));
        this.setUpdateEvent((Event)filter.filter(UPDATEEVENT, this.getUpdateEvent()));
        this.setExternalInfo((ExternalInfo)filter.filter(EXTERNALINFO, this.getExternalInfo()));
        return true;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(OWNER)) {
            return this.getOwner();
        }
        if (field.equals(GROUP)) {
            return this.getGroup();
        }
        if (field.equals(PERMISSIONS)) {
            return this.getPermissions();
        }
        if (field.equals(CREATIONEVENT)) {
            return this.getCreationEvent();
        }
        if (field.equals(UPDATEEVENT)) {
            return this.getUpdateEvent();
        }
        if (field.equals(EXTERNALINFO)) {
            return this.getExternalInfo();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(OWNER)) {
            this.setOwner((Experimenter)value);
        } else if (field.equals(GROUP)) {
            this.setGroup((ExperimenterGroup)value);
        } else if (field.equals(PERMISSIONS)) {
            this.setPermissions((Permissions)value);
        } else if (field.equals(CREATIONEVENT)) {
            this.setCreationEvent((Event)value);
        } else if (field.equals(UPDATEEVENT)) {
            this.setUpdateEvent((Event)value);
        } else if (field.equals(EXTERNALINFO)) {
            this.setExternalInfo((ExternalInfo)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }
}

