/*
 * Decompiled with CFR 0.152.
 */
package ome.model.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.core.Image;
import ome.model.core.OriginalFile;
import ome.model.core.PixelsDimensions;
import ome.model.core.PixelsOriginalFileMap;
import ome.model.core.PlaneInfo;
import ome.model.display.RenderingDef;
import ome.model.display.Thumbnail;
import ome.model.enums.DimensionOrder;
import ome.model.enums.PixelsType;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.util.CBlock;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class Pixels
implements IMutable,
IObject,
Serializable {
    private Boolean defaultPixels;
    private Image image;
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private Pixels relatedTo;
    private PixelsType pixelsType;
    private Integer sizeX;
    private Integer sizeY;
    private Integer sizeZ;
    private Integer sizeC;
    private Integer sizeT;
    private String sha1;
    private DimensionOrder dimensionOrder;
    private String methodology;
    private Set planeInfo = new HashSet(0);
    private PixelsDimensions pixelsDimensions;
    private Set pixelsFileMaps = new HashSet(0);
    private List channels = new ArrayList(0);
    private Set settings = new HashSet(0);
    private Set thumbnails = new HashSet(0);
    public static final String OWNER_FILTER = "pixels_owner_filter";
    public static final String GROUP_FILTER = "pixels_group_filter";
    public static final String EVENT_FILTER = "pixels_event_filter";
    public static final String PERMS_FILTER = "pixels_perms_filter";
    public static final String OWNER_FILTER_PLANEINFO = "pixels_owner_filter_PLANEINFO";
    public static final String GROUP_FILTER_PLANEINFO = "pixels_group_filter_PLANEINFO";
    public static final String EVENT_FILTER_PLANEINFO = "pixels_event_filter_PLANEINFO";
    public static final String PERMS_FILTER_PLANEINFO = "pixels_perms_filter_PLANEINFO";
    public static final String OWNER_FILTER_PIXELSFILEMAPS = "pixels_owner_filter_PIXELSFILEMAPS";
    public static final String GROUP_FILTER_PIXELSFILEMAPS = "pixels_group_filter_PIXELSFILEMAPS";
    public static final String EVENT_FILTER_PIXELSFILEMAPS = "pixels_event_filter_PIXELSFILEMAPS";
    public static final String PERMS_FILTER_PIXELSFILEMAPS = "pixels_perms_filter_PIXELSFILEMAPS";
    public static final String OWNER_FILTER_CHANNELS = "pixels_owner_filter_CHANNELS";
    public static final String GROUP_FILTER_CHANNELS = "pixels_group_filter_CHANNELS";
    public static final String EVENT_FILTER_CHANNELS = "pixels_event_filter_CHANNELS";
    public static final String PERMS_FILTER_CHANNELS = "pixels_perms_filter_CHANNELS";
    public static final String OWNER_FILTER_SETTINGS = "pixels_owner_filter_SETTINGS";
    public static final String GROUP_FILTER_SETTINGS = "pixels_group_filter_SETTINGS";
    public static final String EVENT_FILTER_SETTINGS = "pixels_event_filter_SETTINGS";
    public static final String PERMS_FILTER_SETTINGS = "pixels_perms_filter_SETTINGS";
    public static final String OWNER_FILTER_THUMBNAILS = "pixels_owner_filter_THUMBNAILS";
    public static final String GROUP_FILTER_THUMBNAILS = "pixels_group_filter_THUMBNAILS";
    public static final String EVENT_FILTER_THUMBNAILS = "pixels_event_filter_THUMBNAILS";
    public static final String PERMS_FILTER_THUMBNAILS = "pixels_perms_filter_THUMBNAILS";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String DEFAULTPIXELS = "Pixels_defaultPixels";
    public static final String IMAGE = "Pixels_image";
    public static final String ID = "Pixels_id";
    public static final String DETAILS = "Pixels_details";
    public static final String VERSION = "Pixels_version";
    public static final String RELATEDTO = "Pixels_relatedTo";
    public static final String PIXELSTYPE = "Pixels_pixelsType";
    public static final String SIZEX = "Pixels_sizeX";
    public static final String SIZEY = "Pixels_sizeY";
    public static final String SIZEZ = "Pixels_sizeZ";
    public static final String SIZEC = "Pixels_sizeC";
    public static final String SIZET = "Pixels_sizeT";
    public static final String SHA1 = "Pixels_sha1";
    public static final String DIMENSIONORDER = "Pixels_dimensionOrder";
    public static final String METHODOLOGY = "Pixels_methodology";
    public static final String PLANEINFO = "Pixels_planeInfo";
    public static final String PIXELSDIMENSIONS = "Pixels_pixelsDimensions";
    public static final String PIXELSFILEMAPS = "Pixels_pixelsFileMaps";
    public static final String CHANNELS = "Pixels_channels";
    public static final String SETTINGS = "Pixels_settings";
    public static final String THUMBNAILS = "Pixels_thumbnails";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public Pixels() {
    }

    public Pixels(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public Pixels(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getDefaultPixels() {
        try {
            this.preGetter(DEFAULTPIXELS);
            Boolean bl = this.defaultPixels;
            return bl;
        }
        finally {
            this.postGetter(DEFAULTPIXELS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultPixels(Boolean defaultPixels) {
        try {
            this.preSetter(DEFAULTPIXELS, defaultPixels);
            this.defaultPixels = defaultPixels;
        }
        finally {
            this.postSetter(DEFAULTPIXELS, defaultPixels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage() {
        try {
            this.preGetter(IMAGE);
            Image image = this.image;
            return image;
        }
        finally {
            this.postGetter(IMAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(Image image) {
        try {
            this.preSetter(IMAGE, image);
            this.image = image;
        }
        finally {
            this.postSetter(IMAGE, image);
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pixels getRelatedTo() {
        try {
            this.preGetter(RELATEDTO);
            Pixels pixels = this.relatedTo;
            return pixels;
        }
        finally {
            this.postGetter(RELATEDTO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelatedTo(Pixels relatedTo) {
        try {
            this.preSetter(RELATEDTO, relatedTo);
            this.relatedTo = relatedTo;
        }
        finally {
            this.postSetter(RELATEDTO, relatedTo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PixelsType getPixelsType() {
        try {
            this.preGetter(PIXELSTYPE);
            PixelsType pixelsType = this.pixelsType;
            return pixelsType;
        }
        finally {
            this.postGetter(PIXELSTYPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPixelsType(PixelsType pixelsType) {
        try {
            this.preSetter(PIXELSTYPE, pixelsType);
            this.pixelsType = pixelsType;
        }
        finally {
            this.postSetter(PIXELSTYPE, pixelsType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getSizeX() {
        try {
            this.preGetter(SIZEX);
            Integer n = this.sizeX;
            return n;
        }
        finally {
            this.postGetter(SIZEX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSizeX(Integer sizeX) {
        try {
            this.preSetter(SIZEX, sizeX);
            this.sizeX = sizeX;
        }
        finally {
            this.postSetter(SIZEX, sizeX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getSizeY() {
        try {
            this.preGetter(SIZEY);
            Integer n = this.sizeY;
            return n;
        }
        finally {
            this.postGetter(SIZEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSizeY(Integer sizeY) {
        try {
            this.preSetter(SIZEY, sizeY);
            this.sizeY = sizeY;
        }
        finally {
            this.postSetter(SIZEY, sizeY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getSizeZ() {
        try {
            this.preGetter(SIZEZ);
            Integer n = this.sizeZ;
            return n;
        }
        finally {
            this.postGetter(SIZEZ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSizeZ(Integer sizeZ) {
        try {
            this.preSetter(SIZEZ, sizeZ);
            this.sizeZ = sizeZ;
        }
        finally {
            this.postSetter(SIZEZ, sizeZ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getSizeC() {
        try {
            this.preGetter(SIZEC);
            Integer n = this.sizeC;
            return n;
        }
        finally {
            this.postGetter(SIZEC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSizeC(Integer sizeC) {
        try {
            this.preSetter(SIZEC, sizeC);
            this.sizeC = sizeC;
        }
        finally {
            this.postSetter(SIZEC, sizeC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getSizeT() {
        try {
            this.preGetter(SIZET);
            Integer n = this.sizeT;
            return n;
        }
        finally {
            this.postGetter(SIZET);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSizeT(Integer sizeT) {
        try {
            this.preSetter(SIZET, sizeT);
            this.sizeT = sizeT;
        }
        finally {
            this.postSetter(SIZET, sizeT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSha1() {
        try {
            this.preGetter(SHA1);
            String string = this.sha1;
            return string;
        }
        finally {
            this.postGetter(SHA1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSha1(String sha1) {
        try {
            this.preSetter(SHA1, sha1);
            this.sha1 = sha1;
        }
        finally {
            this.postSetter(SHA1, sha1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DimensionOrder getDimensionOrder() {
        try {
            this.preGetter(DIMENSIONORDER);
            DimensionOrder dimensionOrder = this.dimensionOrder;
            return dimensionOrder;
        }
        finally {
            this.postGetter(DIMENSIONORDER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDimensionOrder(DimensionOrder dimensionOrder) {
        try {
            this.preSetter(DIMENSIONORDER, dimensionOrder);
            this.dimensionOrder = dimensionOrder;
        }
        finally {
            this.postSetter(DIMENSIONORDER, dimensionOrder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMethodology() {
        try {
            this.preGetter(METHODOLOGY);
            String string = this.methodology;
            return string;
        }
        finally {
            this.postGetter(METHODOLOGY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMethodology(String methodology) {
        try {
            this.preSetter(METHODOLOGY, methodology);
            this.methodology = methodology;
        }
        finally {
            this.postSetter(METHODOLOGY, methodology);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getPlaneInfo() {
        try {
            this.preGetter(PLANEINFO);
            Set set = this.planeInfo;
            return set;
        }
        finally {
            this.postGetter(PLANEINFO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPlaneInfo(Set planeInfo) {
        try {
            this.preSetter(PLANEINFO, planeInfo);
            this.planeInfo = planeInfo;
        }
        finally {
            this.postSetter(PLANEINFO, planeInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfPlaneInfo() {
        try {
            this.preGetter(PLANEINFO);
            int n = this.planeInfo == null ? -1 : this.planeInfo.size();
            return n;
        }
        finally {
            this.postGetter(PLANEINFO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iteratePlaneInfo() {
        try {
            this.preGetter(PLANEINFO);
            if (this.getPlaneInfo() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getPlaneInfo().iterator();
            return iterator;
        }
        finally {
            this.postGetter(PLANEINFO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectPlaneInfo(CBlock block) {
        try {
            this.preGetter(PLANEINFO);
            ArrayList result = new ArrayList();
            Iterator it = this.iteratePlaneInfo();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(PLANEINFO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlaneInfo(PlaneInfo target) {
        try {
            this.preSetter(PLANEINFO, target);
            if (this.getPlaneInfo() == null) {
                this.throwNullCollectionException("PlaneInfo");
            }
            this.getPlaneInfo().add(target);
            target.setPixels(this);
        }
        finally {
            this.postSetter(PLANEINFO, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlaneInfoSet(Set targets) {
        try {
            this.preSetter(PLANEINFO, targets);
            if (this.getPlaneInfo() == null) {
                this.throwNullCollectionException("PlaneInfo");
            }
            this.getPlaneInfo().addAll(targets);
            for (PlaneInfo target : targets) {
                target.setPixels(this);
            }
        }
        finally {
            this.postSetter(PLANEINFO, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlaneInfo(PlaneInfo target) {
        try {
            this.preSetter(PLANEINFO, target);
            if (this.getPlaneInfo() == null) {
                this.throwNullCollectionException("PlaneInfo");
            }
            this.getPlaneInfo().remove(target);
            target.setPixels(null);
        }
        finally {
            this.postSetter(PLANEINFO, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlaneInfoSet(Set targets) {
        try {
            this.preSetter(PLANEINFO, targets);
            if (this.getPlaneInfo() == null) {
                this.throwNullCollectionException("PlaneInfo");
            }
            this.getPlaneInfo().removeAll(targets);
            for (PlaneInfo target : targets) {
                target.setPixels(null);
            }
        }
        finally {
            this.postSetter(PLANEINFO, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPlaneInfo() {
        try {
            this.preSetter(PLANEINFO, null);
            if (this.getPlaneInfo() == null) {
                this.throwNullCollectionException("PlaneInfo");
            }
            this.getPlaneInfo().clear();
            Iterator it = this.iteratePlaneInfo();
            while (it.hasNext()) {
                PlaneInfo target = (PlaneInfo)it.next();
                target.setPixels(null);
            }
        }
        finally {
            this.postSetter(PLANEINFO, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PixelsDimensions getPixelsDimensions() {
        try {
            this.preGetter(PIXELSDIMENSIONS);
            PixelsDimensions pixelsDimensions = this.pixelsDimensions;
            return pixelsDimensions;
        }
        finally {
            this.postGetter(PIXELSDIMENSIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPixelsDimensions(PixelsDimensions pixelsDimensions) {
        try {
            this.preSetter(PIXELSDIMENSIONS, pixelsDimensions);
            this.pixelsDimensions = pixelsDimensions;
        }
        finally {
            this.postSetter(PIXELSDIMENSIONS, pixelsDimensions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getPixelsFileMaps() {
        try {
            this.preGetter(PIXELSFILEMAPS);
            Set set = this.pixelsFileMaps;
            return set;
        }
        finally {
            this.postGetter(PIXELSFILEMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPixelsFileMaps(Set pixelsFileMaps) {
        try {
            this.preSetter(PIXELSFILEMAPS, pixelsFileMaps);
            this.pixelsFileMaps = pixelsFileMaps;
        }
        finally {
            this.postSetter(PIXELSFILEMAPS, pixelsFileMaps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfPixelsFileMaps() {
        try {
            this.preGetter(PIXELSFILEMAPS);
            int n = this.pixelsFileMaps == null ? -1 : this.pixelsFileMaps.size();
            return n;
        }
        finally {
            this.postGetter(PIXELSFILEMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iteratePixelsFileMaps() {
        try {
            this.preGetter(PIXELSFILEMAPS);
            if (this.getPixelsFileMaps() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getPixelsFileMaps().iterator();
            return iterator;
        }
        finally {
            this.postGetter(PIXELSFILEMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectPixelsFileMaps(CBlock block) {
        try {
            this.preGetter(PIXELSFILEMAPS);
            ArrayList result = new ArrayList();
            Iterator it = this.iteratePixelsFileMaps();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(PIXELSFILEMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkOriginalFile(OriginalFile addition) {
        try {
            this.preSetter(PIXELSFILEMAPS, addition);
            PixelsOriginalFileMap link = new PixelsOriginalFileMap();
            link.link(addition, this);
            this.addPixelsOriginalFileMap(link, true);
        }
        finally {
            this.postSetter(PIXELSFILEMAPS, addition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPixelsOriginalFileMap(PixelsOriginalFileMap link, boolean bothSides) {
        try {
            this.preSetter(PIXELSFILEMAPS, link);
            if (this.getPixelsFileMaps() == null) {
                this.throwNullCollectionException("PixelsFileMaps");
            }
            this.getPixelsFileMaps().add(link);
            if (bothSides && link.parent().isLoaded()) {
                link.parent().addPixelsOriginalFileMap(link, false);
            }
        }
        finally {
            this.postSetter(PIXELSFILEMAPS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator linkedOriginalFileIterator() {
        try {
            this.preGetter(PIXELSFILEMAPS);
            if (this.getPixelsFileMaps() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            final Iterator it = this.getPixelsFileMaps().iterator();
            Iterator iterator = new Iterator(){

                public boolean hasNext() {
                    return it == null ? false : it.hasNext();
                }

                public Object next() {
                    if (it == null) {
                        throw new NoSuchElementException("pixelsFileMaps is null; no elements.");
                    }
                    PixelsOriginalFileMap link = (PixelsOriginalFileMap)it.next();
                    return link.parent();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot call remove on this iterator.");
                }
            };
            return iterator;
        }
        finally {
            this.postGetter(PIXELSFILEMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set findPixelsOriginalFileMap(OriginalFile target) {
        try {
            this.preGetter(PIXELSFILEMAPS);
            Iterator it = this.iteratePixelsFileMaps();
            HashSet<PixelsOriginalFileMap> result = new HashSet<PixelsOriginalFileMap>();
            while (it.hasNext()) {
                PixelsOriginalFileMap link = (PixelsOriginalFileMap)it.next();
                if (link.parent() != target) continue;
                result.add(link);
            }
            HashSet<PixelsOriginalFileMap> hashSet = result;
            return hashSet;
        }
        finally {
            this.postGetter(PIXELSFILEMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List linkedOriginalFileList() {
        try {
            this.preGetter(PIXELSFILEMAPS);
            Iterator it = this.linkedOriginalFileIterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            this.postGetter(PIXELSFILEMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List eachLinkedOriginalFile(CBlock block) {
        try {
            this.preGetter(PIXELSFILEMAPS);
            ArrayList result = new ArrayList();
            Iterator it = this.linkedOriginalFileIterator();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(PIXELSFILEMAPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkOriginalFile(OriginalFile removal) {
        try {
            this.preSetter(PIXELSFILEMAPS, removal);
            Set toRemove = this.findPixelsOriginalFileMap(removal);
            Iterator it = toRemove.iterator();
            while (it.hasNext()) {
                this.removePixelsOriginalFileMap((PixelsOriginalFileMap)it.next(), true);
            }
        }
        finally {
            this.postSetter(PIXELSFILEMAPS, removal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePixelsOriginalFileMap(PixelsOriginalFileMap link, boolean bothSides) {
        try {
            this.preSetter(PIXELSFILEMAPS, link);
            if (this.getPixelsFileMaps() == null) {
                this.throwNullCollectionException("PixelsFileMaps");
            }
            this.getPixelsFileMaps().remove(link);
            if (bothSides && link.parent().isLoaded()) {
                link.parent().removePixelsOriginalFileMap(link, false);
            }
        }
        finally {
            this.postSetter(PIXELSFILEMAPS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOriginalFileLinks() {
        try {
            this.preSetter(PIXELSFILEMAPS, null);
            ArrayList list = new ArrayList(this.getPixelsFileMaps());
            for (Object object : list) {
                PixelsOriginalFileMap link = (PixelsOriginalFileMap)object;
                this.removePixelsOriginalFileMap(link, true);
            }
        }
        finally {
            this.postSetter(PIXELSFILEMAPS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChannels() {
        try {
            this.preGetter(CHANNELS);
            List list = this.channels;
            return list;
        }
        finally {
            this.postGetter(CHANNELS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannels(List channels) {
        try {
            this.preSetter(CHANNELS, channels);
            this.channels = channels;
        }
        finally {
            this.postSetter(CHANNELS, channels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getSettings() {
        try {
            this.preGetter(SETTINGS);
            Set set = this.settings;
            return set;
        }
        finally {
            this.postGetter(SETTINGS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSettings(Set settings) {
        try {
            this.preSetter(SETTINGS, settings);
            this.settings = settings;
        }
        finally {
            this.postSetter(SETTINGS, settings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfSettings() {
        try {
            this.preGetter(SETTINGS);
            int n = this.settings == null ? -1 : this.settings.size();
            return n;
        }
        finally {
            this.postGetter(SETTINGS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateSettings() {
        try {
            this.preGetter(SETTINGS);
            if (this.getSettings() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getSettings().iterator();
            return iterator;
        }
        finally {
            this.postGetter(SETTINGS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectSettings(CBlock block) {
        try {
            this.preGetter(SETTINGS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateSettings();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(SETTINGS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderingDef(RenderingDef target) {
        try {
            this.preSetter(SETTINGS, target);
            if (this.getSettings() == null) {
                this.throwNullCollectionException("Settings");
            }
            this.getSettings().add(target);
            target.setPixels(this);
        }
        finally {
            this.postSetter(SETTINGS, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderingDefSet(Set targets) {
        try {
            this.preSetter(SETTINGS, targets);
            if (this.getSettings() == null) {
                this.throwNullCollectionException("Settings");
            }
            this.getSettings().addAll(targets);
            for (RenderingDef target : targets) {
                target.setPixels(this);
            }
        }
        finally {
            this.postSetter(SETTINGS, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRenderingDef(RenderingDef target) {
        try {
            this.preSetter(SETTINGS, target);
            if (this.getSettings() == null) {
                this.throwNullCollectionException("Settings");
            }
            this.getSettings().remove(target);
            target.setPixels(null);
        }
        finally {
            this.postSetter(SETTINGS, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRenderingDefSet(Set targets) {
        try {
            this.preSetter(SETTINGS, targets);
            if (this.getSettings() == null) {
                this.throwNullCollectionException("Settings");
            }
            this.getSettings().removeAll(targets);
            for (RenderingDef target : targets) {
                target.setPixels(null);
            }
        }
        finally {
            this.postSetter(SETTINGS, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSettings() {
        try {
            this.preSetter(SETTINGS, null);
            if (this.getSettings() == null) {
                this.throwNullCollectionException("Settings");
            }
            this.getSettings().clear();
            Iterator it = this.iterateSettings();
            while (it.hasNext()) {
                RenderingDef target = (RenderingDef)it.next();
                target.setPixels(null);
            }
        }
        finally {
            this.postSetter(SETTINGS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getThumbnails() {
        try {
            this.preGetter(THUMBNAILS);
            Set set = this.thumbnails;
            return set;
        }
        finally {
            this.postGetter(THUMBNAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setThumbnails(Set thumbnails) {
        try {
            this.preSetter(THUMBNAILS, thumbnails);
            this.thumbnails = thumbnails;
        }
        finally {
            this.postSetter(THUMBNAILS, thumbnails);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfThumbnails() {
        try {
            this.preGetter(THUMBNAILS);
            int n = this.thumbnails == null ? -1 : this.thumbnails.size();
            return n;
        }
        finally {
            this.postGetter(THUMBNAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateThumbnails() {
        try {
            this.preGetter(THUMBNAILS);
            if (this.getThumbnails() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getThumbnails().iterator();
            return iterator;
        }
        finally {
            this.postGetter(THUMBNAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectThumbnails(CBlock block) {
        try {
            this.preGetter(THUMBNAILS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateThumbnails();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(THUMBNAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThumbnail(Thumbnail target) {
        try {
            this.preSetter(THUMBNAILS, target);
            if (this.getThumbnails() == null) {
                this.throwNullCollectionException("Thumbnails");
            }
            this.getThumbnails().add(target);
            target.setPixels(this);
        }
        finally {
            this.postSetter(THUMBNAILS, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThumbnailSet(Set targets) {
        try {
            this.preSetter(THUMBNAILS, targets);
            if (this.getThumbnails() == null) {
                this.throwNullCollectionException("Thumbnails");
            }
            this.getThumbnails().addAll(targets);
            for (Thumbnail target : targets) {
                target.setPixels(this);
            }
        }
        finally {
            this.postSetter(THUMBNAILS, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThumbnail(Thumbnail target) {
        try {
            this.preSetter(THUMBNAILS, target);
            if (this.getThumbnails() == null) {
                this.throwNullCollectionException("Thumbnails");
            }
            this.getThumbnails().remove(target);
            target.setPixels(null);
        }
        finally {
            this.postSetter(THUMBNAILS, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThumbnailSet(Set targets) {
        try {
            this.preSetter(THUMBNAILS, targets);
            if (this.getThumbnails() == null) {
                this.throwNullCollectionException("Thumbnails");
            }
            this.getThumbnails().removeAll(targets);
            for (Thumbnail target : targets) {
                target.setPixels(null);
            }
        }
        finally {
            this.postSetter(THUMBNAILS, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearThumbnails() {
        try {
            this.preSetter(THUMBNAILS, null);
            if (this.getThumbnails() == null) {
                this.throwNullCollectionException("Thumbnails");
            }
            this.getThumbnails().clear();
            Iterator it = this.iterateThumbnails();
            while (it.hasNext()) {
                Thumbnail target = (Thumbnail)it.next();
                target.setPixels(null);
            }
        }
        finally {
            this.postSetter(THUMBNAILS, null);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new Pixels();
    }

    public boolean acceptFilter(Filter __filter) {
        this.defaultPixels = (Boolean)__filter.filter(DEFAULTPIXELS, this.defaultPixels);
        this.image = (Image)__filter.filter(IMAGE, this.image);
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.relatedTo = (Pixels)__filter.filter(RELATEDTO, this.relatedTo);
        this.pixelsType = (PixelsType)__filter.filter(PIXELSTYPE, this.pixelsType);
        this.sizeX = (Integer)__filter.filter(SIZEX, this.sizeX);
        this.sizeY = (Integer)__filter.filter(SIZEY, this.sizeY);
        this.sizeZ = (Integer)__filter.filter(SIZEZ, this.sizeZ);
        this.sizeC = (Integer)__filter.filter(SIZEC, this.sizeC);
        this.sizeT = (Integer)__filter.filter(SIZET, this.sizeT);
        this.sha1 = (String)__filter.filter(SHA1, this.sha1);
        this.dimensionOrder = (DimensionOrder)__filter.filter(DIMENSIONORDER, this.dimensionOrder);
        this.methodology = (String)__filter.filter(METHODOLOGY, this.methodology);
        this.planeInfo = (Set)__filter.filter(PLANEINFO, this.planeInfo);
        this.pixelsDimensions = (PixelsDimensions)__filter.filter(PIXELSDIMENSIONS, this.pixelsDimensions);
        this.pixelsFileMaps = (Set)__filter.filter(PIXELSFILEMAPS, this.pixelsFileMaps);
        this.channels = (List)__filter.filter(CHANNELS, this.channels);
        this.settings = (Set)__filter.filter(SETTINGS, this.settings);
        this.thumbnails = (Set)__filter.filter(THUMBNAILS, this.thumbnails);
        return true;
    }

    public String toString() {
        return "Pixels" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(DEFAULTPIXELS)) {
            return this.getDefaultPixels();
        }
        if (field.equals(IMAGE)) {
            return this.getImage();
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(RELATEDTO)) {
            return this.getRelatedTo();
        }
        if (field.equals(PIXELSTYPE)) {
            return this.getPixelsType();
        }
        if (field.equals(SIZEX)) {
            return this.getSizeX();
        }
        if (field.equals(SIZEY)) {
            return this.getSizeY();
        }
        if (field.equals(SIZEZ)) {
            return this.getSizeZ();
        }
        if (field.equals(SIZEC)) {
            return this.getSizeC();
        }
        if (field.equals(SIZET)) {
            return this.getSizeT();
        }
        if (field.equals(SHA1)) {
            return this.getSha1();
        }
        if (field.equals(DIMENSIONORDER)) {
            return this.getDimensionOrder();
        }
        if (field.equals(METHODOLOGY)) {
            return this.getMethodology();
        }
        if (field.equals(PLANEINFO)) {
            return this.getPlaneInfo();
        }
        if (field.equals(PIXELSDIMENSIONS)) {
            return this.getPixelsDimensions();
        }
        if (field.equals(PIXELSFILEMAPS)) {
            return this.getPixelsFileMaps();
        }
        if (field.equals(CHANNELS)) {
            return this.getChannels();
        }
        if (field.equals(SETTINGS)) {
            return this.getSettings();
        }
        if (field.equals(THUMBNAILS)) {
            return this.getThumbnails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(DEFAULTPIXELS)) {
            this.setDefaultPixels((Boolean)value);
        } else if (field.equals(IMAGE)) {
            this.setImage((Image)value);
        } else if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(RELATEDTO)) {
            this.setRelatedTo((Pixels)value);
        } else if (field.equals(PIXELSTYPE)) {
            this.setPixelsType((PixelsType)value);
        } else if (field.equals(SIZEX)) {
            this.setSizeX((Integer)value);
        } else if (field.equals(SIZEY)) {
            this.setSizeY((Integer)value);
        } else if (field.equals(SIZEZ)) {
            this.setSizeZ((Integer)value);
        } else if (field.equals(SIZEC)) {
            this.setSizeC((Integer)value);
        } else if (field.equals(SIZET)) {
            this.setSizeT((Integer)value);
        } else if (field.equals(SHA1)) {
            this.setSha1((String)value);
        } else if (field.equals(DIMENSIONORDER)) {
            this.setDimensionOrder((DimensionOrder)value);
        } else if (field.equals(METHODOLOGY)) {
            this.setMethodology((String)value);
        } else if (field.equals(PLANEINFO)) {
            this.setPlaneInfo((Set)value);
        } else if (field.equals(PIXELSDIMENSIONS)) {
            this.setPixelsDimensions((PixelsDimensions)value);
        } else if (field.equals(PIXELSFILEMAPS)) {
            this.setPixelsFileMaps((Set)value);
        } else if (field.equals(CHANNELS)) {
            this.setChannels((List)value);
        } else if (field.equals(SETTINGS)) {
            this.setSettings((Set)value);
        } else if (field.equals(THUMBNAILS)) {
            this.setThumbnails((Set)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.defaultPixels = null;
        this.image = null;
        this.details = null;
        this.version = null;
        this.relatedTo = null;
        this.pixelsType = null;
        this.sizeX = null;
        this.sizeY = null;
        this.sizeZ = null;
        this.sizeC = null;
        this.sizeT = null;
        this.sha1 = null;
        this.dimensionOrder = null;
        this.methodology = null;
        this.planeInfo = null;
        this.pixelsDimensions = null;
        this.pixelsFileMaps = null;
        this.channels = null;
        this.settings = null;
        this.thumbnails = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(DEFAULTPIXELS);
        raw.add(IMAGE);
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(RELATEDTO);
        raw.add(PIXELSTYPE);
        raw.add(SIZEX);
        raw.add(SIZEY);
        raw.add(SIZEZ);
        raw.add(SIZEC);
        raw.add(SIZET);
        raw.add(SHA1);
        raw.add(DIMENSIONORDER);
        raw.add(METHODOLOGY);
        raw.add(PLANEINFO);
        raw.add(PIXELSDIMENSIONS);
        raw.add(PIXELSFILEMAPS);
        raw.add(CHANNELS);
        raw.add(SETTINGS);
        raw.add(THUMBNAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

