/*
 * Decompiled with CFR 0.152.
 */
package ome.model.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.ImagingEnvironment;
import ome.model.acquisition.Instrument;
import ome.model.acquisition.ObjectiveSettings;
import ome.model.acquisition.StageLabel;
import ome.model.annotations.ImageAnnotation;
import ome.model.containers.Category;
import ome.model.containers.CategoryImageLink;
import ome.model.containers.Dataset;
import ome.model.containers.DatasetImageLink;
import ome.model.core.Pixels;
import ome.model.experiment.Experiment;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.util.CBlock;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class Image
implements IMutable,
IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private String name;
    private String description;
    private ImagingEnvironment condition;
    private ObjectiveSettings objectiveSettings;
    private Instrument setup;
    private StageLabel position;
    private Experiment context;
    private Set pixels = new HashSet(0);
    private Pixels defaultPixels;
    private Set categoryLinks = new HashSet(0);
    private Set datasetLinks = new HashSet(0);
    private Set annotations = new HashSet(0);
    public static final String OWNER_FILTER = "image_owner_filter";
    public static final String GROUP_FILTER = "image_group_filter";
    public static final String EVENT_FILTER = "image_event_filter";
    public static final String PERMS_FILTER = "image_perms_filter";
    public static final String OWNER_FILTER_PIXELS = "image_owner_filter_PIXELS";
    public static final String GROUP_FILTER_PIXELS = "image_group_filter_PIXELS";
    public static final String EVENT_FILTER_PIXELS = "image_event_filter_PIXELS";
    public static final String PERMS_FILTER_PIXELS = "image_perms_filter_PIXELS";
    public static final String OWNER_FILTER_DEFAULTPIXELS = "image_owner_filter_DEFAULTPIXELS";
    public static final String GROUP_FILTER_DEFAULTPIXELS = "image_group_filter_DEFAULTPIXELS";
    public static final String EVENT_FILTER_DEFAULTPIXELS = "image_event_filter_DEFAULTPIXELS";
    public static final String PERMS_FILTER_DEFAULTPIXELS = "image_perms_filter_DEFAULTPIXELS";
    public static final String OWNER_FILTER_CATEGORYLINKS = "image_owner_filter_CATEGORYLINKS";
    public static final String GROUP_FILTER_CATEGORYLINKS = "image_group_filter_CATEGORYLINKS";
    public static final String EVENT_FILTER_CATEGORYLINKS = "image_event_filter_CATEGORYLINKS";
    public static final String PERMS_FILTER_CATEGORYLINKS = "image_perms_filter_CATEGORYLINKS";
    public static final String OWNER_FILTER_DATASETLINKS = "image_owner_filter_DATASETLINKS";
    public static final String GROUP_FILTER_DATASETLINKS = "image_group_filter_DATASETLINKS";
    public static final String EVENT_FILTER_DATASETLINKS = "image_event_filter_DATASETLINKS";
    public static final String PERMS_FILTER_DATASETLINKS = "image_perms_filter_DATASETLINKS";
    public static final String OWNER_FILTER_ANNOTATIONS = "image_owner_filter_ANNOTATIONS";
    public static final String GROUP_FILTER_ANNOTATIONS = "image_group_filter_ANNOTATIONS";
    public static final String EVENT_FILTER_ANNOTATIONS = "image_event_filter_ANNOTATIONS";
    public static final String PERMS_FILTER_ANNOTATIONS = "image_perms_filter_ANNOTATIONS";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "Image_id";
    public static final String DETAILS = "Image_details";
    public static final String VERSION = "Image_version";
    public static final String NAME = "Image_name";
    public static final String DESCRIPTION = "Image_description";
    public static final String CONDITION = "Image_condition";
    public static final String OBJECTIVESETTINGS = "Image_objectiveSettings";
    public static final String SETUP = "Image_setup";
    public static final String POSITION = "Image_position";
    public static final String CONTEXT = "Image_context";
    public static final String PIXELS = "Image_pixels";
    public static final String DEFAULTPIXELS = "Image_defaultPixels";
    public static final String CATEGORYLINKS = "Image_categoryLinks";
    public static final String DATASETLINKS = "Image_datasetLinks";
    public static final String ANNOTATIONS = "Image_annotations";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public Image() {
    }

    public Image(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public Image(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        try {
            this.preGetter(NAME);
            String string = this.name;
            return string;
        }
        finally {
            this.postGetter(NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        try {
            this.preSetter(NAME, name);
            this.name = name;
        }
        finally {
            this.postSetter(NAME, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        try {
            this.preGetter(DESCRIPTION);
            String string = this.description;
            return string;
        }
        finally {
            this.postGetter(DESCRIPTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDescription(String description) {
        try {
            this.preSetter(DESCRIPTION, description);
            this.description = description;
        }
        finally {
            this.postSetter(DESCRIPTION, description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImagingEnvironment getCondition() {
        try {
            this.preGetter(CONDITION);
            ImagingEnvironment imagingEnvironment = this.condition;
            return imagingEnvironment;
        }
        finally {
            this.postGetter(CONDITION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCondition(ImagingEnvironment condition) {
        try {
            this.preSetter(CONDITION, condition);
            this.condition = condition;
        }
        finally {
            this.postSetter(CONDITION, condition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectiveSettings getObjectiveSettings() {
        try {
            this.preGetter(OBJECTIVESETTINGS);
            ObjectiveSettings objectiveSettings = this.objectiveSettings;
            return objectiveSettings;
        }
        finally {
            this.postGetter(OBJECTIVESETTINGS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectiveSettings(ObjectiveSettings objectiveSettings) {
        try {
            this.preSetter(OBJECTIVESETTINGS, objectiveSettings);
            this.objectiveSettings = objectiveSettings;
        }
        finally {
            this.postSetter(OBJECTIVESETTINGS, objectiveSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instrument getSetup() {
        try {
            this.preGetter(SETUP);
            Instrument instrument = this.setup;
            return instrument;
        }
        finally {
            this.postGetter(SETUP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSetup(Instrument setup) {
        try {
            this.preSetter(SETUP, setup);
            this.setup = setup;
        }
        finally {
            this.postSetter(SETUP, setup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StageLabel getPosition() {
        try {
            this.preGetter(POSITION);
            StageLabel stageLabel = this.position;
            return stageLabel;
        }
        finally {
            this.postGetter(POSITION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPosition(StageLabel position) {
        try {
            this.preSetter(POSITION, position);
            this.position = position;
        }
        finally {
            this.postSetter(POSITION, position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Experiment getContext() {
        try {
            this.preGetter(CONTEXT);
            Experiment experiment = this.context;
            return experiment;
        }
        finally {
            this.postGetter(CONTEXT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContext(Experiment context) {
        try {
            this.preSetter(CONTEXT, context);
            this.context = context;
        }
        finally {
            this.postSetter(CONTEXT, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getPixels() {
        try {
            this.preGetter(PIXELS);
            Set set = this.pixels;
            return set;
        }
        finally {
            this.postGetter(PIXELS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPixels(Set pixels) {
        try {
            this.preSetter(PIXELS, pixels);
            this.pixels = pixels;
        }
        finally {
            this.postSetter(PIXELS, pixels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfPixels() {
        try {
            this.preGetter(PIXELS);
            int n = this.pixels == null ? -1 : this.pixels.size();
            return n;
        }
        finally {
            this.postGetter(PIXELS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iteratePixels() {
        try {
            this.preGetter(PIXELS);
            if (this.getPixels() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getPixels().iterator();
            return iterator;
        }
        finally {
            this.postGetter(PIXELS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectPixels(CBlock block) {
        try {
            this.preGetter(PIXELS);
            ArrayList result = new ArrayList();
            Iterator it = this.iteratePixels();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(PIXELS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPixels(Pixels target) {
        try {
            this.preSetter(PIXELS, target);
            if (this.getPixels() == null) {
                this.throwNullCollectionException("Pixels");
            }
            this.getPixels().add(target);
            target.setImage(this);
        }
        finally {
            this.postSetter(PIXELS, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPixelsSet(Set targets) {
        try {
            this.preSetter(PIXELS, targets);
            if (this.getPixels() == null) {
                this.throwNullCollectionException("Pixels");
            }
            this.getPixels().addAll(targets);
            for (Pixels target : targets) {
                target.setImage(this);
            }
        }
        finally {
            this.postSetter(PIXELS, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePixels(Pixels target) {
        try {
            this.preSetter(PIXELS, target);
            if (this.getPixels() == null) {
                this.throwNullCollectionException("Pixels");
            }
            this.getPixels().remove(target);
            target.setImage(null);
        }
        finally {
            this.postSetter(PIXELS, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePixelsSet(Set targets) {
        try {
            this.preSetter(PIXELS, targets);
            if (this.getPixels() == null) {
                this.throwNullCollectionException("Pixels");
            }
            this.getPixels().removeAll(targets);
            for (Pixels target : targets) {
                target.setImage(null);
            }
        }
        finally {
            this.postSetter(PIXELS, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPixels() {
        try {
            this.preSetter(PIXELS, null);
            if (this.getPixels() == null) {
                this.throwNullCollectionException("Pixels");
            }
            this.getPixels().clear();
            Iterator it = this.iteratePixels();
            while (it.hasNext()) {
                Pixels target = (Pixels)it.next();
                target.setImage(null);
            }
        }
        finally {
            this.postSetter(PIXELS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pixels getDefaultPixels() {
        try {
            this.preGetter(DEFAULTPIXELS);
            Pixels pixels = this.defaultPixels;
            return pixels;
        }
        finally {
            this.postGetter(DEFAULTPIXELS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDefaultPixels(Pixels defaultPixels) {
        try {
            this.preSetter(DEFAULTPIXELS, defaultPixels);
            this.defaultPixels = defaultPixels;
        }
        finally {
            this.postSetter(DEFAULTPIXELS, defaultPixels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getCategoryLinks() {
        try {
            this.preGetter(CATEGORYLINKS);
            Set set = this.categoryLinks;
            return set;
        }
        finally {
            this.postGetter(CATEGORYLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCategoryLinks(Set categoryLinks) {
        try {
            this.preSetter(CATEGORYLINKS, categoryLinks);
            this.categoryLinks = categoryLinks;
        }
        finally {
            this.postSetter(CATEGORYLINKS, categoryLinks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfCategoryLinks() {
        try {
            this.preGetter(CATEGORYLINKS);
            int n = this.categoryLinks == null ? -1 : this.categoryLinks.size();
            return n;
        }
        finally {
            this.postGetter(CATEGORYLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateCategoryLinks() {
        try {
            this.preGetter(CATEGORYLINKS);
            if (this.getCategoryLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getCategoryLinks().iterator();
            return iterator;
        }
        finally {
            this.postGetter(CATEGORYLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectCategoryLinks(CBlock block) {
        try {
            this.preGetter(CATEGORYLINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateCategoryLinks();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(CATEGORYLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkCategory(Category addition) {
        try {
            this.preSetter(CATEGORYLINKS, addition);
            CategoryImageLink link = new CategoryImageLink();
            link.link(addition, this);
            this.addCategoryImageLink(link, true);
        }
        finally {
            this.postSetter(CATEGORYLINKS, addition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCategoryImageLink(CategoryImageLink link, boolean bothSides) {
        try {
            this.preSetter(CATEGORYLINKS, link);
            if (this.getCategoryLinks() == null) {
                this.throwNullCollectionException("CategoryLinks");
            }
            this.getCategoryLinks().add(link);
            if (bothSides && link.parent().isLoaded()) {
                link.parent().addCategoryImageLink(link, false);
            }
        }
        finally {
            this.postSetter(CATEGORYLINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator linkedCategoryIterator() {
        try {
            this.preGetter(CATEGORYLINKS);
            if (this.getCategoryLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            final Iterator it = this.getCategoryLinks().iterator();
            Iterator iterator = new Iterator(){

                public boolean hasNext() {
                    return it == null ? false : it.hasNext();
                }

                public Object next() {
                    if (it == null) {
                        throw new NoSuchElementException("categoryLinks is null; no elements.");
                    }
                    CategoryImageLink link = (CategoryImageLink)it.next();
                    return link.parent();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot call remove on this iterator.");
                }
            };
            return iterator;
        }
        finally {
            this.postGetter(CATEGORYLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set findCategoryImageLink(Category target) {
        try {
            this.preGetter(CATEGORYLINKS);
            Iterator it = this.iterateCategoryLinks();
            HashSet<CategoryImageLink> result = new HashSet<CategoryImageLink>();
            while (it.hasNext()) {
                CategoryImageLink link = (CategoryImageLink)it.next();
                if (link.parent() != target) continue;
                result.add(link);
            }
            HashSet<CategoryImageLink> hashSet = result;
            return hashSet;
        }
        finally {
            this.postGetter(CATEGORYLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List linkedCategoryList() {
        try {
            this.preGetter(CATEGORYLINKS);
            Iterator it = this.linkedCategoryIterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            this.postGetter(CATEGORYLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List eachLinkedCategory(CBlock block) {
        try {
            this.preGetter(CATEGORYLINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.linkedCategoryIterator();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(CATEGORYLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkCategory(Category removal) {
        try {
            this.preSetter(CATEGORYLINKS, removal);
            Set toRemove = this.findCategoryImageLink(removal);
            Iterator it = toRemove.iterator();
            while (it.hasNext()) {
                this.removeCategoryImageLink((CategoryImageLink)it.next(), true);
            }
        }
        finally {
            this.postSetter(CATEGORYLINKS, removal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCategoryImageLink(CategoryImageLink link, boolean bothSides) {
        try {
            this.preSetter(CATEGORYLINKS, link);
            if (this.getCategoryLinks() == null) {
                this.throwNullCollectionException("CategoryLinks");
            }
            this.getCategoryLinks().remove(link);
            if (bothSides && link.parent().isLoaded()) {
                link.parent().removeCategoryImageLink(link, false);
            }
        }
        finally {
            this.postSetter(CATEGORYLINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCategoryLinks() {
        try {
            this.preSetter(CATEGORYLINKS, null);
            ArrayList list = new ArrayList(this.getCategoryLinks());
            for (Object object : list) {
                CategoryImageLink link = (CategoryImageLink)object;
                this.removeCategoryImageLink(link, true);
            }
        }
        finally {
            this.postSetter(CATEGORYLINKS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getDatasetLinks() {
        try {
            this.preGetter(DATASETLINKS);
            Set set = this.datasetLinks;
            return set;
        }
        finally {
            this.postGetter(DATASETLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDatasetLinks(Set datasetLinks) {
        try {
            this.preSetter(DATASETLINKS, datasetLinks);
            this.datasetLinks = datasetLinks;
        }
        finally {
            this.postSetter(DATASETLINKS, datasetLinks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfDatasetLinks() {
        try {
            this.preGetter(DATASETLINKS);
            int n = this.datasetLinks == null ? -1 : this.datasetLinks.size();
            return n;
        }
        finally {
            this.postGetter(DATASETLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateDatasetLinks() {
        try {
            this.preGetter(DATASETLINKS);
            if (this.getDatasetLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getDatasetLinks().iterator();
            return iterator;
        }
        finally {
            this.postGetter(DATASETLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectDatasetLinks(CBlock block) {
        try {
            this.preGetter(DATASETLINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateDatasetLinks();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(DATASETLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkDataset(Dataset addition) {
        try {
            this.preSetter(DATASETLINKS, addition);
            DatasetImageLink link = new DatasetImageLink();
            link.link(addition, this);
            this.addDatasetImageLink(link, true);
        }
        finally {
            this.postSetter(DATASETLINKS, addition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDatasetImageLink(DatasetImageLink link, boolean bothSides) {
        try {
            this.preSetter(DATASETLINKS, link);
            if (this.getDatasetLinks() == null) {
                this.throwNullCollectionException("DatasetLinks");
            }
            this.getDatasetLinks().add(link);
            if (bothSides && link.parent().isLoaded()) {
                link.parent().addDatasetImageLink(link, false);
            }
        }
        finally {
            this.postSetter(DATASETLINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator linkedDatasetIterator() {
        try {
            this.preGetter(DATASETLINKS);
            if (this.getDatasetLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            final Iterator it = this.getDatasetLinks().iterator();
            Iterator iterator = new Iterator(){

                public boolean hasNext() {
                    return it == null ? false : it.hasNext();
                }

                public Object next() {
                    if (it == null) {
                        throw new NoSuchElementException("datasetLinks is null; no elements.");
                    }
                    DatasetImageLink link = (DatasetImageLink)it.next();
                    return link.parent();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot call remove on this iterator.");
                }
            };
            return iterator;
        }
        finally {
            this.postGetter(DATASETLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set findDatasetImageLink(Dataset target) {
        try {
            this.preGetter(DATASETLINKS);
            Iterator it = this.iterateDatasetLinks();
            HashSet<DatasetImageLink> result = new HashSet<DatasetImageLink>();
            while (it.hasNext()) {
                DatasetImageLink link = (DatasetImageLink)it.next();
                if (link.parent() != target) continue;
                result.add(link);
            }
            HashSet<DatasetImageLink> hashSet = result;
            return hashSet;
        }
        finally {
            this.postGetter(DATASETLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List linkedDatasetList() {
        try {
            this.preGetter(DATASETLINKS);
            Iterator it = this.linkedDatasetIterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            this.postGetter(DATASETLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List eachLinkedDataset(CBlock block) {
        try {
            this.preGetter(DATASETLINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.linkedDatasetIterator();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(DATASETLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkDataset(Dataset removal) {
        try {
            this.preSetter(DATASETLINKS, removal);
            Set toRemove = this.findDatasetImageLink(removal);
            Iterator it = toRemove.iterator();
            while (it.hasNext()) {
                this.removeDatasetImageLink((DatasetImageLink)it.next(), true);
            }
        }
        finally {
            this.postSetter(DATASETLINKS, removal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatasetImageLink(DatasetImageLink link, boolean bothSides) {
        try {
            this.preSetter(DATASETLINKS, link);
            if (this.getDatasetLinks() == null) {
                this.throwNullCollectionException("DatasetLinks");
            }
            this.getDatasetLinks().remove(link);
            if (bothSides && link.parent().isLoaded()) {
                link.parent().removeDatasetImageLink(link, false);
            }
        }
        finally {
            this.postSetter(DATASETLINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDatasetLinks() {
        try {
            this.preSetter(DATASETLINKS, null);
            ArrayList list = new ArrayList(this.getDatasetLinks());
            for (Object object : list) {
                DatasetImageLink link = (DatasetImageLink)object;
                this.removeDatasetImageLink(link, true);
            }
        }
        finally {
            this.postSetter(DATASETLINKS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getAnnotations() {
        try {
            this.preGetter(ANNOTATIONS);
            Set set = this.annotations;
            return set;
        }
        finally {
            this.postGetter(ANNOTATIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAnnotations(Set annotations) {
        try {
            this.preSetter(ANNOTATIONS, annotations);
            this.annotations = annotations;
        }
        finally {
            this.postSetter(ANNOTATIONS, annotations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfAnnotations() {
        try {
            this.preGetter(ANNOTATIONS);
            int n = this.annotations == null ? -1 : this.annotations.size();
            return n;
        }
        finally {
            this.postGetter(ANNOTATIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateAnnotations() {
        try {
            this.preGetter(ANNOTATIONS);
            if (this.getAnnotations() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getAnnotations().iterator();
            return iterator;
        }
        finally {
            this.postGetter(ANNOTATIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectAnnotations(CBlock block) {
        try {
            this.preGetter(ANNOTATIONS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateAnnotations();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(ANNOTATIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageAnnotation(ImageAnnotation target) {
        try {
            this.preSetter(ANNOTATIONS, target);
            if (this.getAnnotations() == null) {
                this.throwNullCollectionException("Annotations");
            }
            this.getAnnotations().add(target);
            target.setImage(this);
        }
        finally {
            this.postSetter(ANNOTATIONS, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageAnnotationSet(Set targets) {
        try {
            this.preSetter(ANNOTATIONS, targets);
            if (this.getAnnotations() == null) {
                this.throwNullCollectionException("Annotations");
            }
            this.getAnnotations().addAll(targets);
            for (ImageAnnotation target : targets) {
                target.setImage(this);
            }
        }
        finally {
            this.postSetter(ANNOTATIONS, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageAnnotation(ImageAnnotation target) {
        try {
            this.preSetter(ANNOTATIONS, target);
            if (this.getAnnotations() == null) {
                this.throwNullCollectionException("Annotations");
            }
            this.getAnnotations().remove(target);
            target.setImage(null);
        }
        finally {
            this.postSetter(ANNOTATIONS, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageAnnotationSet(Set targets) {
        try {
            this.preSetter(ANNOTATIONS, targets);
            if (this.getAnnotations() == null) {
                this.throwNullCollectionException("Annotations");
            }
            this.getAnnotations().removeAll(targets);
            for (ImageAnnotation target : targets) {
                target.setImage(null);
            }
        }
        finally {
            this.postSetter(ANNOTATIONS, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAnnotations() {
        try {
            this.preSetter(ANNOTATIONS, null);
            if (this.getAnnotations() == null) {
                this.throwNullCollectionException("Annotations");
            }
            this.getAnnotations().clear();
            Iterator it = this.iterateAnnotations();
            while (it.hasNext()) {
                ImageAnnotation target = (ImageAnnotation)it.next();
                target.setImage(null);
            }
        }
        finally {
            this.postSetter(ANNOTATIONS, null);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new Image();
    }

    public boolean acceptFilter(Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.name = (String)__filter.filter(NAME, this.name);
        this.description = (String)__filter.filter(DESCRIPTION, this.description);
        this.condition = (ImagingEnvironment)__filter.filter(CONDITION, this.condition);
        this.objectiveSettings = (ObjectiveSettings)__filter.filter(OBJECTIVESETTINGS, this.objectiveSettings);
        this.setup = (Instrument)__filter.filter(SETUP, this.setup);
        this.position = (StageLabel)__filter.filter(POSITION, this.position);
        this.context = (Experiment)__filter.filter(CONTEXT, this.context);
        this.pixels = (Set)__filter.filter(PIXELS, this.pixels);
        this.defaultPixels = (Pixels)__filter.filter(DEFAULTPIXELS, this.defaultPixels);
        this.categoryLinks = (Set)__filter.filter(CATEGORYLINKS, this.categoryLinks);
        this.datasetLinks = (Set)__filter.filter(DATASETLINKS, this.datasetLinks);
        this.annotations = (Set)__filter.filter(ANNOTATIONS, this.annotations);
        return true;
    }

    public String toString() {
        return "Image" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(DESCRIPTION)) {
            return this.getDescription();
        }
        if (field.equals(CONDITION)) {
            return this.getCondition();
        }
        if (field.equals(OBJECTIVESETTINGS)) {
            return this.getObjectiveSettings();
        }
        if (field.equals(SETUP)) {
            return this.getSetup();
        }
        if (field.equals(POSITION)) {
            return this.getPosition();
        }
        if (field.equals(CONTEXT)) {
            return this.getContext();
        }
        if (field.equals(PIXELS)) {
            return this.getPixels();
        }
        if (field.equals(DEFAULTPIXELS)) {
            return this.getDefaultPixels();
        }
        if (field.equals(CATEGORYLINKS)) {
            return this.getCategoryLinks();
        }
        if (field.equals(DATASETLINKS)) {
            return this.getDatasetLinks();
        }
        if (field.equals(ANNOTATIONS)) {
            return this.getAnnotations();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(DESCRIPTION)) {
            this.setDescription((String)value);
        } else if (field.equals(CONDITION)) {
            this.setCondition((ImagingEnvironment)value);
        } else if (field.equals(OBJECTIVESETTINGS)) {
            this.setObjectiveSettings((ObjectiveSettings)value);
        } else if (field.equals(SETUP)) {
            this.setSetup((Instrument)value);
        } else if (field.equals(POSITION)) {
            this.setPosition((StageLabel)value);
        } else if (field.equals(CONTEXT)) {
            this.setContext((Experiment)value);
        } else if (field.equals(PIXELS)) {
            this.setPixels((Set)value);
        } else if (field.equals(DEFAULTPIXELS)) {
            this.setDefaultPixels((Pixels)value);
        } else if (field.equals(CATEGORYLINKS)) {
            this.setCategoryLinks((Set)value);
        } else if (field.equals(DATASETLINKS)) {
            this.setDatasetLinks((Set)value);
        } else if (field.equals(ANNOTATIONS)) {
            this.setAnnotations((Set)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.version = null;
        this.name = null;
        this.description = null;
        this.condition = null;
        this.objectiveSettings = null;
        this.setup = null;
        this.position = null;
        this.context = null;
        this.pixels = null;
        this.defaultPixels = null;
        this.categoryLinks = null;
        this.datasetLinks = null;
        this.annotations = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(NAME);
        raw.add(DESCRIPTION);
        raw.add(CONDITION);
        raw.add(OBJECTIVESETTINGS);
        raw.add(SETUP);
        raw.add(POSITION);
        raw.add(CONTEXT);
        raw.add(PIXELS);
        raw.add(DEFAULTPIXELS);
        raw.add(CATEGORYLINKS);
        raw.add(DATASETLINKS);
        raw.add(ANNOTATIONS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

