/*
 * Decompiled with CFR 0.152.
 */
package ome.model.containers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.DatasetAnnotation;
import ome.model.containers.DatasetImageLink;
import ome.model.containers.Project;
import ome.model.containers.ProjectDatasetLink;
import ome.model.core.Image;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.util.CBlock;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class Dataset
implements IMutable,
IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private String name;
    private String description;
    private Set projectLinks = new HashSet(0);
    private Set imageLinks = new HashSet(0);
    private Set annotations = new HashSet(0);
    public static final String OWNER_FILTER = "dataset_owner_filter";
    public static final String GROUP_FILTER = "dataset_group_filter";
    public static final String EVENT_FILTER = "dataset_event_filter";
    public static final String PERMS_FILTER = "dataset_perms_filter";
    public static final String OWNER_FILTER_PROJECTLINKS = "dataset_owner_filter_PROJECTLINKS";
    public static final String GROUP_FILTER_PROJECTLINKS = "dataset_group_filter_PROJECTLINKS";
    public static final String EVENT_FILTER_PROJECTLINKS = "dataset_event_filter_PROJECTLINKS";
    public static final String PERMS_FILTER_PROJECTLINKS = "dataset_perms_filter_PROJECTLINKS";
    public static final String OWNER_FILTER_IMAGELINKS = "dataset_owner_filter_IMAGELINKS";
    public static final String GROUP_FILTER_IMAGELINKS = "dataset_group_filter_IMAGELINKS";
    public static final String EVENT_FILTER_IMAGELINKS = "dataset_event_filter_IMAGELINKS";
    public static final String PERMS_FILTER_IMAGELINKS = "dataset_perms_filter_IMAGELINKS";
    public static final String OWNER_FILTER_ANNOTATIONS = "dataset_owner_filter_ANNOTATIONS";
    public static final String GROUP_FILTER_ANNOTATIONS = "dataset_group_filter_ANNOTATIONS";
    public static final String EVENT_FILTER_ANNOTATIONS = "dataset_event_filter_ANNOTATIONS";
    public static final String PERMS_FILTER_ANNOTATIONS = "dataset_perms_filter_ANNOTATIONS";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "Dataset_id";
    public static final String DETAILS = "Dataset_details";
    public static final String VERSION = "Dataset_version";
    public static final String NAME = "Dataset_name";
    public static final String DESCRIPTION = "Dataset_description";
    public static final String PROJECTLINKS = "Dataset_projectLinks";
    public static final String IMAGELINKS = "Dataset_imageLinks";
    public static final String ANNOTATIONS = "Dataset_annotations";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public Dataset() {
    }

    public Dataset(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public Dataset(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        try {
            this.preGetter(NAME);
            String string = this.name;
            return string;
        }
        finally {
            this.postGetter(NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        try {
            this.preSetter(NAME, name);
            this.name = name;
        }
        finally {
            this.postSetter(NAME, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        try {
            this.preGetter(DESCRIPTION);
            String string = this.description;
            return string;
        }
        finally {
            this.postGetter(DESCRIPTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDescription(String description) {
        try {
            this.preSetter(DESCRIPTION, description);
            this.description = description;
        }
        finally {
            this.postSetter(DESCRIPTION, description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getProjectLinks() {
        try {
            this.preGetter(PROJECTLINKS);
            Set set = this.projectLinks;
            return set;
        }
        finally {
            this.postGetter(PROJECTLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProjectLinks(Set projectLinks) {
        try {
            this.preSetter(PROJECTLINKS, projectLinks);
            this.projectLinks = projectLinks;
        }
        finally {
            this.postSetter(PROJECTLINKS, projectLinks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfProjectLinks() {
        try {
            this.preGetter(PROJECTLINKS);
            int n = this.projectLinks == null ? -1 : this.projectLinks.size();
            return n;
        }
        finally {
            this.postGetter(PROJECTLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateProjectLinks() {
        try {
            this.preGetter(PROJECTLINKS);
            if (this.getProjectLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getProjectLinks().iterator();
            return iterator;
        }
        finally {
            this.postGetter(PROJECTLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectProjectLinks(CBlock block) {
        try {
            this.preGetter(PROJECTLINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateProjectLinks();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(PROJECTLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkProject(Project addition) {
        try {
            this.preSetter(PROJECTLINKS, addition);
            ProjectDatasetLink link = new ProjectDatasetLink();
            link.link(addition, this);
            this.addProjectDatasetLink(link, true);
        }
        finally {
            this.postSetter(PROJECTLINKS, addition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectDatasetLink(ProjectDatasetLink link, boolean bothSides) {
        try {
            this.preSetter(PROJECTLINKS, link);
            if (this.getProjectLinks() == null) {
                this.throwNullCollectionException("ProjectLinks");
            }
            this.getProjectLinks().add(link);
            if (bothSides && link.parent().isLoaded()) {
                link.parent().addProjectDatasetLink(link, false);
            }
        }
        finally {
            this.postSetter(PROJECTLINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator linkedProjectIterator() {
        try {
            this.preGetter(PROJECTLINKS);
            if (this.getProjectLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            final Iterator it = this.getProjectLinks().iterator();
            Iterator iterator = new Iterator(){

                public boolean hasNext() {
                    return it == null ? false : it.hasNext();
                }

                public Object next() {
                    if (it == null) {
                        throw new NoSuchElementException("projectLinks is null; no elements.");
                    }
                    ProjectDatasetLink link = (ProjectDatasetLink)it.next();
                    return link.parent();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot call remove on this iterator.");
                }
            };
            return iterator;
        }
        finally {
            this.postGetter(PROJECTLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set findProjectDatasetLink(Project target) {
        try {
            this.preGetter(PROJECTLINKS);
            Iterator it = this.iterateProjectLinks();
            HashSet<ProjectDatasetLink> result = new HashSet<ProjectDatasetLink>();
            while (it.hasNext()) {
                ProjectDatasetLink link = (ProjectDatasetLink)it.next();
                if (link.parent() != target) continue;
                result.add(link);
            }
            HashSet<ProjectDatasetLink> hashSet = result;
            return hashSet;
        }
        finally {
            this.postGetter(PROJECTLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List linkedProjectList() {
        try {
            this.preGetter(PROJECTLINKS);
            Iterator it = this.linkedProjectIterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            this.postGetter(PROJECTLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List eachLinkedProject(CBlock block) {
        try {
            this.preGetter(PROJECTLINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.linkedProjectIterator();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(PROJECTLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkProject(Project removal) {
        try {
            this.preSetter(PROJECTLINKS, removal);
            Set toRemove = this.findProjectDatasetLink(removal);
            Iterator it = toRemove.iterator();
            while (it.hasNext()) {
                this.removeProjectDatasetLink((ProjectDatasetLink)it.next(), true);
            }
        }
        finally {
            this.postSetter(PROJECTLINKS, removal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectDatasetLink(ProjectDatasetLink link, boolean bothSides) {
        try {
            this.preSetter(PROJECTLINKS, link);
            if (this.getProjectLinks() == null) {
                this.throwNullCollectionException("ProjectLinks");
            }
            this.getProjectLinks().remove(link);
            if (bothSides && link.parent().isLoaded()) {
                link.parent().removeProjectDatasetLink(link, false);
            }
        }
        finally {
            this.postSetter(PROJECTLINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProjectLinks() {
        try {
            this.preSetter(PROJECTLINKS, null);
            ArrayList list = new ArrayList(this.getProjectLinks());
            for (Object object : list) {
                ProjectDatasetLink link = (ProjectDatasetLink)object;
                this.removeProjectDatasetLink(link, true);
            }
        }
        finally {
            this.postSetter(PROJECTLINKS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getImageLinks() {
        try {
            this.preGetter(IMAGELINKS);
            Set set = this.imageLinks;
            return set;
        }
        finally {
            this.postGetter(IMAGELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setImageLinks(Set imageLinks) {
        try {
            this.preSetter(IMAGELINKS, imageLinks);
            this.imageLinks = imageLinks;
        }
        finally {
            this.postSetter(IMAGELINKS, imageLinks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfImageLinks() {
        try {
            this.preGetter(IMAGELINKS);
            int n = this.imageLinks == null ? -1 : this.imageLinks.size();
            return n;
        }
        finally {
            this.postGetter(IMAGELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateImageLinks() {
        try {
            this.preGetter(IMAGELINKS);
            if (this.getImageLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getImageLinks().iterator();
            return iterator;
        }
        finally {
            this.postGetter(IMAGELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectImageLinks(CBlock block) {
        try {
            this.preGetter(IMAGELINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateImageLinks();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(IMAGELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkImage(Image addition) {
        try {
            this.preSetter(IMAGELINKS, addition);
            DatasetImageLink link = new DatasetImageLink();
            link.link(this, addition);
            this.addDatasetImageLink(link, true);
        }
        finally {
            this.postSetter(IMAGELINKS, addition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDatasetImageLink(DatasetImageLink link, boolean bothSides) {
        try {
            this.preSetter(IMAGELINKS, link);
            if (this.getImageLinks() == null) {
                this.throwNullCollectionException("ImageLinks");
            }
            this.getImageLinks().add(link);
            if (bothSides && link.child().isLoaded()) {
                link.child().addDatasetImageLink(link, false);
            }
        }
        finally {
            this.postSetter(IMAGELINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator linkedImageIterator() {
        try {
            this.preGetter(IMAGELINKS);
            if (this.getImageLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            final Iterator it = this.getImageLinks().iterator();
            Iterator iterator = new Iterator(){

                public boolean hasNext() {
                    return it == null ? false : it.hasNext();
                }

                public Object next() {
                    if (it == null) {
                        throw new NoSuchElementException("imageLinks is null; no elements.");
                    }
                    DatasetImageLink link = (DatasetImageLink)it.next();
                    return link.child();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot call remove on this iterator.");
                }
            };
            return iterator;
        }
        finally {
            this.postGetter(IMAGELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set findDatasetImageLink(Image target) {
        try {
            this.preGetter(IMAGELINKS);
            Iterator it = this.iterateImageLinks();
            HashSet<DatasetImageLink> result = new HashSet<DatasetImageLink>();
            while (it.hasNext()) {
                DatasetImageLink link = (DatasetImageLink)it.next();
                if (link.child() != target) continue;
                result.add(link);
            }
            HashSet<DatasetImageLink> hashSet = result;
            return hashSet;
        }
        finally {
            this.postGetter(IMAGELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List linkedImageList() {
        try {
            this.preGetter(IMAGELINKS);
            Iterator it = this.linkedImageIterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            this.postGetter(IMAGELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List eachLinkedImage(CBlock block) {
        try {
            this.preGetter(IMAGELINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.linkedImageIterator();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(IMAGELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkImage(Image removal) {
        try {
            this.preSetter(IMAGELINKS, removal);
            Set toRemove = this.findDatasetImageLink(removal);
            Iterator it = toRemove.iterator();
            while (it.hasNext()) {
                this.removeDatasetImageLink((DatasetImageLink)it.next(), true);
            }
        }
        finally {
            this.postSetter(IMAGELINKS, removal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatasetImageLink(DatasetImageLink link, boolean bothSides) {
        try {
            this.preSetter(IMAGELINKS, link);
            if (this.getImageLinks() == null) {
                this.throwNullCollectionException("ImageLinks");
            }
            this.getImageLinks().remove(link);
            if (bothSides && link.child().isLoaded()) {
                link.child().removeDatasetImageLink(link, false);
            }
        }
        finally {
            this.postSetter(IMAGELINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearImageLinks() {
        try {
            this.preSetter(IMAGELINKS, null);
            ArrayList list = new ArrayList(this.getImageLinks());
            for (Object object : list) {
                DatasetImageLink link = (DatasetImageLink)object;
                this.removeDatasetImageLink(link, true);
            }
        }
        finally {
            this.postSetter(IMAGELINKS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getAnnotations() {
        try {
            this.preGetter(ANNOTATIONS);
            Set set = this.annotations;
            return set;
        }
        finally {
            this.postGetter(ANNOTATIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAnnotations(Set annotations) {
        try {
            this.preSetter(ANNOTATIONS, annotations);
            this.annotations = annotations;
        }
        finally {
            this.postSetter(ANNOTATIONS, annotations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfAnnotations() {
        try {
            this.preGetter(ANNOTATIONS);
            int n = this.annotations == null ? -1 : this.annotations.size();
            return n;
        }
        finally {
            this.postGetter(ANNOTATIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateAnnotations() {
        try {
            this.preGetter(ANNOTATIONS);
            if (this.getAnnotations() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getAnnotations().iterator();
            return iterator;
        }
        finally {
            this.postGetter(ANNOTATIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectAnnotations(CBlock block) {
        try {
            this.preGetter(ANNOTATIONS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateAnnotations();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(ANNOTATIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDatasetAnnotation(DatasetAnnotation target) {
        try {
            this.preSetter(ANNOTATIONS, target);
            if (this.getAnnotations() == null) {
                this.throwNullCollectionException("Annotations");
            }
            this.getAnnotations().add(target);
            target.setDataset(this);
        }
        finally {
            this.postSetter(ANNOTATIONS, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDatasetAnnotationSet(Set targets) {
        try {
            this.preSetter(ANNOTATIONS, targets);
            if (this.getAnnotations() == null) {
                this.throwNullCollectionException("Annotations");
            }
            this.getAnnotations().addAll(targets);
            for (DatasetAnnotation target : targets) {
                target.setDataset(this);
            }
        }
        finally {
            this.postSetter(ANNOTATIONS, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatasetAnnotation(DatasetAnnotation target) {
        try {
            this.preSetter(ANNOTATIONS, target);
            if (this.getAnnotations() == null) {
                this.throwNullCollectionException("Annotations");
            }
            this.getAnnotations().remove(target);
            target.setDataset(null);
        }
        finally {
            this.postSetter(ANNOTATIONS, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatasetAnnotationSet(Set targets) {
        try {
            this.preSetter(ANNOTATIONS, targets);
            if (this.getAnnotations() == null) {
                this.throwNullCollectionException("Annotations");
            }
            this.getAnnotations().removeAll(targets);
            for (DatasetAnnotation target : targets) {
                target.setDataset(null);
            }
        }
        finally {
            this.postSetter(ANNOTATIONS, targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAnnotations() {
        try {
            this.preSetter(ANNOTATIONS, null);
            if (this.getAnnotations() == null) {
                this.throwNullCollectionException("Annotations");
            }
            this.getAnnotations().clear();
            Iterator it = this.iterateAnnotations();
            while (it.hasNext()) {
                DatasetAnnotation target = (DatasetAnnotation)it.next();
                target.setDataset(null);
            }
        }
        finally {
            this.postSetter(ANNOTATIONS, null);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new Dataset();
    }

    public boolean acceptFilter(Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.name = (String)__filter.filter(NAME, this.name);
        this.description = (String)__filter.filter(DESCRIPTION, this.description);
        this.projectLinks = (Set)__filter.filter(PROJECTLINKS, this.projectLinks);
        this.imageLinks = (Set)__filter.filter(IMAGELINKS, this.imageLinks);
        this.annotations = (Set)__filter.filter(ANNOTATIONS, this.annotations);
        return true;
    }

    public String toString() {
        return "Dataset" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(DESCRIPTION)) {
            return this.getDescription();
        }
        if (field.equals(PROJECTLINKS)) {
            return this.getProjectLinks();
        }
        if (field.equals(IMAGELINKS)) {
            return this.getImageLinks();
        }
        if (field.equals(ANNOTATIONS)) {
            return this.getAnnotations();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(DESCRIPTION)) {
            this.setDescription((String)value);
        } else if (field.equals(PROJECTLINKS)) {
            this.setProjectLinks((Set)value);
        } else if (field.equals(IMAGELINKS)) {
            this.setImageLinks((Set)value);
        } else if (field.equals(ANNOTATIONS)) {
            this.setAnnotations((Set)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.version = null;
        this.name = null;
        this.description = null;
        this.projectLinks = null;
        this.imageLinks = null;
        this.annotations = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(NAME);
        raw.add(DESCRIPTION);
        raw.add(PROJECTLINKS);
        raw.add(IMAGELINKS);
        raw.add(ANNOTATIONS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

