/*
 * Decompiled with CFR 0.152.
 */
package ome.model.containers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.containers.Category;
import ome.model.containers.CategoryGroupCategoryLink;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.util.CBlock;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class CategoryGroup
implements IMutable,
IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private String name;
    private String description;
    private Set categoryLinks = new HashSet(0);
    public static final String OWNER_FILTER = "categorygroup_owner_filter";
    public static final String GROUP_FILTER = "categorygroup_group_filter";
    public static final String EVENT_FILTER = "categorygroup_event_filter";
    public static final String PERMS_FILTER = "categorygroup_perms_filter";
    public static final String OWNER_FILTER_CATEGORYLINKS = "categorygroup_owner_filter_CATEGORYLINKS";
    public static final String GROUP_FILTER_CATEGORYLINKS = "categorygroup_group_filter_CATEGORYLINKS";
    public static final String EVENT_FILTER_CATEGORYLINKS = "categorygroup_event_filter_CATEGORYLINKS";
    public static final String PERMS_FILTER_CATEGORYLINKS = "categorygroup_perms_filter_CATEGORYLINKS";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "CategoryGroup_id";
    public static final String DETAILS = "CategoryGroup_details";
    public static final String VERSION = "CategoryGroup_version";
    public static final String NAME = "CategoryGroup_name";
    public static final String DESCRIPTION = "CategoryGroup_description";
    public static final String CATEGORYLINKS = "CategoryGroup_categoryLinks";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public CategoryGroup() {
    }

    public CategoryGroup(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public CategoryGroup(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        try {
            this.preGetter(NAME);
            String string = this.name;
            return string;
        }
        finally {
            this.postGetter(NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        try {
            this.preSetter(NAME, name);
            this.name = name;
        }
        finally {
            this.postSetter(NAME, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        try {
            this.preGetter(DESCRIPTION);
            String string = this.description;
            return string;
        }
        finally {
            this.postGetter(DESCRIPTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDescription(String description) {
        try {
            this.preSetter(DESCRIPTION, description);
            this.description = description;
        }
        finally {
            this.postSetter(DESCRIPTION, description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getCategoryLinks() {
        try {
            this.preGetter(CATEGORYLINKS);
            Set set = this.categoryLinks;
            return set;
        }
        finally {
            this.postGetter(CATEGORYLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCategoryLinks(Set categoryLinks) {
        try {
            this.preSetter(CATEGORYLINKS, categoryLinks);
            this.categoryLinks = categoryLinks;
        }
        finally {
            this.postSetter(CATEGORYLINKS, categoryLinks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfCategoryLinks() {
        try {
            this.preGetter(CATEGORYLINKS);
            int n = this.categoryLinks == null ? -1 : this.categoryLinks.size();
            return n;
        }
        finally {
            this.postGetter(CATEGORYLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateCategoryLinks() {
        try {
            this.preGetter(CATEGORYLINKS);
            if (this.getCategoryLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getCategoryLinks().iterator();
            return iterator;
        }
        finally {
            this.postGetter(CATEGORYLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectCategoryLinks(CBlock block) {
        try {
            this.preGetter(CATEGORYLINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateCategoryLinks();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(CATEGORYLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkCategory(Category addition) {
        try {
            this.preSetter(CATEGORYLINKS, addition);
            CategoryGroupCategoryLink link = new CategoryGroupCategoryLink();
            link.link(this, addition);
            this.addCategoryGroupCategoryLink(link, true);
        }
        finally {
            this.postSetter(CATEGORYLINKS, addition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCategoryGroupCategoryLink(CategoryGroupCategoryLink link, boolean bothSides) {
        try {
            this.preSetter(CATEGORYLINKS, link);
            if (this.getCategoryLinks() == null) {
                this.throwNullCollectionException("CategoryLinks");
            }
            this.getCategoryLinks().add(link);
            if (bothSides && link.child().isLoaded()) {
                link.child().addCategoryGroupCategoryLink(link, false);
            }
        }
        finally {
            this.postSetter(CATEGORYLINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator linkedCategoryIterator() {
        try {
            this.preGetter(CATEGORYLINKS);
            if (this.getCategoryLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            final Iterator it = this.getCategoryLinks().iterator();
            Iterator iterator = new Iterator(){

                public boolean hasNext() {
                    return it == null ? false : it.hasNext();
                }

                public Object next() {
                    if (it == null) {
                        throw new NoSuchElementException("categoryLinks is null; no elements.");
                    }
                    CategoryGroupCategoryLink link = (CategoryGroupCategoryLink)it.next();
                    return link.child();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot call remove on this iterator.");
                }
            };
            return iterator;
        }
        finally {
            this.postGetter(CATEGORYLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set findCategoryGroupCategoryLink(Category target) {
        try {
            this.preGetter(CATEGORYLINKS);
            Iterator it = this.iterateCategoryLinks();
            HashSet<CategoryGroupCategoryLink> result = new HashSet<CategoryGroupCategoryLink>();
            while (it.hasNext()) {
                CategoryGroupCategoryLink link = (CategoryGroupCategoryLink)it.next();
                if (link.child() != target) continue;
                result.add(link);
            }
            HashSet<CategoryGroupCategoryLink> hashSet = result;
            return hashSet;
        }
        finally {
            this.postGetter(CATEGORYLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List linkedCategoryList() {
        try {
            this.preGetter(CATEGORYLINKS);
            Iterator it = this.linkedCategoryIterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            this.postGetter(CATEGORYLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List eachLinkedCategory(CBlock block) {
        try {
            this.preGetter(CATEGORYLINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.linkedCategoryIterator();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(CATEGORYLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkCategory(Category removal) {
        try {
            this.preSetter(CATEGORYLINKS, removal);
            Set toRemove = this.findCategoryGroupCategoryLink(removal);
            Iterator it = toRemove.iterator();
            while (it.hasNext()) {
                this.removeCategoryGroupCategoryLink((CategoryGroupCategoryLink)it.next(), true);
            }
        }
        finally {
            this.postSetter(CATEGORYLINKS, removal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCategoryGroupCategoryLink(CategoryGroupCategoryLink link, boolean bothSides) {
        try {
            this.preSetter(CATEGORYLINKS, link);
            if (this.getCategoryLinks() == null) {
                this.throwNullCollectionException("CategoryLinks");
            }
            this.getCategoryLinks().remove(link);
            if (bothSides && link.child().isLoaded()) {
                link.child().removeCategoryGroupCategoryLink(link, false);
            }
        }
        finally {
            this.postSetter(CATEGORYLINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCategoryLinks() {
        try {
            this.preSetter(CATEGORYLINKS, null);
            ArrayList list = new ArrayList(this.getCategoryLinks());
            for (Object object : list) {
                CategoryGroupCategoryLink link = (CategoryGroupCategoryLink)object;
                this.removeCategoryGroupCategoryLink(link, true);
            }
        }
        finally {
            this.postSetter(CATEGORYLINKS, null);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new CategoryGroup();
    }

    public boolean acceptFilter(Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.name = (String)__filter.filter(NAME, this.name);
        this.description = (String)__filter.filter(DESCRIPTION, this.description);
        this.categoryLinks = (Set)__filter.filter(CATEGORYLINKS, this.categoryLinks);
        return true;
    }

    public String toString() {
        return "CategoryGroup" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(DESCRIPTION)) {
            return this.getDescription();
        }
        if (field.equals(CATEGORYLINKS)) {
            return this.getCategoryLinks();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(DESCRIPTION)) {
            this.setDescription((String)value);
        } else if (field.equals(CATEGORYLINKS)) {
            this.setCategoryLinks((Set)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.version = null;
        this.name = null;
        this.description = null;
        this.categoryLinks = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(NAME);
        raw.add(DESCRIPTION);
        raw.add(CATEGORYLINKS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

