/*
 * Decompiled with CFR 0.152.
 */
package ome.model.containers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.containers.CategoryGroup;
import ome.model.containers.CategoryGroupCategoryLink;
import ome.model.containers.CategoryImageLink;
import ome.model.core.Image;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.util.CBlock;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class Category
implements IMutable,
IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private String name;
    private String description;
    private Set categoryGroupLinks = new HashSet(0);
    private Set imageLinks = new HashSet(0);
    public static final String OWNER_FILTER = "category_owner_filter";
    public static final String GROUP_FILTER = "category_group_filter";
    public static final String EVENT_FILTER = "category_event_filter";
    public static final String PERMS_FILTER = "category_perms_filter";
    public static final String OWNER_FILTER_CATEGORYGROUPLINKS = "category_owner_filter_CATEGORYGROUPLINKS";
    public static final String GROUP_FILTER_CATEGORYGROUPLINKS = "category_group_filter_CATEGORYGROUPLINKS";
    public static final String EVENT_FILTER_CATEGORYGROUPLINKS = "category_event_filter_CATEGORYGROUPLINKS";
    public static final String PERMS_FILTER_CATEGORYGROUPLINKS = "category_perms_filter_CATEGORYGROUPLINKS";
    public static final String OWNER_FILTER_IMAGELINKS = "category_owner_filter_IMAGELINKS";
    public static final String GROUP_FILTER_IMAGELINKS = "category_group_filter_IMAGELINKS";
    public static final String EVENT_FILTER_IMAGELINKS = "category_event_filter_IMAGELINKS";
    public static final String PERMS_FILTER_IMAGELINKS = "category_perms_filter_IMAGELINKS";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "Category_id";
    public static final String DETAILS = "Category_details";
    public static final String VERSION = "Category_version";
    public static final String NAME = "Category_name";
    public static final String DESCRIPTION = "Category_description";
    public static final String CATEGORYGROUPLINKS = "Category_categoryGroupLinks";
    public static final String IMAGELINKS = "Category_imageLinks";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public Category() {
    }

    public Category(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public Category(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        try {
            this.preGetter(NAME);
            String string = this.name;
            return string;
        }
        finally {
            this.postGetter(NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        try {
            this.preSetter(NAME, name);
            this.name = name;
        }
        finally {
            this.postSetter(NAME, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        try {
            this.preGetter(DESCRIPTION);
            String string = this.description;
            return string;
        }
        finally {
            this.postGetter(DESCRIPTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDescription(String description) {
        try {
            this.preSetter(DESCRIPTION, description);
            this.description = description;
        }
        finally {
            this.postSetter(DESCRIPTION, description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getCategoryGroupLinks() {
        try {
            this.preGetter(CATEGORYGROUPLINKS);
            Set set = this.categoryGroupLinks;
            return set;
        }
        finally {
            this.postGetter(CATEGORYGROUPLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCategoryGroupLinks(Set categoryGroupLinks) {
        try {
            this.preSetter(CATEGORYGROUPLINKS, categoryGroupLinks);
            this.categoryGroupLinks = categoryGroupLinks;
        }
        finally {
            this.postSetter(CATEGORYGROUPLINKS, categoryGroupLinks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfCategoryGroupLinks() {
        try {
            this.preGetter(CATEGORYGROUPLINKS);
            int n = this.categoryGroupLinks == null ? -1 : this.categoryGroupLinks.size();
            return n;
        }
        finally {
            this.postGetter(CATEGORYGROUPLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateCategoryGroupLinks() {
        try {
            this.preGetter(CATEGORYGROUPLINKS);
            if (this.getCategoryGroupLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getCategoryGroupLinks().iterator();
            return iterator;
        }
        finally {
            this.postGetter(CATEGORYGROUPLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectCategoryGroupLinks(CBlock block) {
        try {
            this.preGetter(CATEGORYGROUPLINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateCategoryGroupLinks();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(CATEGORYGROUPLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkCategoryGroup(CategoryGroup addition) {
        try {
            this.preSetter(CATEGORYGROUPLINKS, addition);
            CategoryGroupCategoryLink link = new CategoryGroupCategoryLink();
            link.link(addition, this);
            this.addCategoryGroupCategoryLink(link, true);
        }
        finally {
            this.postSetter(CATEGORYGROUPLINKS, addition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCategoryGroupCategoryLink(CategoryGroupCategoryLink link, boolean bothSides) {
        try {
            this.preSetter(CATEGORYGROUPLINKS, link);
            if (this.getCategoryGroupLinks() == null) {
                this.throwNullCollectionException("CategoryGroupLinks");
            }
            this.getCategoryGroupLinks().add(link);
            if (bothSides && link.parent().isLoaded()) {
                link.parent().addCategoryGroupCategoryLink(link, false);
            }
        }
        finally {
            this.postSetter(CATEGORYGROUPLINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator linkedCategoryGroupIterator() {
        try {
            this.preGetter(CATEGORYGROUPLINKS);
            if (this.getCategoryGroupLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            final Iterator it = this.getCategoryGroupLinks().iterator();
            Iterator iterator = new Iterator(){

                public boolean hasNext() {
                    return it == null ? false : it.hasNext();
                }

                public Object next() {
                    if (it == null) {
                        throw new NoSuchElementException("categoryGroupLinks is null; no elements.");
                    }
                    CategoryGroupCategoryLink link = (CategoryGroupCategoryLink)it.next();
                    return link.parent();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot call remove on this iterator.");
                }
            };
            return iterator;
        }
        finally {
            this.postGetter(CATEGORYGROUPLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set findCategoryGroupCategoryLink(CategoryGroup target) {
        try {
            this.preGetter(CATEGORYGROUPLINKS);
            Iterator it = this.iterateCategoryGroupLinks();
            HashSet<CategoryGroupCategoryLink> result = new HashSet<CategoryGroupCategoryLink>();
            while (it.hasNext()) {
                CategoryGroupCategoryLink link = (CategoryGroupCategoryLink)it.next();
                if (link.parent() != target) continue;
                result.add(link);
            }
            HashSet<CategoryGroupCategoryLink> hashSet = result;
            return hashSet;
        }
        finally {
            this.postGetter(CATEGORYGROUPLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List linkedCategoryGroupList() {
        try {
            this.preGetter(CATEGORYGROUPLINKS);
            Iterator it = this.linkedCategoryGroupIterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            this.postGetter(CATEGORYGROUPLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List eachLinkedCategoryGroup(CBlock block) {
        try {
            this.preGetter(CATEGORYGROUPLINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.linkedCategoryGroupIterator();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(CATEGORYGROUPLINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkCategoryGroup(CategoryGroup removal) {
        try {
            this.preSetter(CATEGORYGROUPLINKS, removal);
            Set toRemove = this.findCategoryGroupCategoryLink(removal);
            Iterator it = toRemove.iterator();
            while (it.hasNext()) {
                this.removeCategoryGroupCategoryLink((CategoryGroupCategoryLink)it.next(), true);
            }
        }
        finally {
            this.postSetter(CATEGORYGROUPLINKS, removal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCategoryGroupCategoryLink(CategoryGroupCategoryLink link, boolean bothSides) {
        try {
            this.preSetter(CATEGORYGROUPLINKS, link);
            if (this.getCategoryGroupLinks() == null) {
                this.throwNullCollectionException("CategoryGroupLinks");
            }
            this.getCategoryGroupLinks().remove(link);
            if (bothSides && link.parent().isLoaded()) {
                link.parent().removeCategoryGroupCategoryLink(link, false);
            }
        }
        finally {
            this.postSetter(CATEGORYGROUPLINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCategoryGroupLinks() {
        try {
            this.preSetter(CATEGORYGROUPLINKS, null);
            ArrayList list = new ArrayList(this.getCategoryGroupLinks());
            for (Object object : list) {
                CategoryGroupCategoryLink link = (CategoryGroupCategoryLink)object;
                this.removeCategoryGroupCategoryLink(link, true);
            }
        }
        finally {
            this.postSetter(CATEGORYGROUPLINKS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getImageLinks() {
        try {
            this.preGetter(IMAGELINKS);
            Set set = this.imageLinks;
            return set;
        }
        finally {
            this.postGetter(IMAGELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setImageLinks(Set imageLinks) {
        try {
            this.preSetter(IMAGELINKS, imageLinks);
            this.imageLinks = imageLinks;
        }
        finally {
            this.postSetter(IMAGELINKS, imageLinks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeOfImageLinks() {
        try {
            this.preGetter(IMAGELINKS);
            int n = this.imageLinks == null ? -1 : this.imageLinks.size();
            return n;
        }
        finally {
            this.postGetter(IMAGELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterateImageLinks() {
        try {
            this.preGetter(IMAGELINKS);
            if (this.getImageLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            Iterator iterator = this.getImageLinks().iterator();
            return iterator;
        }
        finally {
            this.postGetter(IMAGELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List collectImageLinks(CBlock block) {
        try {
            this.preGetter(IMAGELINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.iterateImageLinks();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(IMAGELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkImage(Image addition) {
        try {
            this.preSetter(IMAGELINKS, addition);
            CategoryImageLink link = new CategoryImageLink();
            link.link(this, addition);
            this.addCategoryImageLink(link, true);
        }
        finally {
            this.postSetter(IMAGELINKS, addition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCategoryImageLink(CategoryImageLink link, boolean bothSides) {
        try {
            this.preSetter(IMAGELINKS, link);
            if (this.getImageLinks() == null) {
                this.throwNullCollectionException("ImageLinks");
            }
            this.getImageLinks().add(link);
            if (bothSides && link.child().isLoaded()) {
                link.child().addCategoryImageLink(link, false);
            }
        }
        finally {
            this.postSetter(IMAGELINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator linkedImageIterator() {
        try {
            this.preGetter(IMAGELINKS);
            if (this.getImageLinks() == null) {
                EmptyIterator emptyIterator = new EmptyIterator();
                return emptyIterator;
            }
            final Iterator it = this.getImageLinks().iterator();
            Iterator iterator = new Iterator(){

                public boolean hasNext() {
                    return it == null ? false : it.hasNext();
                }

                public Object next() {
                    if (it == null) {
                        throw new NoSuchElementException("imageLinks is null; no elements.");
                    }
                    CategoryImageLink link = (CategoryImageLink)it.next();
                    return link.child();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot call remove on this iterator.");
                }
            };
            return iterator;
        }
        finally {
            this.postGetter(IMAGELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set findCategoryImageLink(Image target) {
        try {
            this.preGetter(IMAGELINKS);
            Iterator it = this.iterateImageLinks();
            HashSet<CategoryImageLink> result = new HashSet<CategoryImageLink>();
            while (it.hasNext()) {
                CategoryImageLink link = (CategoryImageLink)it.next();
                if (link.child() != target) continue;
                result.add(link);
            }
            HashSet<CategoryImageLink> hashSet = result;
            return hashSet;
        }
        finally {
            this.postGetter(IMAGELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List linkedImageList() {
        try {
            this.preGetter(IMAGELINKS);
            Iterator it = this.linkedImageIterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            this.postGetter(IMAGELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List eachLinkedImage(CBlock block) {
        try {
            this.preGetter(IMAGELINKS);
            ArrayList result = new ArrayList();
            Iterator it = this.linkedImageIterator();
            while (it.hasNext()) {
                IObject obj = (IObject)it.next();
                if (block != null) {
                    result.add(block.call(obj));
                    continue;
                }
                result.add(obj);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.postGetter(IMAGELINKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkImage(Image removal) {
        try {
            this.preSetter(IMAGELINKS, removal);
            Set toRemove = this.findCategoryImageLink(removal);
            Iterator it = toRemove.iterator();
            while (it.hasNext()) {
                this.removeCategoryImageLink((CategoryImageLink)it.next(), true);
            }
        }
        finally {
            this.postSetter(IMAGELINKS, removal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCategoryImageLink(CategoryImageLink link, boolean bothSides) {
        try {
            this.preSetter(IMAGELINKS, link);
            if (this.getImageLinks() == null) {
                this.throwNullCollectionException("ImageLinks");
            }
            this.getImageLinks().remove(link);
            if (bothSides && link.child().isLoaded()) {
                link.child().removeCategoryImageLink(link, false);
            }
        }
        finally {
            this.postSetter(IMAGELINKS, link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearImageLinks() {
        try {
            this.preSetter(IMAGELINKS, null);
            ArrayList list = new ArrayList(this.getImageLinks());
            for (Object object : list) {
                CategoryImageLink link = (CategoryImageLink)object;
                this.removeCategoryImageLink(link, true);
            }
        }
        finally {
            this.postSetter(IMAGELINKS, null);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new Category();
    }

    public boolean acceptFilter(Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.name = (String)__filter.filter(NAME, this.name);
        this.description = (String)__filter.filter(DESCRIPTION, this.description);
        this.categoryGroupLinks = (Set)__filter.filter(CATEGORYGROUPLINKS, this.categoryGroupLinks);
        this.imageLinks = (Set)__filter.filter(IMAGELINKS, this.imageLinks);
        return true;
    }

    public String toString() {
        return "Category" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(DESCRIPTION)) {
            return this.getDescription();
        }
        if (field.equals(CATEGORYGROUPLINKS)) {
            return this.getCategoryGroupLinks();
        }
        if (field.equals(IMAGELINKS)) {
            return this.getImageLinks();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(DESCRIPTION)) {
            this.setDescription((String)value);
        } else if (field.equals(CATEGORYGROUPLINKS)) {
            this.setCategoryGroupLinks((Set)value);
        } else if (field.equals(IMAGELINKS)) {
            this.setImageLinks((Set)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.version = null;
        this.name = null;
        this.description = null;
        this.categoryGroupLinks = null;
        this.imageLinks = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(NAME);
        raw.add(DESCRIPTION);
        raw.add(CATEGORYGROUPLINKS);
        raw.add(IMAGELINKS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

