/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.Objective;
import ome.model.enums.Medium;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class ObjectiveSettings
implements IMutable,
IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private Float correctionCollar;
    private Medium medium;
    private Float refractiveIndex;
    private Objective objective;
    public static final String OWNER_FILTER = "objectivesettings_owner_filter";
    public static final String GROUP_FILTER = "objectivesettings_group_filter";
    public static final String EVENT_FILTER = "objectivesettings_event_filter";
    public static final String PERMS_FILTER = "objectivesettings_perms_filter";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "ObjectiveSettings_id";
    public static final String DETAILS = "ObjectiveSettings_details";
    public static final String VERSION = "ObjectiveSettings_version";
    public static final String CORRECTIONCOLLAR = "ObjectiveSettings_correctionCollar";
    public static final String MEDIUM = "ObjectiveSettings_medium";
    public static final String REFRACTIVEINDEX = "ObjectiveSettings_refractiveIndex";
    public static final String OBJECTIVE = "ObjectiveSettings_objective";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public ObjectiveSettings() {
    }

    public ObjectiveSettings(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public ObjectiveSettings(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getCorrectionCollar() {
        try {
            this.preGetter(CORRECTIONCOLLAR);
            Float f = this.correctionCollar;
            return f;
        }
        finally {
            this.postGetter(CORRECTIONCOLLAR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorrectionCollar(Float correctionCollar) {
        try {
            this.preSetter(CORRECTIONCOLLAR, correctionCollar);
            this.correctionCollar = correctionCollar;
        }
        finally {
            this.postSetter(CORRECTIONCOLLAR, correctionCollar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Medium getMedium() {
        try {
            this.preGetter(MEDIUM);
            Medium medium = this.medium;
            return medium;
        }
        finally {
            this.postGetter(MEDIUM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMedium(Medium medium) {
        try {
            this.preSetter(MEDIUM, medium);
            this.medium = medium;
        }
        finally {
            this.postSetter(MEDIUM, medium);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getRefractiveIndex() {
        try {
            this.preGetter(REFRACTIVEINDEX);
            Float f = this.refractiveIndex;
            return f;
        }
        finally {
            this.postGetter(REFRACTIVEINDEX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRefractiveIndex(Float refractiveIndex) {
        try {
            this.preSetter(REFRACTIVEINDEX, refractiveIndex);
            this.refractiveIndex = refractiveIndex;
        }
        finally {
            this.postSetter(REFRACTIVEINDEX, refractiveIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Objective getObjective() {
        try {
            this.preGetter(OBJECTIVE);
            Objective objective = this.objective;
            return objective;
        }
        finally {
            this.postGetter(OBJECTIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjective(Objective objective) {
        try {
            this.preSetter(OBJECTIVE, objective);
            this.objective = objective;
        }
        finally {
            this.postSetter(OBJECTIVE, objective);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new ObjectiveSettings();
    }

    public boolean acceptFilter(Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.correctionCollar = (Float)__filter.filter(CORRECTIONCOLLAR, this.correctionCollar);
        this.medium = (Medium)__filter.filter(MEDIUM, this.medium);
        this.refractiveIndex = (Float)__filter.filter(REFRACTIVEINDEX, this.refractiveIndex);
        this.objective = (Objective)__filter.filter(OBJECTIVE, this.objective);
        return true;
    }

    public String toString() {
        return "ObjectiveSettings" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(CORRECTIONCOLLAR)) {
            return this.getCorrectionCollar();
        }
        if (field.equals(MEDIUM)) {
            return this.getMedium();
        }
        if (field.equals(REFRACTIVEINDEX)) {
            return this.getRefractiveIndex();
        }
        if (field.equals(OBJECTIVE)) {
            return this.getObjective();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(CORRECTIONCOLLAR)) {
            this.setCorrectionCollar((Float)value);
        } else if (field.equals(MEDIUM)) {
            this.setMedium((Medium)value);
        } else if (field.equals(REFRACTIVEINDEX)) {
            this.setRefractiveIndex((Float)value);
        } else if (field.equals(OBJECTIVE)) {
            this.setObjective((Objective)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.version = null;
        this.correctionCollar = null;
        this.medium = null;
        this.refractiveIndex = null;
        this.objective = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(CORRECTIONCOLLAR);
        raw.add(MEDIUM);
        raw.add(REFRACTIVEINDEX);
        raw.add(OBJECTIVE);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

