/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.Instrument;
import ome.model.enums.Coating;
import ome.model.enums.Immersion;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class Objective
implements IMutable,
IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private String manufacturer;
    private String model;
    private String serialNumber;
    private Double magnificiation;
    private Float lensNA;
    private Immersion immersion;
    private Coating coating;
    private Instrument instrument;
    public static final String OWNER_FILTER = "objective_owner_filter";
    public static final String GROUP_FILTER = "objective_group_filter";
    public static final String EVENT_FILTER = "objective_event_filter";
    public static final String PERMS_FILTER = "objective_perms_filter";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "Objective_id";
    public static final String DETAILS = "Objective_details";
    public static final String VERSION = "Objective_version";
    public static final String MANUFACTURER = "Objective_manufacturer";
    public static final String MODEL = "Objective_model";
    public static final String SERIALNUMBER = "Objective_serialNumber";
    public static final String MAGNIFICIATION = "Objective_magnificiation";
    public static final String LENSNA = "Objective_lensNA";
    public static final String IMMERSION = "Objective_immersion";
    public static final String COATING = "Objective_coating";
    public static final String INSTRUMENT = "Objective_instrument";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public Objective() {
    }

    public Objective(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public Objective(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getManufacturer() {
        try {
            this.preGetter(MANUFACTURER);
            String string = this.manufacturer;
            return string;
        }
        finally {
            this.postGetter(MANUFACTURER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManufacturer(String manufacturer) {
        try {
            this.preSetter(MANUFACTURER, manufacturer);
            this.manufacturer = manufacturer;
        }
        finally {
            this.postSetter(MANUFACTURER, manufacturer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModel() {
        try {
            this.preGetter(MODEL);
            String string = this.model;
            return string;
        }
        finally {
            this.postGetter(MODEL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(String model) {
        try {
            this.preSetter(MODEL, model);
            this.model = model;
        }
        finally {
            this.postSetter(MODEL, model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerialNumber() {
        try {
            this.preGetter(SERIALNUMBER);
            String string = this.serialNumber;
            return string;
        }
        finally {
            this.postGetter(SERIALNUMBER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSerialNumber(String serialNumber) {
        try {
            this.preSetter(SERIALNUMBER, serialNumber);
            this.serialNumber = serialNumber;
        }
        finally {
            this.postSetter(SERIALNUMBER, serialNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getMagnificiation() {
        try {
            this.preGetter(MAGNIFICIATION);
            Double d = this.magnificiation;
            return d;
        }
        finally {
            this.postGetter(MAGNIFICIATION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMagnificiation(Double magnificiation) {
        try {
            this.preSetter(MAGNIFICIATION, magnificiation);
            this.magnificiation = magnificiation;
        }
        finally {
            this.postSetter(MAGNIFICIATION, magnificiation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getLensNA() {
        try {
            this.preGetter(LENSNA);
            Float f = this.lensNA;
            return f;
        }
        finally {
            this.postGetter(LENSNA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLensNA(Float lensNA) {
        try {
            this.preSetter(LENSNA, lensNA);
            this.lensNA = lensNA;
        }
        finally {
            this.postSetter(LENSNA, lensNA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Immersion getImmersion() {
        try {
            this.preGetter(IMMERSION);
            Immersion immersion = this.immersion;
            return immersion;
        }
        finally {
            this.postGetter(IMMERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImmersion(Immersion immersion) {
        try {
            this.preSetter(IMMERSION, immersion);
            this.immersion = immersion;
        }
        finally {
            this.postSetter(IMMERSION, immersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Coating getCoating() {
        try {
            this.preGetter(COATING);
            Coating coating = this.coating;
            return coating;
        }
        finally {
            this.postGetter(COATING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoating(Coating coating) {
        try {
            this.preSetter(COATING, coating);
            this.coating = coating;
        }
        finally {
            this.postSetter(COATING, coating);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instrument getInstrument() {
        try {
            this.preGetter(INSTRUMENT);
            Instrument instrument = this.instrument;
            return instrument;
        }
        finally {
            this.postGetter(INSTRUMENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstrument(Instrument instrument) {
        try {
            this.preSetter(INSTRUMENT, instrument);
            this.instrument = instrument;
        }
        finally {
            this.postSetter(INSTRUMENT, instrument);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new Objective();
    }

    public boolean acceptFilter(Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.manufacturer = (String)__filter.filter(MANUFACTURER, this.manufacturer);
        this.model = (String)__filter.filter(MODEL, this.model);
        this.serialNumber = (String)__filter.filter(SERIALNUMBER, this.serialNumber);
        this.magnificiation = (Double)__filter.filter(MAGNIFICIATION, this.magnificiation);
        this.lensNA = (Float)__filter.filter(LENSNA, this.lensNA);
        this.immersion = (Immersion)__filter.filter(IMMERSION, this.immersion);
        this.coating = (Coating)__filter.filter(COATING, this.coating);
        this.instrument = (Instrument)__filter.filter(INSTRUMENT, this.instrument);
        return true;
    }

    public String toString() {
        return "Objective" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(MANUFACTURER)) {
            return this.getManufacturer();
        }
        if (field.equals(MODEL)) {
            return this.getModel();
        }
        if (field.equals(SERIALNUMBER)) {
            return this.getSerialNumber();
        }
        if (field.equals(MAGNIFICIATION)) {
            return this.getMagnificiation();
        }
        if (field.equals(LENSNA)) {
            return this.getLensNA();
        }
        if (field.equals(IMMERSION)) {
            return this.getImmersion();
        }
        if (field.equals(COATING)) {
            return this.getCoating();
        }
        if (field.equals(INSTRUMENT)) {
            return this.getInstrument();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(MANUFACTURER)) {
            this.setManufacturer((String)value);
        } else if (field.equals(MODEL)) {
            this.setModel((String)value);
        } else if (field.equals(SERIALNUMBER)) {
            this.setSerialNumber((String)value);
        } else if (field.equals(MAGNIFICIATION)) {
            this.setMagnificiation((Double)value);
        } else if (field.equals(LENSNA)) {
            this.setLensNA((Float)value);
        } else if (field.equals(IMMERSION)) {
            this.setImmersion((Immersion)value);
        } else if (field.equals(COATING)) {
            this.setCoating((Coating)value);
        } else if (field.equals(INSTRUMENT)) {
            this.setInstrument((Instrument)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.version = null;
        this.manufacturer = null;
        this.model = null;
        this.serialNumber = null;
        this.magnificiation = null;
        this.lensNA = null;
        this.immersion = null;
        this.coating = null;
        this.instrument = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(MANUFACTURER);
        raw.add(MODEL);
        raw.add(SERIALNUMBER);
        raw.add(MAGNIFICIATION);
        raw.add(LENSNA);
        raw.add(IMMERSION);
        raw.add(COATING);
        raw.add(INSTRUMENT);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

