/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.LightSource;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class LightSettings
implements IMutable,
IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private Float power;
    private String technique;
    private LightSource lightSource;
    public static final String OWNER_FILTER = "lightsettings_owner_filter";
    public static final String GROUP_FILTER = "lightsettings_group_filter";
    public static final String EVENT_FILTER = "lightsettings_event_filter";
    public static final String PERMS_FILTER = "lightsettings_perms_filter";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "LightSettings_id";
    public static final String DETAILS = "LightSettings_details";
    public static final String VERSION = "LightSettings_version";
    public static final String POWER = "LightSettings_power";
    public static final String TECHNIQUE = "LightSettings_technique";
    public static final String LIGHTSOURCE = "LightSettings_lightSource";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public LightSettings() {
    }

    public LightSettings(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public LightSettings(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getPower() {
        try {
            this.preGetter(POWER);
            Float f = this.power;
            return f;
        }
        finally {
            this.postGetter(POWER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPower(Float power) {
        try {
            this.preSetter(POWER, power);
            this.power = power;
        }
        finally {
            this.postSetter(POWER, power);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTechnique() {
        try {
            this.preGetter(TECHNIQUE);
            String string = this.technique;
            return string;
        }
        finally {
            this.postGetter(TECHNIQUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTechnique(String technique) {
        try {
            this.preSetter(TECHNIQUE, technique);
            this.technique = technique;
        }
        finally {
            this.postSetter(TECHNIQUE, technique);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LightSource getLightSource() {
        try {
            this.preGetter(LIGHTSOURCE);
            LightSource lightSource = this.lightSource;
            return lightSource;
        }
        finally {
            this.postGetter(LIGHTSOURCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLightSource(LightSource lightSource) {
        try {
            this.preSetter(LIGHTSOURCE, lightSource);
            this.lightSource = lightSource;
        }
        finally {
            this.postSetter(LIGHTSOURCE, lightSource);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new LightSettings();
    }

    public boolean acceptFilter(Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.power = (Float)__filter.filter(POWER, this.power);
        this.technique = (String)__filter.filter(TECHNIQUE, this.technique);
        this.lightSource = (LightSource)__filter.filter(LIGHTSOURCE, this.lightSource);
        return true;
    }

    public String toString() {
        return "LightSettings" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(POWER)) {
            return this.getPower();
        }
        if (field.equals(TECHNIQUE)) {
            return this.getTechnique();
        }
        if (field.equals(LIGHTSOURCE)) {
            return this.getLightSource();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(POWER)) {
            this.setPower((Float)value);
        } else if (field.equals(TECHNIQUE)) {
            this.setTechnique((String)value);
        } else if (field.equals(LIGHTSOURCE)) {
            this.setLightSource((LightSource)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.version = null;
        this.power = null;
        this.technique = null;
        this.lightSource = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(POWER);
        raw.add(TECHNIQUE);
        raw.add(LIGHTSOURCE);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

