/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.CustomizedFilterSet;
import ome.model.acquisition.FilterSet;
import ome.model.acquisition.Instrument;
import ome.model.internal.Details;
import ome.model.internal.GraphHolder;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class Filter
implements IMutable,
IObject,
Serializable {
    private Long id;
    private Details details = new Details();
    private Integer version = new Integer(0);
    private Boolean customized;
    private FilterSet filterSet;
    private CustomizedFilterSet customizedFilterSet;
    private Instrument instrument;
    public static final String OWNER_FILTER = "filter_owner_filter";
    public static final String GROUP_FILTER = "filter_group_filter";
    public static final String EVENT_FILTER = "filter_event_filter";
    public static final String PERMS_FILTER = "filter_perms_filter";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String ID = "Filter_id";
    public static final String DETAILS = "Filter_details";
    public static final String VERSION = "Filter_version";
    public static final String CUSTOMIZED = "Filter_customized";
    public static final String FILTERSET = "Filter_filterSet";
    public static final String CUSTOMIZEDFILTERSET = "Filter_customizedFilterSet";
    public static final String INSTRUMENT = "Filter_instrument";
    public static final Set FIELDS;
    protected Map _dynamicFields;
    protected boolean _loaded = true;
    private transient GraphHolder _graphHolder;

    public Filter() {
    }

    public Filter(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public Filter(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Details getDetails() {
        try {
            this.preGetter(DETAILS);
            Details details = this.details;
            return details;
        }
        finally {
            this.postGetter(DETAILS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(Details details) {
        try {
            this.preSetter(DETAILS, details);
            this.details = details;
        }
        finally {
            this.postSetter(DETAILS, details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getVersion() {
        try {
            this.preGetter(VERSION);
            Integer n = this.version;
            return n;
        }
        finally {
            this.postGetter(VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(Integer version) {
        try {
            this.preSetter(VERSION, version);
            this.version = version;
        }
        finally {
            this.postSetter(VERSION, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getCustomized() {
        try {
            this.preGetter(CUSTOMIZED);
            Boolean bl = this.customized;
            return bl;
        }
        finally {
            this.postGetter(CUSTOMIZED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomized(Boolean customized) {
        try {
            this.preSetter(CUSTOMIZED, customized);
            this.customized = customized;
        }
        finally {
            this.postSetter(CUSTOMIZED, customized);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterSet getFilterSet() {
        try {
            this.preGetter(FILTERSET);
            FilterSet filterSet = this.filterSet;
            return filterSet;
        }
        finally {
            this.postGetter(FILTERSET);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilterSet(FilterSet filterSet) {
        try {
            this.preSetter(FILTERSET, filterSet);
            this.filterSet = filterSet;
        }
        finally {
            this.postSetter(FILTERSET, filterSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomizedFilterSet getCustomizedFilterSet() {
        try {
            this.preGetter(CUSTOMIZEDFILTERSET);
            CustomizedFilterSet customizedFilterSet = this.customizedFilterSet;
            return customizedFilterSet;
        }
        finally {
            this.postGetter(CUSTOMIZEDFILTERSET);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomizedFilterSet(CustomizedFilterSet customizedFilterSet) {
        try {
            this.preSetter(CUSTOMIZEDFILTERSET, customizedFilterSet);
            this.customizedFilterSet = customizedFilterSet;
        }
        finally {
            this.postSetter(CUSTOMIZEDFILTERSET, customizedFilterSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instrument getInstrument() {
        try {
            this.preGetter(INSTRUMENT);
            Instrument instrument = this.instrument;
            return instrument;
        }
        finally {
            this.postGetter(INSTRUMENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstrument(Instrument instrument) {
        try {
            this.preSetter(INSTRUMENT, instrument);
            this.instrument = instrument;
        }
        finally {
            this.postSetter(INSTRUMENT, instrument);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new Filter();
    }

    public boolean acceptFilter(ome.util.Filter __filter) {
        this.id = (Long)__filter.filter(ID, this.id);
        this.details = (Details)__filter.filter(DETAILS, this.details);
        this.version = (Integer)__filter.filter(VERSION, this.version);
        this.customized = (Boolean)__filter.filter(CUSTOMIZED, this.customized);
        this.filterSet = (FilterSet)__filter.filter(FILTERSET, this.filterSet);
        this.customizedFilterSet = (CustomizedFilterSet)__filter.filter(CUSTOMIZEDFILTERSET, this.customizedFilterSet);
        this.instrument = (Instrument)__filter.filter(INSTRUMENT, this.instrument);
        return true;
    }

    public String toString() {
        return "Filter" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(CUSTOMIZED)) {
            return this.getCustomized();
        }
        if (field.equals(FILTERSET)) {
            return this.getFilterSet();
        }
        if (field.equals(CUSTOMIZEDFILTERSET)) {
            return this.getCustomizedFilterSet();
        }
        if (field.equals(INSTRUMENT)) {
            return this.getInstrument();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((Details)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(CUSTOMIZED)) {
            this.setCustomized((Boolean)value);
        } else if (field.equals(FILTERSET)) {
            this.setFilterSet((FilterSet)value);
        } else if (field.equals(CUSTOMIZEDFILTERSET)) {
            this.setCustomizedFilterSet((CustomizedFilterSet)value);
        } else if (field.equals(INSTRUMENT)) {
            this.setInstrument((Instrument)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap();
            }
            this._dynamicFields.put(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.details = null;
        this.version = null;
        this.customized = null;
        this.filterSet = null;
        this.customizedFilterSet = null;
        this.instrument = null;
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(DETAILS);
        raw.add(VERSION);
        raw.add(CUSTOMIZED);
        raw.add(FILTERSET);
        raw.add(CUSTOMIZEDFILTERSET);
        raw.add(INSTRUMENT);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

