/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.LightSource;
import ome.model.enums.ArcType;
import ome.util.Filter;
import ome.util.Filterable;
import ome.util.Validation;
import ome.util.Validator;

public class Arc
extends LightSource
implements IMutable,
IObject,
Serializable {
    private ArcType type;
    public static final String OWNER_FILTER = "arc_owner_filter";
    public static final String GROUP_FILTER = "arc_group_filter";
    public static final String EVENT_FILTER = "arc_event_filter";
    public static final String PERMS_FILTER = "arc_perms_filter";
    private static final long serialVersionUID = 0xC00010C1L;
    public static final String TYPE = "Arc_type";
    public static final Set FIELDS;

    public Arc() {
    }

    public Arc(Long id) {
        this.setId(id);
        this.getDetails().setContext(this);
    }

    public Arc(Long id, boolean loaded) {
        this(id);
        if (!loaded) {
            this.unload();
        }
    }

    protected void preGetter(String field) {
        this.errorIfUnloaded();
    }

    protected void postGetter(String field) {
    }

    protected void preSetter(String field, Object value) {
        this.errorIfUnloaded();
    }

    protected void postSetter(String field, Object value) {
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArcType getType() {
        try {
            this.preGetter(TYPE);
            ArcType arcType = this.type;
            return arcType;
        }
        finally {
            this.postGetter(TYPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(ArcType type) {
        try {
            this.preSetter(TYPE, type);
            this.type = type;
        }
        finally {
            this.postSetter(TYPE, type);
        }
    }

    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    public Validation validate() {
        return Validator.validate(this);
    }

    public Filterable newInstance() {
        return new Arc();
    }

    public boolean acceptFilter(Filter __filter) {
        this.type = (ArcType)__filter.filter(TYPE, this.type);
        return super.acceptFilter(__filter);
    }

    public String toString() {
        return "Arc" + (this.getId() == null ? ":Hash_" + this.hashCode() : ":Id_" + this.getId());
    }

    public Set fields() {
        return FIELDS;
    }

    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(TYPE)) {
            return this.getType();
        }
        return super.retrieve(field);
    }

    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(TYPE)) {
            this.setType((ArcType)value);
        } else {
            super.putAt(field, value);
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void unload() {
        this._loaded = false;
        this.type = null;
        super.unload();
    }

    protected void errorIfUnloaded() {
        if (!this._loaded) {
            throw new IllegalStateException("Object unloaded:" + this);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(TYPE);
        raw.addAll(LightSource.FIELDS);
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

