/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Effect;
import fj.F;
import fj.data.List;
import fj.data.Option;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NonEmptyList<A>
implements Iterable<A> {
    public final A head;
    public final List<A> tail;

    @Override
    public Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    private NonEmptyList(A head, List<A> tail) {
        this.head = head;
        this.tail = tail;
    }

    public NonEmptyList<A> cons(A a) {
        return NonEmptyList.nel(a, this.tail.cons(this.head));
    }

    public NonEmptyList<A> append(NonEmptyList<A> as) {
        List.Buffer<A> b = new List.Buffer<A>();
        b.append(this.tail);
        b.snoc(as.head);
        b.append(as.tail);
        List bb = b.toList();
        return NonEmptyList.nel(this.head, bb);
    }

    public <B> NonEmptyList<B> map(F<A, B> f2) {
        return NonEmptyList.nel(f2.f(this.head), this.tail.map(f2));
    }

    public <B> NonEmptyList<B> bind(final F<A, NonEmptyList<B>> f2) {
        final List.Buffer<A> b = new List.Buffer<A>();
        NonEmptyList<B> p = f2.f(this.head);
        b.snoc(p.head);
        b.append(p.tail);
        this.tail.foreach(new Effect<A>(){

            @Override
            public void e(A a) {
                NonEmptyList p = (NonEmptyList)f2.f(a);
                b.snoc(p.head);
                b.append(p.tail);
            }
        });
        List bb = b.toList();
        return NonEmptyList.nel(bb.head(), bb.tail());
    }

    public List<A> toList() {
        return this.tail.cons(this.head);
    }

    public Collection<A> toCollection() {
        return this.toList().toCollection();
    }

    public static <A> F<NonEmptyList<A>, List<A>> toList_() {
        return new F<NonEmptyList<A>, List<A>>(){

            @Override
            public List<A> f(NonEmptyList<A> as) {
                return as.toList();
            }
        };
    }

    public static <A> NonEmptyList<A> nel(A head, List<A> tail) {
        return new NonEmptyList<A>(head, tail);
    }

    public static <A> NonEmptyList<A> nel(A head) {
        return NonEmptyList.nel(head, List.nil());
    }

    public static <A> F<A, NonEmptyList<A>> nel() {
        return new F<A, NonEmptyList<A>>(){

            @Override
            public NonEmptyList<A> f(A a) {
                return NonEmptyList.nel(a);
            }
        };
    }

    public static <A> Option<NonEmptyList<A>> fromList(List<A> as) {
        return as.isEmpty() ? Option.none() : Option.some(NonEmptyList.nel(as.head(), as.tail()));
    }
}

