/*
 * Decompiled with CFR 0.152.
 */
package fj.control.parallel;

import fj.Effect;
import fj.F;
import fj.Function;
import fj.P;
import fj.P1;
import fj.Unit;
import fj.control.parallel.Actor;
import fj.control.parallel.Strategy;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueueActor<A> {
    private final AtomicBoolean suspended = new AtomicBoolean(true);
    private final Queue<A> mbox = new ConcurrentLinkedQueue<A>();
    private final Actor<Unit> act;
    private final Actor<A> selfish;

    private QueueActor(Strategy<Unit> s, final Effect<A> ea) {
        this.act = Actor.actor(s, new Effect<Unit>(){

            @Override
            public void e(Unit u) {
                ea.e(QueueActor.this.mbox.remove());
                if (QueueActor.this.mbox.isEmpty()) {
                    QueueActor.this.suspended.set(true);
                    QueueActor.this.work();
                } else {
                    QueueActor.this.act.act(u);
                }
            }
        });
        this.selfish = Actor.actor(s, new Effect<A>(){

            @Override
            public void e(A a) {
                QueueActor.this.act(a);
            }
        });
    }

    private P1<Unit> work() {
        return this.suspended.compareAndSet(!this.mbox.isEmpty(), false) ? this.act.act(Unit.unit()) : P.p(Unit.unit());
    }

    public static <A> QueueActor<A> queueActor(Strategy<Unit> s, Effect<A> e) {
        return new QueueActor<A>(s, e);
    }

    public static <A> QueueActor<A> queueActor(Strategy<Unit> s, F<A, P1<Unit>> e) {
        return QueueActor.queueActor(s, Effect.Projection.f(Function.compose(P1.__1(), e)));
    }

    public Actor<A> asActor() {
        return this.selfish;
    }

    public void act(A a) {
        if (this.mbox.offer(a)) {
            this.work();
        } else {
            this.selfish.act(a);
        }
    }
}

