/*
 * Decompiled with CFR 0.152.
 */
package fj.control.parallel;

import fj.Effect;
import fj.F;
import fj.F2;
import fj.Function;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Unit;
import fj.control.parallel.Actor;
import fj.control.parallel.Callables;
import fj.control.parallel.QueueActor;
import fj.control.parallel.Strategy;
import fj.data.Either;
import fj.data.List;
import fj.data.Option;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Promise<A> {
    private final Actor<P2<Either<P1<A>, Actor<A>>, Promise<A>>> actor;
    private final Strategy<Unit> s;
    private final CountDownLatch l = new CountDownLatch(1);
    private volatile Option<A> v = Option.none();
    private final Queue<Actor<A>> waiting = new LinkedList<Actor<A>>();

    private Promise(Strategy<Unit> s, Actor<P2<Either<P1<A>, Actor<A>>, Promise<A>>> qa) {
        this.s = s;
        this.actor = qa;
    }

    private static <A> Promise<A> mkPromise(Strategy<Unit> s) {
        Actor<P2<Either<P1<A>, Actor<A>>, Promise<A>>> q = QueueActor.queueActor(s, new Effect<P2<Either<P1<A>, Actor<A>>, Promise<A>>>(){

            @Override
            public void e(P2<Either<P1<A>, Actor<A>>, Promise<A>> p) {
                Promise snd = p._2();
                Queue as = snd.waiting;
                if (p._1().isLeft()) {
                    Object a = p._1().left().value()._1();
                    snd.v = Option.some(a);
                    snd.l.countDown();
                    while (!as.isEmpty()) {
                        ((Actor)as.remove()).act(a);
                    }
                } else if (snd.v.isNone()) {
                    as.add(p._1().right().value());
                } else {
                    p._1().right().value().act(snd.v.some());
                }
            }
        }).asActor();
        return new Promise<A>(s, q);
    }

    public static <A> Promise<A> promise(Strategy<Unit> s, P1<A> a) {
        Promise<A> p = Promise.mkPromise(s);
        p.actor.act(P.p(Either.left(a), p));
        return p;
    }

    public static <A> F<P1<A>, Promise<A>> promise(final Strategy<Unit> s) {
        return new F<P1<A>, Promise<A>>(){

            @Override
            public Promise<A> f(P1<A> a) {
                return Promise.promise((Strategy<Unit>)s, a);
            }
        };
    }

    public static <A> Promise<Callable<A>> promise(Strategy<Unit> s, final Callable<A> a) {
        return Promise.promise(s, new P1<Callable<A>>(){

            @Override
            public Callable<A> _1() {
                return Callables.normalise(a);
            }
        });
    }

    public static <A, B> F<A, Promise<B>> promise(final Strategy<Unit> s, final F<A, B> f2) {
        return new F<A, Promise<B>>(){

            @Override
            public Promise<B> f(A a) {
                return Promise.promise((Strategy<Unit>)s, P1.curry(f2).f(a));
            }
        };
    }

    public void to(Actor<A> a) {
        this.actor.act(P.p(Either.right(a), this));
    }

    public <B> Promise<B> fmap(F<A, B> f2) {
        return this.bind(Promise.promise(this.s, f2));
    }

    public static <A, B> F<Promise<A>, Promise<B>> fmap_(final F<A, B> f2) {
        return new F<Promise<A>, Promise<B>>(){

            @Override
            public Promise<B> f(Promise<A> a) {
                return a.fmap(f2);
            }
        };
    }

    public static <A> Promise<A> join(Promise<Promise<A>> p) {
        F id2 = Function.identity();
        return p.bind(id2);
    }

    public static <A> Promise<A> join(Strategy<Unit> s, P1<Promise<A>> p) {
        return Promise.join(Promise.promise(s, p));
    }

    public <B> Promise<B> bind(F<A, Promise<B>> f2) {
        final Promise<A> r = Promise.mkPromise(this.s);
        Actor ab = Actor.actor(this.s, new Effect<B>(){

            @Override
            public void e(B b) {
                r.actor.act(P.p(Either.left(P.p(b)), r));
            }
        });
        this.to(ab.promise().comap(f2));
        return r;
    }

    public <B> Promise<B> apply(Promise<F<A, B>> pf) {
        return pf.bind(new F<F<A, B>, Promise<B>>(){

            @Override
            public Promise<B> f(F<A, B> f2) {
                return Promise.this.fmap(f2);
            }
        });
    }

    public <B, C> Promise<C> bind(Promise<B> pb, F<A, F<B, C>> f2) {
        return pb.apply(this.fmap(f2));
    }

    public <B, C> Promise<C> bind(P1<Promise<B>> p, F<A, F<B, C>> f2) {
        return Promise.join(this.s, p).apply(this.fmap(f2));
    }

    public static <A, B, C> F<Promise<A>, F<Promise<B>, Promise<C>>> liftM2(final F<A, F<B, C>> f2) {
        return Function.curry(new F2<Promise<A>, Promise<B>, Promise<C>>(){

            @Override
            public Promise<C> f(Promise<A> ca, Promise<B> cb) {
                return ca.bind(cb, f2);
            }
        });
    }

    public static <A> Promise<List<A>> sequence(Strategy<Unit> s, List<Promise<A>> as) {
        return Promise.join(Promise.foldRight(s, Promise.liftM2(List.cons()), Promise.promise(s, P.p(List.nil()))).f(as));
    }

    public static <A> F<List<Promise<A>>, Promise<List<A>>> sequence(final Strategy<Unit> s) {
        return new F<List<Promise<A>>, Promise<List<A>>>(){

            @Override
            public Promise<List<A>> f(List<Promise<A>> as) {
                return Promise.sequence(s, as);
            }
        };
    }

    public static <A, B> F<List<A>, Promise<B>> foldRight(final Strategy<Unit> s, final F<A, F<B, B>> f2, final B b) {
        return new F<List<A>, Promise<B>>(){

            @Override
            public Promise<B> f(List<A> as) {
                return as.isEmpty() ? Promise.promise((Strategy<Unit>)s, P.p(b)) : Promise.liftM2(f2).f(Promise.promise((Strategy<Unit>)s, P.p(as.head()))).f(Promise.join(s, P1.curry(this).f(as.tail())));
            }
        };
    }

    public A claim() throws InterruptedException {
        this.l.await();
        return this.v.some();
    }

    public A claim(long timeout, TimeUnit unit) throws InterruptedException {
        this.l.await(timeout, unit);
        return this.v.some();
    }

    public boolean isFulfilled() {
        return this.v.isSome();
    }
}

