/*
 * Decompiled with CFR 0.152.
 */
package endrov.starter;

import endrov.ev.EvBuild;
import endrov.util.EvFileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Start {
    private static boolean printJar = false;
    public String mainClass = "";
    private String javaver = System.getProperty("java.specification.version");
    private String OS = System.getProperty("os.name").toLowerCase();
    private String osExt = "";
    private String arch = System.getProperty("os.arch").toLowerCase();
    private int javaVerMajor = Integer.parseInt(this.javaver.substring(0, this.javaver.indexOf(46)));
    private int javarVerMinor = Integer.parseInt(this.javaver.substring(this.javaver.indexOf(46) + 1));
    private String cpsep = ":";
    private String libdir = "";
    private String javaexe = "java";
    public List<String> jarfiles = new LinkedList<String>();
    public List<String> binfiles = new LinkedList<String>();
    private ProcessBuilder pb = new ProcessBuilder("");
    private String jarstring = "";
    private String binstring = "";
    private String archExt = "";

    public static void main(String[] args) {
        new Start().run(args);
    }

    public void collectSystemInfo(String path) {
        this.collectSystemInfo(new File(path));
    }

    public void collectSystemInfo(File path) {
        this.cpsep = ":";
        this.archExt = this.arch.equals("ppc") ? "ppc" : "x86";
        if (this.OS.equals("mac os x")) {
            this.libdir = path + "libs/mac";
            this.osExt = "mac";
        } else if (this.OS.startsWith("windows")) {
            this.cpsep = ";";
            this.osExt = "windows";
        } else if (this.OS.startsWith("linux")) {
            this.osExt = "linux";
        } else if (this.OS.startsWith("solaris")) {
            this.osExt = "solaris";
        } else {
            JOptionPane.showMessageDialog(null, "Your OS + CPU combination is not supported at this moment. We would be happy if you got in\ntouch so we can support for your platform. If you want to do it yourself it is easy: Get\nlibraries for your platform (JAI and JOGL), edit endrov/starter/StartGUI.java and recompile.");
            System.exit(1);
        }
        this.jarstring = path.getAbsolutePath();
        Start.collectJars(this.jarfiles, this.binfiles, new File(path, "libs"), this.osExt, this.archExt);
        for (String s : this.jarfiles) {
            this.jarstring = String.valueOf(this.jarstring) + this.cpsep + s;
        }
        String ldlibpath = "";
        for (String s : this.binfiles) {
            if (!this.binstring.equals("")) {
                this.binstring = String.valueOf(this.binstring) + this.cpsep;
            }
            this.binstring = String.valueOf(this.binstring) + s;
            if (!ldlibpath.equals("")) {
                ldlibpath = String.valueOf(ldlibpath) + ":";
            }
            ldlibpath = String.valueOf(ldlibpath) + s;
        }
        this.libdir = this.binstring;
        this.pb.environment().put("LD_LIBRARY_PATH", ldlibpath);
    }

    public void run(String[] argsa) {
        boolean printMacStarter = false;
        boolean hasSpecifiedLibdir = false;
        boolean printCommand = false;
        File javaenvFile = null;
        File basedir = new File(".");
        String cp2 = "";
        int numNonflagArg = 0;
        LinkedList<String> args = new LinkedList<String>();
        int argi = 0;
        while (argi < argsa.length) {
            String curarg = argsa[argi];
            if (curarg.equals("--printcommand")) {
                printCommand = true;
            } else if (curarg.equals("--printjar")) {
                printJar = true;
            } else if (curarg.equals("--macstarter")) {
                this.OS = "mac os x";
                printMacStarter = true;
            } else if (args.contains("--version")) {
                System.out.println("Endrov " + EvBuild.version);
                System.exit(0);
            } else if (curarg.equals("--cp2")) {
                cp2 = String.valueOf(cp2) + ":" + argsa[argi + 1];
                ++argi;
            } else if (curarg.equals("--libpath2")) {
                this.binfiles.add(argsa[argi + 1]);
                ++argi;
            } else if (curarg.equals("--basedir")) {
                basedir = new File(argsa[argi + 1]);
                ++argi;
            } else if (curarg.equals("--main")) {
                this.mainClass = argsa[argi + 1];
                ++argi;
            } else if (curarg.equals("--javaenv")) {
                javaenvFile = new File(argsa[argi + 1]);
                ++argi;
            } else {
                if (!curarg.startsWith("--")) {
                    ++numNonflagArg;
                }
                args.add(curarg);
            }
            ++argi;
        }
        this.collectSystemInfo(basedir);
        System.out.println("This system runs OS:" + this.OS + " with java:" + this.javaver + " on arch:" + this.arch);
        if (this.javaVerMajor > 1 || this.javaVerMajor == 1 && this.javarVerMinor >= 5) {
            try {
                String line;
                BufferedReader envReader;
                Object line2;
                LinkedList<String> cmdarg = new LinkedList<String>();
                cmdarg.add(this.javaexe);
                cmdarg.add("-cp");
                cmdarg.add(String.valueOf(this.jarstring) + cp2);
                if (!this.libdir.equals("") && !hasSpecifiedLibdir) {
                    cmdarg.add("-Djava.library.path=" + this.libdir);
                }
                if (javaenvFile == null) {
                    javaenvFile = new File(new File("config"), "javaenv." + this.osExt + ".txt");
                }
                if (javaenvFile.exists() && (line2 = (envReader = new BufferedReader(new FileReader(javaenvFile))).readLine()) != null) {
                    StringTokenizer envTokenizer = new StringTokenizer((String)line2, " ");
                    while (envTokenizer.hasMoreTokens()) {
                        String tok = envTokenizer.nextToken();
                        cmdarg.add(tok);
                        System.out.println("Java environment flag: " + tok);
                    }
                }
                cmdarg.add(this.mainClass);
                for (String s : args) {
                    cmdarg.add(s);
                }
                if (printMacStarter) {
                    StringTokenizer t = new StringTokenizer(this.jarstring, ":");
                    File dot = new File(".");
                    int dotlen = dot.getAbsolutePath().length() - 1;
                    String tot = "";
                    while (t.hasMoreTokens()) {
                        String s = t.nextToken();
                        if (!tot.equals("")) {
                            tot = String.valueOf(tot) + ":";
                        }
                        tot = String.valueOf(tot) + "$APPLICATION/../" + s.substring(dotlen);
                    }
                    System.out.println(tot);
                    File dotdir = new File(".");
                    String loclibdir = this.libdir.replace(String.valueOf(dotdir.getAbsolutePath()) + "/", "");
                    String[] stringArray = new String[]{"Endrov.app", "ImServ.app", "OSTdaemon.app"};
                    int n = 0;
                    int n2 = stringArray.length;
                    while (n < n2) {
                        String app = stringArray[n];
                        String template = EvFileUtil.readFile((File)new File(String.valueOf(app) + "/Contents/Resources/preinfo.txt"));
                        File out = new File(String.valueOf(app) + "/Contents/Info.plist");
                        EvFileUtil.writeFile((File)out, (String)template.replace("JARLIST", tot).replace("SOLIST", loclibdir));
                        System.out.println("Wrote to " + out);
                        ++n;
                    }
                    FileWriter fw = new FileWriter(new File("Endrov.app/Contents/Resources/jars.txt"));
                    fw.write(tot);
                    fw.flush();
                    fw.close();
                    System.exit(0);
                }
                this.pb.command(cmdarg);
                if (printCommand) {
                    String totalCmd = "";
                    for (String s : this.pb.command()) {
                        totalCmd = String.valueOf(totalCmd) + s + " ";
                    }
                    System.out.println(totalCmd);
                }
                final Process p = this.pb.start();
                new Thread(){

                    public synchronized void run() {
                        BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        try {
                            String line;
                            while ((line = br.readLine()) != null) {
                                if (line.startsWith("Could not create the Java Virtual Machine")) {
                                    JOptionPane.showMessageDialog(null, "Trouble creating virtual machine. Try to reduce the ammount of memory allocated");
                                }
                                System.err.println(line);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }.start();
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println("Process exited");
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Was unable to exec command. Full error:\n" + e.getMessage());
                e.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(null, "Your version of Java is too old. It must be at least 1.5");
        }
    }

    private static void addJar(List<String> v, String toadd) {
        v.add(toadd);
        if (printJar) {
            System.out.println("Adding java library: " + toadd);
        }
    }

    private static void collectJars(List<String> v, List<String> binfiles, File p, String osExt, String archExt) {
        if (p.exists()) {
            File[] fileArray = p.listFiles();
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                File sub = fileArray[n];
                if (sub.isFile() && (sub.getName().endsWith(".jar") || sub.getName().endsWith(".zip"))) {
                    Start.addJar(v, sub.getAbsolutePath());
                } else if (sub.isFile() && sub.getName().endsWith(".paths")) {
                    try {
                        String line;
                        BufferedReader input = new BufferedReader(new FileReader(sub));
                        while ((line = input.readLine()) != null) {
                            if (line.startsWith("j:")) {
                                Start.addJar(v, line.substring(2));
                                continue;
                            }
                            binfiles.add(line.substring(2));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (sub.isDirectory() && sub.getName().endsWith("_inc") && !sub.getName().startsWith(".") && !sub.getName().equals("unused")) {
                    Start.collectJars(v, binfiles, sub, osExt, archExt);
                } else if (sub.isDirectory() && (sub.getName().equals("bin_" + osExt) || sub.getName().equals("bin_" + archExt))) {
                    Start.collectJars(v, binfiles, sub, osExt, archExt);
                    String toadd = sub.getAbsolutePath();
                    binfiles.add(toadd);
                    if (printJar) {
                        System.out.println("Adding binary directory: " + toadd);
                    }
                }
                ++n;
            }
        }
    }
}

