/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.util.HashSet;
import java.util.Set;
import ome.model.IObject;
import ome.model.containers.Dataset;
import ome.model.containers.Project;
import ome.util.CBlock;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.SetMutator;

public class ProjectData
extends DataObject {
    public static final String NAME = "Project_name";
    public static final String DESCRIPTION = "Project_description";
    public static final String DATASET_LINKS = "Project_datasetLinks";
    private Set datasets;

    public ProjectData() {
        this.setDirty(true);
        this.setValue((IObject)new Project());
    }

    public ProjectData(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue((IObject)project);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        this.setDirty(true);
        this.asProject().setName(name);
    }

    public String getName() {
        return this.asProject().getName();
    }

    public void setDescription(String description) {
        this.setDirty(true);
        this.asProject().setDescription(description);
    }

    public String getDescription() {
        return this.asProject().getDescription();
    }

    public Set getDatasets() {
        if (this.datasets == null && this.asProject().sizeOfDatasetLinks() >= 0) {
            this.datasets = new HashSet(this.asProject().eachLinkedDataset(new CBlock(){

                public Object call(IObject object) {
                    return new DatasetData((Dataset)object);
                }
            }));
        }
        return this.datasets == null ? null : new HashSet(this.datasets);
    }

    public void setDatasets(Set newValue) {
        Set currentValue = this.getDatasets();
        SetMutator m = new SetMutator(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asProject().unlinkDataset(m.nextDeletion().asDataset());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asProject().linkDataset(m.nextAddition().asDataset());
        }
        this.datasets = m.result();
    }
}

