/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import ome.model.IObject;
import ome.model.core.Pixels;
import ome.model.core.PixelsDimensions;
import ome.model.enums.PixelsType;
import pojos.DataObject;
import pojos.ImageData;

public class PixelsData
extends DataObject {
    public static final String IMAGE = "Pixels_image";
    public static final String INT8_TYPE = "int8";
    public static final String INT16_TYPE = "int16";
    public static final String INT32_TYPE = "int32";
    public static final String UINT8_TYPE = "uint8";
    public static final String UINT16_TYPE = "uint16";
    public static final String UINT32_TYPE = "uint32";
    public static final String FLOAT_TYPE = "float";
    public static final String DOUBLE_TYPE = "double";
    public static final String COMPLEX_TYPE = "complex";
    public static final String DOUBLE_COMPLEX_TYPE = "double-complex";
    private ImageData image;

    public PixelsData() {
        this.setDirty(true);
        this.setValue((IObject)new Pixels());
    }

    public PixelsData(Pixels pixels) {
        if (pixels == null) {
            throw new IllegalArgumentException("The object cannot be null.");
        }
        this.setValue((IObject)pixels);
    }

    public void setSizeX(int sizeX) {
        this.setDirty(true);
        this.asPixels().setSizeX(new Integer(sizeX));
    }

    public int getSizeX() {
        return this.nullSafe(this.asPixels().getSizeX());
    }

    public void setSizeY(int sizeY) {
        this.setDirty(true);
        this.asPixels().setSizeY(new Integer(sizeY));
    }

    public int getSizeY() {
        return this.nullSafe(this.asPixels().getSizeY());
    }

    public void setSizeZ(int sizeZ) {
        this.setDirty(true);
        this.asPixels().setSizeZ(new Integer(sizeZ));
    }

    public int getSizeZ() {
        return this.nullSafe(this.asPixels().getSizeZ());
    }

    public void setSizeC(int sizeC) {
        this.setDirty(true);
        this.asPixels().setSizeC(new Integer(sizeC));
    }

    public int getSizeC() {
        return this.nullSafe(this.asPixels().getSizeC());
    }

    public void setSizeT(int sizeT) {
        this.setDirty(true);
        this.asPixels().setSizeT(new Integer(sizeT));
    }

    public int getSizeT() {
        return this.nullSafe(this.asPixels().getSizeT());
    }

    public void setPixelSizeX(double pixelSizeX) {
        this.setDirty(true);
        PixelsDimensions dims = this.asPixels().getPixelsDimensions();
        if (dims != null) {
            dims.setSizeX(new Float(pixelSizeX));
        }
    }

    public double getPixelSizeX() {
        PixelsDimensions dims = this.asPixels().getPixelsDimensions();
        return dims == null ? 1.0 : (double)this.nullSafe(dims.getSizeX());
    }

    public void setPixelSizeY(double pixelSizeY) {
        this.setDirty(true);
        PixelsDimensions dims = this.asPixels().getPixelsDimensions();
        if (dims != null) {
            dims.setSizeY(new Float(pixelSizeY));
        }
    }

    public double getPixelSizeY() {
        PixelsDimensions dims = this.asPixels().getPixelsDimensions();
        return dims == null ? 1.0 : (double)this.nullSafe(dims.getSizeY());
    }

    public void setPixelSizeZ(double pixelSizeZ) {
        this.setDirty(true);
        PixelsDimensions dims = this.asPixels().getPixelsDimensions();
        if (dims != null) {
            dims.setSizeZ(new Float(pixelSizeZ));
        }
    }

    public double getPixelSizeZ() {
        PixelsDimensions dims = this.asPixels().getPixelsDimensions();
        return dims == null ? 1.0 : (double)this.nullSafe(dims.getSizeZ());
    }

    public String getPixelType() {
        PixelsType type = this.asPixels().getPixelsType();
        return type == null ? null : type.getValue();
    }

    public ImageData getImage() {
        if (this.image == null && this.asPixels().getImage() != null) {
            this.image = new ImageData(this.asPixels().getImage());
        }
        return this.image;
    }

    public void setImage(ImageData image) {
        this.setDirty(true);
        this.image = image;
        if (image == null) {
            this.asPixels().setImage(null);
        } else {
            this.asPixels().setImage(image.asImage());
        }
    }
}

