/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import ome.model.internal.Permissions;

public class PermissionData {
    private Permissions p;

    public PermissionData() {
        this.p = new Permissions();
    }

    public PermissionData(Permissions permissions) {
        this.p = permissions;
    }

    public boolean isGroupRead() {
        return this.p.isGranted(Permissions.Role.GROUP, Permissions.Right.READ);
    }

    public boolean isGroupWrite() {
        return this.p.isGranted(Permissions.Role.GROUP, Permissions.Right.WRITE);
    }

    public boolean isUserRead() {
        return this.p.isGranted(Permissions.Role.USER, Permissions.Right.READ);
    }

    public boolean isUserWrite() {
        return this.p.isGranted(Permissions.Role.USER, Permissions.Right.WRITE);
    }

    public boolean isWorldRead() {
        return this.p.isGranted(Permissions.Role.WORLD, Permissions.Right.READ);
    }

    public boolean isWorldWrite() {
        return this.p.isGranted(Permissions.Role.WORLD, Permissions.Right.WRITE);
    }

    public void setGroupRead(boolean groupRead) {
        this.set(groupRead, Permissions.Role.GROUP, Permissions.Right.READ);
    }

    public void setGroupWrite(boolean groupWrite) {
        this.set(groupWrite, Permissions.Role.GROUP, Permissions.Right.WRITE);
    }

    public void setUserRead(boolean userRead) {
        this.set(userRead, Permissions.Role.USER, Permissions.Right.READ);
    }

    public void setUserWrite(boolean userWrite) {
        this.set(userWrite, Permissions.Role.USER, Permissions.Right.WRITE);
    }

    public void setWorldRead(boolean worldRead) {
        this.set(worldRead, Permissions.Role.WORLD, Permissions.Right.READ);
    }

    public void setWorldWrite(boolean worldWrite) {
        this.set(worldWrite, Permissions.Role.WORLD, Permissions.Right.WRITE);
    }

    public boolean isLocked() {
        return this.p.isSet(Permissions.Flag.LOCKED);
    }

    public void setLocked(boolean locked) {
        this.set(locked, Permissions.Flag.LOCKED);
    }

    private void set(boolean grant, Permissions.Role role, Permissions.Right right) {
        if (grant) {
            this.p.grant(role, new Permissions.Right[]{right});
        } else {
            this.p.revoke(role, new Permissions.Right[]{right});
        }
    }

    private void set(boolean set, Permissions.Flag flag) {
        if (set) {
            this.p.set(flag);
        } else {
            this.p.unSet(flag);
        }
    }
}

