/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.util.HashSet;
import java.util.Set;
import ome.model.IObject;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.util.CBlock;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.SetMutator;

public class GroupData
extends DataObject {
    public static final String NAME = "ExperimenterGroup_name";
    public static final String DESCRIPTION = "ExperimenterGroup_description";
    public static final String GROUP_EXPERIMENTER_MAP = "ExperimenterGroup_groupExperimenterMap";
    private Set experimenters;

    public GroupData() {
        this.setDirty(true);
        this.setValue((IObject)new ExperimenterGroup());
    }

    public GroupData(ExperimenterGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("Annotation cannot null.");
        }
        this.setValue((IObject)group);
    }

    public String getName() {
        return this.asGroup().getName();
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        this.setDirty(true);
        this.asGroup().setName(name);
    }

    public Set getExperimenters() {
        if (this.experimenters == null && this.asGroup().sizeOfGroupExperimenterMap() >= 0) {
            this.experimenters = new HashSet(this.asGroup().eachLinkedExperimenter(new CBlock(){

                public Object call(IObject object) {
                    return new ExperimenterData((Experimenter)object);
                }
            }));
        }
        return this.experimenters == null ? null : new HashSet(this.experimenters);
    }

    public void setExperimenters(Set newValue) {
        Set currentValue = this.getExperimenters();
        SetMutator m = new SetMutator(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asGroup().unlinkExperimenter(m.nextDeletion().asExperimenter());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asGroup().linkExperimenter(m.nextAddition().asExperimenter());
        }
        this.experimenters = m.result();
    }
}

