/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.util.HashSet;
import java.util.Set;
import ome.model.IObject;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.GroupExperimenterMap;
import ome.util.CBlock;
import pojos.DataObject;
import pojos.GroupData;
import pojos.SetMutator;

public class ExperimenterData
extends DataObject {
    public static final String FIRSTENAME = "Experimenter_firstName";
    public static final String MIDDLENAME = "Experimenter_middleName";
    public static final String LASTNAME = "Experimenter_lastName";
    public static final String EMAIL = "Experimenter_email";
    public static final String OMENAME = "Experimenter_omeName";
    public static final String INSTITUTION = "Experimenter_institution";
    public static final String GROUP_EXPERIMENTER_MAP = "Experimenter_groupExperimenterMap";
    private GroupData defaultGroup;
    private Set groups;

    public ExperimenterData() {
        this.setDirty(true);
        this.setValue((IObject)new Experimenter());
    }

    public ExperimenterData(Experimenter experimenter) {
        if (experimenter == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue((IObject)experimenter);
    }

    public void setFirstName(String firstName) {
        this.setDirty(true);
        this.asExperimenter().setFirstName(firstName);
    }

    public String getFirstName() {
        return this.asExperimenter().getFirstName();
    }

    public void setLastName(String lastName) {
        this.setDirty(true);
        this.asExperimenter().setLastName(lastName);
    }

    public String getLastName() {
        return this.asExperimenter().getLastName();
    }

    public void setEmail(String email) {
        this.setDirty(true);
        this.asExperimenter().setEmail(email);
    }

    public String getEmail() {
        return this.asExperimenter().getEmail();
    }

    public void setInstitution(String institution) {
        this.setDirty(true);
        this.asExperimenter().setInstitution(institution);
    }

    public String getInstitution() {
        return this.asExperimenter().getInstitution();
    }

    public Set getGroups() {
        if (this.groups == null && this.asExperimenter().sizeOfGroupExperimenterMap() >= 0) {
            this.groups = new HashSet(this.asExperimenter().eachLinkedExperimenterGroup(new CBlock(){

                public Object call(IObject object) {
                    return new GroupData((ExperimenterGroup)object);
                }
            }));
        }
        return this.groups == null ? null : new HashSet(this.groups);
    }

    public void setGroups(Set newValue) {
        Set currentValue = this.getGroups();
        SetMutator m = new SetMutator(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asExperimenter().unlinkExperimenterGroup(m.nextDeletion().asGroup());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asExperimenter().linkExperimenterGroup(m.nextAddition().asGroup());
        }
        this.groups = m.result();
    }

    public GroupData getDefaultGroup() {
        if (this.defaultGroup == null && this.asExperimenter().getDefaultGroupLink() != null) {
            this.defaultGroup = new GroupData(this.asExperimenter().getDefaultGroupLink().parent());
        }
        return this.defaultGroup;
    }

    public void setDefaultGroup(GroupData group) {
        if (this.getDefaultGroup() == group) {
            return;
        }
        this.setDirty(true);
        this.defaultGroup = group;
        if (this.defaultGroup != null) {
            final ExperimenterGroup g = group.asGroup();
            this.asExperimenter().collectGroupExperimenterMap(new CBlock(){

                public Object call(IObject object) {
                    GroupExperimenterMap map = (GroupExperimenterMap)object;
                    if (map.parent() == g) {
                        map.setDefaultGroupLink(Boolean.TRUE);
                    } else {
                        map.setDefaultGroupLink(Boolean.FALSE);
                    }
                    return null;
                }
            });
        }
    }
}

