/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.DatasetAnnotation;
import ome.model.annotations.ImageAnnotation;
import ome.model.containers.Category;
import ome.model.containers.CategoryGroup;
import ome.model.containers.Dataset;
import ome.model.containers.Project;
import ome.model.core.Image;
import ome.model.core.Pixels;
import ome.model.internal.Details;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import pojos.AnnotationData;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.PermissionData;
import pojos.PixelsData;
import pojos.ProjectData;

public abstract class DataObject {
    private IObject value = null;
    private ExperimenterData owner = null;
    private PermissionData permissions = null;
    private boolean dirty = false;

    public static Set asPojos(Set iObjects) {
        HashSet<DataObject> result = new HashSet<DataObject>();
        for (IObject obj : iObjects) {
            DataObject converted = DataObject.asPojo(obj);
            result.add(converted);
        }
        return result;
    }

    public static Map asPojos(Map iObjects) {
        HashMap result = new HashMap();
        for (Object key : iObjects.keySet()) {
            Object value = iObjects.get(key);
            DataObject convertedKey = null;
            DataObject convertedValue = null;
            if (key instanceof IObject) {
                convertedKey = DataObject.asPojo((IObject)iObjects.get(key));
            }
            if (value instanceof IObject) {
                convertedValue = DataObject.asPojo((IObject)iObjects.get(value));
            }
            result.put(null == convertedKey ? key : convertedKey, null == convertedValue ? value : convertedValue);
        }
        return result;
    }

    public static DataObject asPojo(IObject obj) {
        DataObject converted = null;
        if (obj instanceof Project) {
            converted = new ProjectData((Project)obj);
        } else if (obj instanceof Dataset) {
            converted = new DatasetData((Dataset)obj);
        } else if (obj instanceof DatasetAnnotation) {
            converted = new AnnotationData((DatasetAnnotation)obj);
        } else if (obj instanceof Image) {
            converted = new ImageData((Image)obj);
        } else if (obj instanceof ImageAnnotation) {
            converted = new AnnotationData((ImageAnnotation)obj);
        } else if (obj instanceof CategoryGroup) {
            converted = new CategoryGroupData((CategoryGroup)obj);
        } else if (obj instanceof Category) {
            converted = new CategoryData((Category)obj);
        } else if (obj instanceof Pixels) {
            converted = new PixelsData((Pixels)obj);
        } else if (obj instanceof Experimenter) {
            converted = new ExperimenterData((Experimenter)obj);
        } else if (obj instanceof ExperimenterGroup) {
            converted = new GroupData((ExperimenterGroup)obj);
        } else if (obj != null) {
            throw new IllegalArgumentException("Unknown type: " + obj.getClass().getName());
        }
        return converted;
    }

    protected void setValue(IObject value) {
        if (value == null) {
            throw new IllegalArgumentException("IObject delegate for DataObject cannot be null.");
        }
        this.value = value;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public long getId() {
        return this.value.getId() == null ? -1L : this.value.getId();
    }

    public void setId(long id) {
        this.setDirty(true);
        this.value.setId(new Long(id));
    }

    protected int getVersion() {
        if (this.value instanceof IMutable) {
            IMutable m = (IMutable)this.value;
            return m.getVersion() == null ? 0 : m.getVersion();
        }
        return 0;
    }

    protected void setVersion(int version) {
        if (this.value instanceof IMutable) {
            IMutable m = (IMutable)this.value;
            this.setDirty(true);
            m.setVersion(new Integer(version));
        }
    }

    public boolean isLoaded() {
        return this.value.isLoaded();
    }

    protected Set getFiltered() {
        return new HashSet(this.value.getDetails().filteredSet());
    }

    public boolean isFiltered(String fieldName) {
        if (fieldName == null) {
            return false;
        }
        return this.value.getDetails().filteredSet() == null ? false : this.value.getDetails().filteredSet().contains(fieldName);
    }

    public ExperimenterData getOwner() {
        if (this.owner == null) {
            this.owner = new ExperimenterData(this.asIObject().getDetails().getOwner());
        }
        return this.owner;
    }

    public PermissionData getPermissions() {
        if (this.permissions == null) {
            this.permissions = new PermissionData(this.getDetails().getPermissions());
        }
        return this.permissions;
    }

    public String toString() {
        return this.getClass().getName() + " (id=" + this.getId() + ")";
    }

    protected int nullSafe(Integer i) {
        return i == null ? 0 : i;
    }

    protected long nullSafe(Long l) {
        return l == null ? 0L : l;
    }

    protected double nullSafe(Double d) {
        return d == null ? 0.0 : d;
    }

    protected float nullSafe(Float f) {
        return f == null ? 0.0f : f.floatValue();
    }

    protected Timestamp timeOfEvent(Event event) {
        if (event == null || !event.isLoaded() || event.getTime() == null) {
            throw new IllegalStateException("Event does not contain timestamp.");
        }
        return new Timestamp(event.getTime().getTime());
    }

    protected boolean nullDetails() {
        return this.asIObject().getDetails() == null;
    }

    protected Details getDetails() {
        return this.asIObject().getDetails();
    }

    protected Long getCount(String countName) {
        Object count = null;
        if (!this.nullDetails() && countName != null && this.getDetails().getCounts() != null) {
            count = this.getDetails().getCounts().get(countName);
        }
        if (count instanceof Long) {
            return count;
        }
        return null;
    }

    public IObject asIObject() {
        return this.value;
    }

    public Experimenter asExperimenter() {
        return (Experimenter)this.asIObject();
    }

    public ExperimenterGroup asGroup() {
        return (ExperimenterGroup)this.asIObject();
    }

    public ImageAnnotation asImageAnnotation() {
        return (ImageAnnotation)this.asIObject();
    }

    public DatasetAnnotation asDatasetAnnotation() {
        return (DatasetAnnotation)this.asIObject();
    }

    public Image asImage() {
        return (Image)this.asIObject();
    }

    public Dataset asDataset() {
        return (Dataset)this.asIObject();
    }

    public Category asCategory() {
        return (Category)this.asIObject();
    }

    public CategoryGroup asCategoryGroup() {
        return (CategoryGroup)this.asIObject();
    }

    public Project asProject() {
        return (Project)this.asIObject();
    }

    public Pixels asPixels() {
        return (Pixels)this.asIObject();
    }
}

