/*
 * Decompiled with CFR 0.152.
 */
package pojos;

import java.util.HashSet;
import java.util.Set;
import ome.model.IObject;
import ome.model.containers.Category;
import ome.model.containers.CategoryGroup;
import ome.util.CBlock;
import pojos.CategoryData;
import pojos.DataObject;
import pojos.SetMutator;

public class CategoryGroupData
extends DataObject {
    public static final String NAME = "CategoryGroup_name";
    public static final String DESCRIPTION = "CategoryGroup_description";
    public static final String CATEGORY_LINKS = "CategoryGroup_categoryLinks";
    private Set categories;

    public CategoryGroupData() {
        this.setDirty(true);
        this.setValue((IObject)new CategoryGroup());
    }

    public CategoryGroupData(CategoryGroup group) {
        this.setValue((IObject)group);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        this.setDirty(true);
        this.asCategoryGroup().setName(name);
    }

    public String getName() {
        return this.asCategoryGroup().getName();
    }

    public void setDescription(String description) {
        this.setDirty(true);
        this.asCategoryGroup().setDescription(description);
    }

    public String getDescription() {
        return this.asCategoryGroup().getDescription();
    }

    public Set getCategories() {
        if (this.categories == null && this.asCategoryGroup().sizeOfCategoryLinks() >= 0) {
            this.categories = new HashSet(this.asCategoryGroup().eachLinkedCategory(new CBlock(){

                public Object call(IObject object) {
                    return new CategoryData((Category)object);
                }
            }));
        }
        return this.categories == null ? null : new HashSet(this.categories);
    }

    public void setCategories(Set newValue) {
        Set currentValue = this.getCategories();
        SetMutator m = new SetMutator(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asCategoryGroup().unlinkCategory(m.nextDeletion().asCategory());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asCategoryGroup().linkCategory(m.nextAddition().asCategory());
        }
        this.categories = m.result();
    }
}

